/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.durability.db.kraft.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.durability.db.kraft.serdes.EpochChainWithLeader;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class KRaftPartitionInfo
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_25_2_10();
    }

    public static KRaftPartitionInfo getRootAsKRaftPartitionInfo(ByteBuffer _bb) {
        return KRaftPartitionInfo.getRootAsKRaftPartitionInfo(_bb, new KRaftPartitionInfo());
    }

    public static KRaftPartitionInfo getRootAsKRaftPartitionInfo(ByteBuffer _bb, KRaftPartitionInfo obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public KRaftPartitionInfo __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String topicId() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicIdAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer topicIdInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public String topic() {
        int o = this.__offset(6);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer topicAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 1);
    }

    public ByteBuffer topicInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 1);
    }

    public int partition() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public EpochChainWithLeader epochChain(int j) {
        return this.epochChain(new EpochChainWithLeader(), j);
    }

    public EpochChainWithLeader epochChain(EpochChainWithLeader obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o) + j * 24, this.bb) : null;
    }

    public int epochChainLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public EpochChainWithLeader.Vector epochChainVector() {
        return this.epochChainVector(new EpochChainWithLeader.Vector());
    }

    public EpochChainWithLeader.Vector epochChainVector(EpochChainWithLeader.Vector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), 24, this.bb) : null;
    }

    public long localLogStartOffset() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long leaderHighWatermark() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long localHighWatermark() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public long lastKnownFetchOffset() {
        int o = this.__offset(18);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean hasFetchOffsetIncreasedInCurrentEpoch() {
        int o = this.__offset(20);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public OffsetAndEpoch latestSnapshotId() {
        return this.latestSnapshotId(new OffsetAndEpoch());
    }

    public OffsetAndEpoch latestSnapshotId(OffsetAndEpoch obj) {
        int o = this.__offset(22);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public static void startKRaftPartitionInfo(FlatBufferBuilder builder) {
        builder.startTable(10);
    }

    public static void addTopicId(FlatBufferBuilder builder, int topicIdOffset) {
        builder.addOffset(0, topicIdOffset, 0);
    }

    public static void addTopic(FlatBufferBuilder builder, int topicOffset) {
        builder.addOffset(1, topicOffset, 0);
    }

    public static void addPartition(FlatBufferBuilder builder, int partition) {
        builder.addInt(2, partition, 0);
    }

    public static void addEpochChain(FlatBufferBuilder builder, int epochChainOffset) {
        builder.addOffset(3, epochChainOffset, 0);
    }

    public static void startEpochChainVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(24, numElems, 8);
    }

    public static void addLocalLogStartOffset(FlatBufferBuilder builder, long localLogStartOffset) {
        builder.addLong(4, localLogStartOffset, 0L);
    }

    public static void addLeaderHighWatermark(FlatBufferBuilder builder, long leaderHighWatermark) {
        builder.addLong(5, leaderHighWatermark, 0L);
    }

    public static void addLocalHighWatermark(FlatBufferBuilder builder, long localHighWatermark) {
        builder.addLong(6, localHighWatermark, 0L);
    }

    public static void addLastKnownFetchOffset(FlatBufferBuilder builder, long lastKnownFetchOffset) {
        builder.addLong(7, lastKnownFetchOffset, 0L);
    }

    public static void addHasFetchOffsetIncreasedInCurrentEpoch(FlatBufferBuilder builder, boolean hasFetchOffsetIncreasedInCurrentEpoch) {
        builder.addBoolean(8, hasFetchOffsetIncreasedInCurrentEpoch, false);
    }

    public static void addLatestSnapshotId(FlatBufferBuilder builder, int latestSnapshotIdOffset) {
        builder.addStruct(9, latestSnapshotIdOffset, 0);
    }

    public static int endKRaftPartitionInfo(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishKRaftPartitionInfoBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedKRaftPartitionInfoBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public KRaftPartitionInfo get(int j) {
            return this.get(new KRaftPartitionInfo(), j);
        }

        public KRaftPartitionInfo get(KRaftPartitionInfo obj, int j) {
            return obj.__assign(KRaftPartitionInfo.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

