/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.TierCompactionCommitAndSwap;
import io.confluent.kafka.storage.tier.domain.TierMetadataSnapshotUploadComplete;
import io.confluent.kafka.storage.tier.domain.TierMetadataSnapshotUploadInitiate;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteComplete;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteInitiate;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeletePreInitiate;
import io.confluent.kafka.storage.tier.domain.TierPartitionFence;
import io.confluent.kafka.storage.tier.domain.TierPartitionForceRestore;
import io.confluent.kafka.storage.tier.domain.TierPartitionUnfence;
import io.confluent.kafka.storage.tier.domain.TierPartitionUnfreezeLogStartOffset;
import io.confluent.kafka.storage.tier.domain.TierRecordType;
import io.confluent.kafka.storage.tier.domain.TierSegmentDeleteComplete;
import io.confluent.kafka.storage.tier.domain.TierSegmentDeleteInitiate;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadComplete;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadInitiate;
import io.confluent.kafka.storage.tier.domain.TierTopicInitLeader;
import io.confluent.kafka.storage.tier.exception.TierMetadataDeserializationException;
import io.confluent.kafka.storage.tier.serdes.CompactionCommitAndSwap;
import io.confluent.kafka.storage.tier.serdes.InitLeader;
import io.confluent.kafka.storage.tier.serdes.MetadataSnapshotUploadComplete;
import io.confluent.kafka.storage.tier.serdes.MetadataSnapshotUploadInitiate;
import io.confluent.kafka.storage.tier.serdes.PartitionDeleteComplete;
import io.confluent.kafka.storage.tier.serdes.PartitionDeleteInitiate;
import io.confluent.kafka.storage.tier.serdes.PartitionDeletePreInitiate;
import io.confluent.kafka.storage.tier.serdes.PartitionFence;
import io.confluent.kafka.storage.tier.serdes.PartitionForceRestore;
import io.confluent.kafka.storage.tier.serdes.PartitionUnfence;
import io.confluent.kafka.storage.tier.serdes.PartitionUnfreezeLogStartOffset;
import io.confluent.kafka.storage.tier.serdes.SegmentDeleteComplete;
import io.confluent.kafka.storage.tier.serdes.SegmentDeleteInitiate;
import io.confluent.kafka.storage.tier.serdes.SegmentUploadComplete;
import io.confluent.kafka.storage.tier.serdes.SegmentUploadInitiate;
import io.confluent.kafka.storage.tier.serdes.TierKafkaKey;
import io.confluent.kafka.storage.tier.state.OffsetAndEpoch;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTierMetadata {
    private static final Logger log = LoggerFactory.getLogger(AbstractTierMetadata.class);
    private static final int KEY_INITIAL_LENGTH = 200;
    private static final int TYPE_LENGTH = 1;
    protected long timestamp = Long.MAX_VALUE;

    public byte[] serializeKey() {
        FlatBufferBuilder builder = new FlatBufferBuilder(200);
        int topicNameOffset = builder.createString((CharSequence)this.topicIdPartition().topic());
        int topicIdOffset = io.confluent.kafka.storage.tier.serdes.UUID.createUUID(builder, this.topicIdPartition().topicId().getMostSignificantBits(), this.topicIdPartition().topicId().getLeastSignificantBits());
        TierKafkaKey.startTierKafkaKey(builder);
        TierKafkaKey.addTopicId(builder, topicIdOffset);
        TierKafkaKey.addPartition(builder, this.topicIdPartition().topicPartition().partition());
        TierKafkaKey.addTopicName(builder, topicNameOffset);
        int entryId = TierKafkaKey.endTierKafkaKey(builder);
        builder.finish(entryId);
        ByteBuffer buffer = builder.dataBuffer();
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public byte[] serializeValue() {
        ByteBuffer payload = this.payloadBuffer();
        ByteBuffer buf = ByteBuffer.allocate(payload.remaining() + 1);
        buf.put(TierRecordType.toByte(this.type()));
        buf.put(payload);
        return buf.array();
    }

    public static byte getTypeId(byte[] value) {
        return value[0];
    }

    public static TopicIdPartition deserializeKey(byte[] key) {
        return AbstractTierMetadata.deserializeKey(ByteBuffer.wrap(key));
    }

    public static TopicIdPartition deserializeKey(ByteBuffer key) {
        TierKafkaKey tierKey = TierKafkaKey.getRootAsTierKafkaKey(key);
        return new TopicIdPartition(tierKey.topicName(), new UUID(tierKey.topicId().mostSignificantBits(), tierKey.topicId().leastSignificantBits()), tierKey.partition());
    }

    public static Optional<AbstractTierMetadata> deserialize(byte[] key, byte[] value, long timestamp) throws TierMetadataDeserializationException {
        try {
            return AbstractTierMetadata.deserialize(ByteBuffer.wrap(key), ByteBuffer.wrap(value), timestamp);
        }
        catch (Exception e) {
            throw new TierMetadataDeserializationException(String.format("Deserialization error [%s]", e.getMessage()), e);
        }
    }

    public static Optional<AbstractTierMetadata> deserialize(ByteBuffer key, ByteBuffer value, long timestamp) throws TierMetadataDeserializationException {
        TopicIdPartition topicIdPartition = AbstractTierMetadata.deserializeKey(key);
        TierRecordType type = TierRecordType.toType(value.get());
        switch (type) {
            case InitLeader: {
                InitLeader initLeader = InitLeader.getRootAsInitLeader(value);
                return Optional.of(new TierTopicInitLeader(topicIdPartition, initLeader));
            }
            case SegmentUploadInitiate: {
                SegmentUploadInitiate uploadInitiate = SegmentUploadInitiate.getRootAsSegmentUploadInitiate(value);
                return Optional.of(new TierSegmentUploadInitiate(topicIdPartition, uploadInitiate));
            }
            case SegmentUploadComplete: {
                SegmentUploadComplete uploadComplete = SegmentUploadComplete.getRootAsSegmentUploadComplete(value);
                return Optional.of(new TierSegmentUploadComplete(topicIdPartition, uploadComplete));
            }
            case CompactionCommitAndSwap: {
                CompactionCommitAndSwap compactionCommitAndSwap = CompactionCommitAndSwap.getRootAsCompactionCommitAndSwap(value);
                return Optional.of(new TierCompactionCommitAndSwap(topicIdPartition, compactionCommitAndSwap));
            }
            case SegmentDeleteInitiate: {
                SegmentDeleteInitiate deleteInitiate = SegmentDeleteInitiate.getRootAsSegmentDeleteInitiate(value);
                return Optional.of(new TierSegmentDeleteInitiate(topicIdPartition, deleteInitiate));
            }
            case SegmentDeleteComplete: {
                SegmentDeleteComplete deleteComplete = SegmentDeleteComplete.getRootAsSegmentDeleteComplete(value);
                return Optional.of(new TierSegmentDeleteComplete(topicIdPartition, deleteComplete, timestamp));
            }
            case PartitionDeleteInitiate: {
                PartitionDeleteInitiate partitionDeleteInitiate = PartitionDeleteInitiate.getRootAsPartitionDeleteInitiate(value);
                return Optional.of(new TierPartitionDeleteInitiate(topicIdPartition, partitionDeleteInitiate));
            }
            case PartitionDeletePreInitiate: {
                PartitionDeletePreInitiate partitionDeletePreInitiate = PartitionDeletePreInitiate.getRootAsPartitionDeletePreInitiate(value);
                return Optional.of(new TierPartitionDeletePreInitiate(topicIdPartition, partitionDeletePreInitiate));
            }
            case PartitionDeleteComplete: {
                PartitionDeleteComplete partitionDeleteComplete = PartitionDeleteComplete.getRootAsPartitionDeleteComplete(value);
                return Optional.of(new TierPartitionDeleteComplete(topicIdPartition, partitionDeleteComplete));
            }
            case PartitionFence: {
                PartitionFence partitionFence = PartitionFence.getRootAsPartitionFence(value);
                return Optional.of(new TierPartitionFence(topicIdPartition, partitionFence));
            }
            case PartitionForceRestore: {
                PartitionForceRestore partitionForceRestore = PartitionForceRestore.getRootAsPartitionForceRestore(value);
                return Optional.of(new TierPartitionForceRestore(topicIdPartition, partitionForceRestore));
            }
            case PartitionUnfreezeLogStartOffset: {
                PartitionUnfreezeLogStartOffset unfreezeLogStartOffset = PartitionUnfreezeLogStartOffset.getRootAsPartitionUnfreezeLogStartOffset(value);
                return Optional.of(new TierPartitionUnfreezeLogStartOffset(topicIdPartition, unfreezeLogStartOffset));
            }
            case MetadataSnapshotUploadInitiate: {
                MetadataSnapshotUploadInitiate metadataSnapshotUploadInitiate = MetadataSnapshotUploadInitiate.getRootAsMetadataSnapshotUploadInitiate(value);
                return Optional.of(new TierMetadataSnapshotUploadInitiate(topicIdPartition, metadataSnapshotUploadInitiate));
            }
            case MetadataSnapshotUploadComplete: {
                MetadataSnapshotUploadComplete metadataSnapshotUploadComplete = MetadataSnapshotUploadComplete.getRootAsMetadataSnapshotUploadComplete(value);
                return Optional.of(new TierMetadataSnapshotUploadComplete(topicIdPartition, metadataSnapshotUploadComplete));
            }
            case PartitionUnfence: {
                PartitionUnfence partitionUnfence = PartitionUnfence.getRootAsPartitionUnfence(value);
                return Optional.of(new TierPartitionUnfence(topicIdPartition, partitionUnfence));
            }
        }
        log.debug("Unknown tier metadata type with ID {}. Ignoring record.", (Object)type);
        return Optional.empty();
    }

    public abstract TierRecordType type();

    public abstract TopicIdPartition topicIdPartition();

    public abstract ByteBuffer payloadBuffer();

    public abstract int tierEpoch();

    public abstract UUID messageId();

    public abstract OffsetAndEpoch stateOffsetAndEpoch();

    public long timestamp() {
        return this.timestamp;
    }

    public String messageIdAsBase64() {
        return Utils.uuidToBase64((UUID)this.messageId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTierMetadata that = (AbstractTierMetadata)o;
        return this.type().equals((Object)that.type()) && this.topicIdPartition().equals(that.topicIdPartition()) && this.payloadBuffer().equals(that.payloadBuffer());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.topicIdPartition(), this.payloadBuffer()});
    }
}

