/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.state;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.nio.file.Path;
import java.nio.file.Paths;

public enum StateFileType {
    FLUSHED(""),
    MUTABLE(".mutable"),
    TEMPORARY(".tmp"),
    ERROR(".error"),
    DISCARDED(".discarded"),
    RECOVER(".recover"),
    CLEANUP(".cleanup"),
    SNAPSHOT(".snapshot"),
    DOWNLOAD(".download"),
    MIGRATE(".migrate"),
    RECOVERY_UPLOAD(".recovery-upload");

    final String suffix;

    private StateFileType(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Path filePath(String basePath, Algorithm checksumAlgorithm) {
        return CheckedFileIO.validPath(checksumAlgorithm, Paths.get(basePath + this.suffix, new String[0]));
    }

    public static Path flushedFilePath(String basePath, Algorithm checksumAlgorithm) {
        return FLUSHED.filePath(basePath, checksumAlgorithm);
    }

    public static Path mutableFilePath(String basePath, Algorithm checksumAlgorithm) {
        return MUTABLE.filePath(basePath, checksumAlgorithm);
    }

    public static Path recoverPath(String basePath, Algorithm checksumAlgorithm) {
        return RECOVER.filePath(basePath, checksumAlgorithm);
    }

    public static Path discardedFilePath(String basePath, Algorithm checksumAlgorithm) {
        return DISCARDED.filePath(basePath, checksumAlgorithm);
    }

    public static Path tmpFilePath(String basePath, Algorithm checksumAlgorithm) {
        return TEMPORARY.filePath(basePath, checksumAlgorithm);
    }

    public static Path errorFilePath(String basePath, Algorithm checksumAlgorithm) {
        return ERROR.filePath(basePath, checksumAlgorithm);
    }

    public static Path cleanupPath(String basePath, Algorithm checksumAlgorithm) {
        return CLEANUP.filePath(basePath, checksumAlgorithm);
    }

    public static Path migrateFilePath(String basePath, Algorithm checksumAlgorithm) {
        return MIGRATE.filePath(basePath, checksumAlgorithm);
    }

    static Path snapshotFileName(String basePath, Algorithm checksumAlgorithm) {
        return SNAPSHOT.filePath(basePath, checksumAlgorithm);
    }

    public static Path downloadPath(String basePath, Algorithm checksumAlgorithm) {
        return DOWNLOAD.filePath(basePath, checksumAlgorithm);
    }

    public static Path recoveryUploadFilePath(String basePath, Algorithm checksumAlgorithm) {
        return RECOVERY_UPLOAD.filePath(basePath, checksumAlgorithm);
    }
}

