/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.CheckpointFileConfig;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.SnapshotFile;
import org.apache.kafka.storage.internals.log.VerificationStateEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedLogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MergedLogUtils.class);
    public static final String LOG_FILE_SUFFIX = ".log";
    public static final String INDEX_FILE_SUFFIX = ".index";
    public static final String TIME_INDEX_FILE_SUFFIX = ".timeindex";
    public static final String TXN_INDEX_FILE_SUFFIX = ".txnindex";
    public static final String SWAP_FILE_SUFFIX = ".swap";
    public static final String DELETE_DIR_SUFFIX = "-delete";
    public static final String FUTURE_DIR_SUFFIX = "-future";
    public static final String STRAY_DIR_SUFFIX = "-stray";
    public static final String TIER_STATE_SUFFIX = ".tierstate";
    public static final long UNKNOWN_OFFSET = -1L;

    public static void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, Time time, boolean reloadFromCleanShutdown, String logPrefix) throws IOException {
        ArrayList<Optional<Long>> offsetsToSnapshot = new ArrayList<Optional<Long>>();
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = segments.lastSegment().get().baseOffset();
            Optional<LogSegment> lowerSegmentOpt = segments.lowerSegment(lastSegmentBaseOffset);
            Optional<Long> nextLatestSegmentBaseOffset = lowerSegmentOpt.map(LogSegment::baseOffset);
            offsetsToSnapshot.add(nextLatestSegmentBaseOffset);
            offsetsToSnapshot.add(Optional.of(lastSegmentBaseOffset));
        }
        offsetsToSnapshot.add(Optional.of(lastOffset));
        LOG.info("{}Loading producer state till offset {}", (Object)logPrefix, (Object)lastOffset);
        if (!producerStateManager.latestSnapshotOffset().isPresent() && reloadFromCleanShutdown) {
            for (Optional optional : offsetsToSnapshot) {
                if (!optional.isPresent()) continue;
                producerStateManager.updateMapEndOffset((Long)optional.get());
                producerStateManager.takeSnapshot();
            }
        } else {
            LOG.info("{}Reloading from producer snapshot and rebuilding producer state from offset {}", (Object)logPrefix, (Object)lastOffset);
            boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
            long l = time.milliseconds();
            producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
            long segmentRecoveryStart = time.milliseconds();
            if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
                Optional<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
                for (LogSegment segment : segments.values(producerStateManager.mapEndOffset(), lastOffset)) {
                    FetchDataInfo fetchDataInfo;
                    long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager.mapEndOffset(), logStartOffset});
                    producerStateManager.updateMapEndOffset(startOffset);
                    if (offsetsToSnapshot.contains(Optional.of(segment.baseOffset()))) {
                        producerStateManager.takeSnapshot();
                    }
                    int maxPosition = segment.size();
                    if (segmentOfLastOffset.isPresent() && segmentOfLastOffset.get() == segment) {
                        FileRecords.LogOffsetPosition lop = segment.translateOffset(lastOffset);
                        int n = maxPosition = lop != null ? lop.position : segment.size();
                    }
                    if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition)) == null) continue;
                    MergedLogUtils.loadProducersFromRecords(producerStateManager, fetchDataInfo.records, segmentRecoveryStart);
                }
            }
            producerStateManager.updateMapEndOffset(lastOffset);
            producerStateManager.takeSnapshot();
            LOG.info("{}Producer state recovery took {}ms for snapshot load and {}ms for segment recovery from offset $lastOffset", new Object[]{logPrefix, segmentRecoveryStart - l, time.milliseconds() - segmentRecoveryStart});
        }
    }

    public static void deleteProducerSnapshots(Collection<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition, Optional<E2EChecksumStore> checksumStoreOpt) throws IOException {
        ArrayList snapshotsToDelete = new ArrayList();
        for (LogSegment segment : segments) {
            producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset()).ifPresent(snapshotsToDelete::add);
        }
        Runnable deleteProducerSnapshots = () -> MergedLogUtils.deleteProducerSnapshots(snapshotsToDelete, logDirFailureChannel, parentDir, topicPartition, checksumStoreOpt);
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-producer-snapshot", deleteProducerSnapshots, config.fileDeleteDelayMs);
        } else {
            deleteProducerSnapshots.run();
        }
    }

    private static void deleteProducerSnapshots(List<SnapshotFile> snapshotsToDelete, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition, Optional<E2EChecksumStore> checksumStoreOpt) {
        LocalLog.maybeHandleIOException(logDirFailureChannel, parentDir, () -> "Error while deleting producer state snapshots for " + String.valueOf(topicPartition) + " in dir " + parentDir, () -> {
            for (SnapshotFile snapshot : snapshotsToDelete) {
                snapshot.deleteIfExists(checksumStoreOpt);
            }
            return null;
        });
    }

    private static void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records, long currentTimeMs) {
        HashMap loadedProducers = new HashMap();
        ArrayList completedTxns = new ArrayList();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                Optional<CompletedTxn> maybeCompletedTxn = MergedLogUtils.updateProducers(producerStateManager, batch, loadedProducers, Optional.empty(), AppendOrigin.REPLICATION, currentTimeMs);
                maybeCompletedTxn.ifPresent(completedTxns::add);
            }
        });
        loadedProducers.values().forEach(producerStateManager::update);
        completedTxns.forEach(producerStateManager::completeTxn);
    }

    public static Optional<CompletedTxn> updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Long, ProducerAppendInfo> producers, Optional<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin, long currentTimeMs) {
        long producerId = batch.producerId();
        producers.putIfAbsent(producerId, producerStateManager.prepareUpdate(producerId, origin, currentTimeMs));
        ProducerAppendInfo appendInfo = producers.get(producerId);
        Optional<CompletedTxn> completedTxn = appendInfo.append(batch, firstOffsetMetadata);
        if (batch.isTransactional()) {
            boolean isV2NextTransactionStarted;
            VerificationStateEntry entry = producerStateManager.verificationStateEntry(producerId);
            boolean bl = isV2NextTransactionStarted = entry != null && entry.supportsEpochBump() && batch.isControlBatch() && batch.producerEpoch() == entry.epoch();
            if (!isV2NextTransactionStarted) {
                producerStateManager.clearVerificationStateEntry(producerId);
            }
        }
        return completedTxn;
    }

    public static String filenamePrefixFromOffset(long offset) {
        return LogFileUtils.filenamePrefixFromOffset(offset);
    }

    public static String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog.logDeleteDirName(topicPartition);
    }

    public static String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog.logFutureDirName(topicPartition);
    }

    public static String logStrayDirName(TopicPartition topicPartition) {
        return LocalLog.logStrayDirName(topicPartition);
    }

    public static String logDirName(TopicPartition topicPartition) {
        return LocalLog.logDirName(topicPartition);
    }

    public static File transactionIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.transactionIndexFile(dir, offset, suffix);
    }

    public static File tierStateFile(File dir, long offset, String suffix) {
        return new File(dir, MergedLogUtils.tierStateFileName(offset, suffix));
    }

    public static File tierStateFile(File dir, long offset) {
        return MergedLogUtils.tierStateFile(dir, offset, "");
    }

    public static String tierStateFileName(long offset, String suffix) {
        return LogFileUtils.filenamePrefixFromOffset(offset) + TIER_STATE_SUFFIX + suffix;
    }

    public static long offsetFromFile(File file) {
        return LogFileUtils.offsetFromFile(file);
    }

    public static long sizeInBytes(Collection<LogSegment> segments) {
        return LogSegments.sizeInBytes(segments);
    }

    public static TopicPartition parseTopicPartitionName(File dir) throws IOException {
        return LocalLog.parseTopicPartitionName(dir);
    }

    public static boolean isIndexFile(File file) {
        return LogFileUtils.isIndexFile(file);
    }

    public static boolean isLogFile(File file) {
        return LogFileUtils.isLogFile(file);
    }

    public static boolean isTierStateFile(File file) {
        Path path = file.toPath();
        Object expSuffix = TIER_STATE_SUFFIX;
        if (CheckedFileIO.isValidPath(Algorithm.ADLER, path)) {
            expSuffix = TIER_STATE_SUFFIX + Algorithm.ADLER.suffix;
        }
        return path.toString().endsWith((String)expSuffix);
    }

    public static <A> ConcurrentNavigableMap<Long, A> logSegments(ConcurrentNavigableMap<Long, A> segments, long from, long to) {
        ConcurrentNavigableMap view = Optional.ofNullable(segments.floorKey(from)).map(floor -> segments.subMap(floor, (Object)to)).orElseGet(() -> segments.headMap((Object)to));
        return view;
    }

    public static LeaderEpochFileCache createLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, CheckpointFileConfig checkpointFileConfig, Optional<LeaderEpochFileCache> currentCache, Scheduler scheduler) throws IOException {
        File leaderEpochFile = LeaderEpochCheckpointFile.newFile(dir);
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile, checkpointFileConfig, logDirFailureChannel);
        if (currentCache.isPresent()) {
            return currentCache.get().withCheckpoint(checkpointFile);
        }
        return new LeaderEpochFileCache(topicPartition, checkpointFile, scheduler);
    }

    public static List<LogSegment> replaceSegments(LogSegments existingSegments, List<LogSegment> newSegments, List<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) throws IOException {
        return LocalLog.replaceSegments(existingSegments, newSegments, oldSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, isRecoveredSwapFile);
    }

    public static void deleteSegmentFiles(List<LogSegment> segmentsToDelete, Boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) throws IOException {
        LocalLog.deleteSegmentFiles(segmentsToDelete, asyncDelete, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public static LocalLog.SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) throws IOException {
        return LocalLog.splitOverflowedSegment(segment, existingSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public static LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) throws IOException {
        return LocalLog.createNewCleanedSegment(dir, logConfig, baseOffset, false, ChecksumParams.EMPTY);
    }

    public static LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset, boolean tiered, ChecksumParams checksumParams) throws IOException {
        return LocalLog.createNewCleanedSegment(dir, logConfig, baseOffset, tiered, checksumParams);
    }
}

