/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetMapSupplier {
    private static final Logger log = LoggerFactory.getLogger(OffsetMapSupplier.class);
    private static final Duration MAX_WAIT = Duration.ofMillis(0L);
    private final OffsetMapFactory offsetMapFactory;
    private final GenericObjectPool<OffsetMap> offsetMapPool;

    public OffsetMapSupplier(int numMaps, int offsetMapMemory) {
        if (numMaps < 1) {
            throw new IllegalArgumentException("OffsetMapSupplier cannot initialize with max size less than 1. Value provided was " + numMaps);
        }
        if (offsetMapMemory < 1) {
            throw new IllegalArgumentException("OffsetMapSupplier cannot initialize with map memory less than 1. Value provided was " + offsetMapMemory);
        }
        GenericObjectPoolConfig offsetMapPoolConfig = new GenericObjectPoolConfig();
        offsetMapPoolConfig.setJmxEnabled(false);
        offsetMapPoolConfig.setMaxTotal(numMaps);
        offsetMapPoolConfig.setMaxWait(MAX_WAIT);
        this.offsetMapFactory = new OffsetMapFactory(offsetMapMemory);
        this.offsetMapPool = new GenericObjectPool((PooledObjectFactory)this.offsetMapFactory, offsetMapPoolConfig);
    }

    public synchronized OffsetMap getOffsetMap() throws Exception {
        OffsetMap offsetMap = (OffsetMap)this.offsetMapPool.borrowObject();
        while (offsetMap.memory() != this.offsetMapFactory.offsetMapMemory) {
            this.offsetMapPool.invalidateObject((Object)offsetMap);
            offsetMap = (OffsetMap)this.offsetMapPool.borrowObject();
        }
        return offsetMap;
    }

    public synchronized void reclaimOffsetMap(OffsetMap offsetMap) throws Exception {
        offsetMap.clear();
        if (this.offsetMapPool.listAllObjects().size() > this.offsetMapPool.getMaxTotal()) {
            this.offsetMapPool.invalidateObject((Object)offsetMap);
        } else {
            this.offsetMapPool.returnObject((Object)offsetMap);
        }
    }

    public synchronized void reconfigure(int newNumMaps, int newOffsetMapSize) {
        log.info("Reconfiguring OffsetMapSupplier with numMaps: {} and memory: {}", (Object)newNumMaps, (Object)newOffsetMapSize);
        if (newNumMaps < 1) {
            log.warn("OffsetMapSupplier cannot be configured with less than 1 map from new value of {}. Ignoring update for number of maps", (Object)newNumMaps);
        } else {
            this.offsetMapPool.setMaxTotal(newNumMaps);
        }
        if (newOffsetMapSize < 1) {
            log.warn("OffsetMapSupplier cannot be configured with a map size less than 1 from new value of {}. Ignoring update for map size", (Object)newOffsetMapSize);
        } else {
            this.offsetMapFactory.offsetMapMemory = newOffsetMapSize;
        }
    }

    protected int numActiveMaps() {
        return this.offsetMapPool.getNumActive();
    }

    protected int maxTotalMaps() {
        return this.offsetMapPool.getMaxTotal();
    }

    protected int offsetMapMemory() {
        return this.offsetMapFactory.offsetMapMemory;
    }

    public synchronized void close() {
        this.offsetMapPool.close();
    }

    private static class OffsetMapFactory
    extends BasePooledObjectFactory<OffsetMap> {
        int offsetMapMemory;

        public OffsetMapFactory(int offsetMapMemory) {
            this.offsetMapMemory = offsetMapMemory;
        }

        public OffsetMap create() throws NoSuchAlgorithmException {
            return new SkimpyOffsetMap(this.offsetMapMemory);
        }

        public PooledObject<OffsetMap> wrap(OffsetMap value) {
            return new DefaultPooledObject((Object)value);
        }
    }
}

