/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.assignor.ClusterMetadata;
import io.confluent.kafka.multitenant.assignor.RackMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kafka.assignor.TopicReplicaAssignor;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantPartitionAssignor
implements TopicReplicaAssignor {
    private static final Logger log = LoggerFactory.getLogger(TenantPartitionAssignor.class);
    private final String tenant;
    private final ClusterDescriber cluster;
    private final PartitionPlacementStrategy targetPlacementStrategy;
    private final boolean failUnsatisfiedPlacementConstraints;

    public TenantPartitionAssignor(ClusterDescriber cluster, String tenant, PartitionPlacementStrategy targetPlacementStrategy, boolean failUnsatisfiedPlacementConstraints) {
        this.tenant = tenant;
        this.cluster = cluster;
        this.targetPlacementStrategy = targetPlacementStrategy;
        this.failUnsatisfiedPlacementConstraints = failUnsatisfiedPlacementConstraints;
    }

    final ClusterDescriber cluster() {
        return this.cluster;
    }

    public Optional<List<List<Integer>>> computeAssignmentForNewTopic(TopicReplicaAssignor.NewPartitions partitions, Optional<TopicPlacement> topicPlacementOpt, Set<Integer> excludedBrokerIds) throws InvalidRequestException {
        if (topicPlacementOpt.isPresent()) {
            log.debug("The assignor does not support topic placement constraints. Returning an empty assignment");
            return Optional.empty();
        }
        String topic = partitions.topic();
        Map<String, TopicInfo> args = Collections.singletonMap(topic, new TopicInfo(partitions.totalPartitions(), partitions.replicationFactor(), partitions.firstNewPartition()));
        List<List<Integer>> assignment = this.assignPartitionsForNewTopics(this.tenant, args, excludedBrokerIds).get(topic);
        return assignment.isEmpty() ? Optional.empty() : Optional.of(assignment);
    }

    public Optional<List<List<Integer>>> computeAssignmentForExistingTopic(TopicReplicaAssignor.NewPartitions partitions, Optional<TopicPlacement> topicPlacementOpt, Set<Integer> excludedBrokerIds) throws InvalidRequestException {
        if (topicPlacementOpt.isPresent()) {
            log.debug("The assignor does not support topic placement constraints. Returning an empty assignment");
            return Optional.empty();
        }
        String topic = partitions.topic();
        Map<String, Integer> partitionCounts = Collections.singletonMap(topic, partitions.totalPartitions());
        List<List<Integer>> assignment = this.assignPartitionsForExistingTopics(this.tenant, partitionCounts, excludedBrokerIds).get(topic);
        return assignment.isEmpty() ? Optional.empty() : Optional.of(assignment);
    }

    Optional<String> reasonForSkippingTenantAwareAssignment(Set<Integer> excludedBrokerIds) {
        if (this.cluster == null) {
            return Optional.of("Cluster info not available");
        }
        Iterator iter = this.cluster.usableBrokers();
        while (iter.hasNext()) {
            UsableBroker broker = (UsableBroker)iter.next();
            if (broker.fenced() || excludedBrokerIds.contains(broker.id())) continue;
            return Optional.empty();
        }
        return Optional.of("No brokers available");
    }

    private Map<String, List<List<Integer>>> assignPartitionsForNewTopics(String tenant, Map<String, TopicInfo> newTopics, Set<Integer> excludedBrokerIds) {
        Optional<String> reason = this.reasonForSkippingTenantAwareAssignment(excludedBrokerIds);
        if (reason.isPresent()) {
            if (this.failUnsatisfiedPlacementConstraints) {
                log.error("{}. Partition assignment failed for {}.", (Object)reason.get(), (Object)String.join((CharSequence)", ", newTopics.keySet()));
                throw new InvalidReplicationFactorException(reason.get());
            }
            log.info("{}. Using default partition assignment for {}", (Object)reason.get(), (Object)String.join((CharSequence)", ", newTopics.keySet()));
            return this.emptyAssignment(newTopics.keySet());
        }
        return this.assignPartitions(this.cluster, tenant, newTopics, excludedBrokerIds);
    }

    private Map<String, List<List<Integer>>> assignPartitionsForExistingTopics(String tenant, Map<String, Integer> partitionCounts, Set<Integer> excludedBrokerIds) {
        Optional<String> reason = this.reasonForSkippingTenantAwareAssignment(excludedBrokerIds);
        if (reason.isPresent()) {
            if (this.failUnsatisfiedPlacementConstraints) {
                log.error("{}. Assignment failed for {}", (Object)reason.get(), (Object)String.join((CharSequence)", ", partitionCounts.keySet()));
                throw new InvalidReplicationFactorException(reason.get());
            }
            log.info("{}. Using default partition assignment for {}", (Object)reason.get(), (Object)String.join((CharSequence)", ", partitionCounts.keySet()));
            return this.emptyAssignment(partitionCounts.keySet());
        }
        HashMap<String, List<List<Integer>>> result = new HashMap<String, List<List<Integer>>>(partitionCounts.size());
        HashMap<String, TopicInfo> topicInfos = new HashMap<String, TopicInfo>();
        for (Map.Entry<String, Integer> entry : partitionCounts.entrySet()) {
            String topic = entry.getKey();
            int totalPartitions = entry.getValue();
            List partitionInfos = this.cluster.replicasForTopicName(topic);
            if (!partitionInfos.isEmpty()) {
                int startPartition = partitionInfos.size();
                short replication = (short)((List)partitionInfos.get(0)).size();
                if (startPartition < totalPartitions) {
                    topicInfos.put(topic, new TopicInfo(totalPartitions, replication, startPartition));
                    continue;
                }
                log.debug("Topic metadata out-of-date for {}, using default assignment,  startPartition is {} and requested totalPartitions is {}", new Object[]{topic, startPartition, totalPartitions});
                result.put(topic, Collections.emptyList());
                continue;
            }
            log.debug("Topic metadata not available for {}, using default assignment", (Object)topic);
            result.put(topic, Collections.emptyList());
        }
        if (!topicInfos.isEmpty()) {
            result.putAll(this.assignPartitions(this.cluster, tenant, topicInfos, excludedBrokerIds));
        }
        return result;
    }

    private Map<String, List<List<Integer>>> assignPartitions(ClusterDescriber cluster, String tenant, Map<String, TopicInfo> topics, Set<Integer> excludedBrokerIds) {
        HashMap<String, List<List<Integer>>> result = new HashMap<String, List<List<Integer>>>(topics.size());
        ClusterMetadata clusterMetadata = new ClusterMetadata(tenant, cluster, excludedBrokerIds, this.targetPlacementStrategy);
        for (Map.Entry<String, TopicInfo> entry : topics.entrySet()) {
            String topic = entry.getKey();
            TopicInfo topicInfo = entry.getValue();
            if (topicInfo.replicationFactor <= clusterMetadata.eligibleBrokers().size()) {
                List partitionInfos = topicInfo.isNewTopic() ? Collections.emptyList() : cluster.replicasForTopicName(topic);
                ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(partitionInfos);
                List<List<Integer>> partitionAssignment = clusterMetadata.partitionCellAware() ? this.assignReplicasToBrokersPartitionCellAware(clusterMetadata, topic, topicInfo, nodeReplicaCounter) : (clusterMetadata.tenantCellAware() ? this.assignReplicasToBrokersTenantCellAware(clusterMetadata, topicInfo, nodeReplicaCounter) : (clusterMetadata.rackAware() ? this.assignReplicasToBrokersRackAware(clusterMetadata, topicInfo, clusterMetadata.eligibleBrokers(), nodeReplicaCounter) : this.assignReplicasToBrokersRackUnaware(clusterMetadata, topicInfo, clusterMetadata.eligibleBrokers(), nodeReplicaCounter)));
                clusterMetadata.updateNodeMetadata(partitionAssignment);
                result.put(topic, partitionAssignment);
                continue;
            }
            Object insufficientNodesMsg = String.format("Insufficient nodes %d", clusterMetadata.eligibleBrokers().size());
            if (!clusterMetadata.excludedBrokerIds().isEmpty()) {
                insufficientNodesMsg = (String)insufficientNodesMsg + String.format(" (%d others excluded for replica placement)", clusterMetadata.excludedBrokerIds().size());
            }
            if (this.failUnsatisfiedPlacementConstraints) {
                log.error("{} for assignment of topic {}, with replication factor {}.", new Object[]{insufficientNodesMsg, topic, topicInfo.replicationFactor});
                throw new InvalidReplicationFactorException((String)insufficientNodesMsg);
            }
            log.info("{} for assignment of topic {}, with replication factor {}, using default assignment", new Object[]{insufficientNodesMsg, topic, topicInfo.replicationFactor});
            result.put(topic, Collections.emptyList());
        }
        return result;
    }

    private Map<String, List<List<Integer>>> emptyAssignment(Set<String> topics) {
        HashMap<String, List<List<Integer>>> results = new HashMap<String, List<List<Integer>>>();
        topics.forEach(topic -> results.put((String)topic, Collections.emptyList()));
        return results;
    }

    private List<List<Integer>> assignReplicasToBrokersPartitionCellAware(ClusterMetadata clusterMetadata, String topic, TopicInfo topicInfo, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter) {
        HashSet<Integer> eligibleNodes = new HashSet<Integer>(clusterMetadata.eligibleBrokers().size());
        for (Integer brokerId : clusterMetadata.eligibleBrokers()) {
            int cell = clusterMetadata.cellForBroker(brokerId);
            if (clusterMetadata.eligibleBrokersFromCell(cell).size() < topicInfo.replicationFactor) continue;
            eligibleNodes.add(brokerId);
        }
        if (eligibleNodes.isEmpty()) {
            Object insufficientNodesMsg = String.format("Insufficient nodes %d", clusterMetadata.eligibleBrokers().size());
            if (!clusterMetadata.excludedBrokerIds().isEmpty()) {
                insufficientNodesMsg = (String)insufficientNodesMsg + String.format(" (%d of which are excluded for replica placement)", clusterMetadata.excludedBrokerIds().size());
            }
            if (this.failUnsatisfiedPlacementConstraints) {
                log.error("{} for assignment of topic {}, with replication factor {}. Assignment failed.", new Object[]{insufficientNodesMsg, topic, topicInfo.replicationFactor});
                throw new InvalidReplicationFactorException((String)insufficientNodesMsg);
            }
            log.info("{} for assignment of topic {}, with replication factor {}, using default assignment", new Object[]{insufficientNodesMsg, topic, topicInfo.replicationFactor});
            return Collections.emptyList();
        }
        List<Integer> nodesOrderedByLeaders = nodeReplicaCounter.orderLeaderNodes(eligibleNodes);
        TreeMap<Integer, Integer> partitionsPerCell = new TreeMap<Integer, Integer>();
        int newPartitions = topicInfo.totalPartitions - topicInfo.firstNewPartition;
        int i = 0;
        for (int allocated = 0; allocated < newPartitions; ++allocated) {
            Integer broker = nodesOrderedByLeaders.get(i);
            int cell = clusterMetadata.cellForBroker(broker);
            Integer count = (Integer)partitionsPerCell.get(cell);
            if (count == null) {
                partitionsPerCell.put(cell, 1);
            } else {
                partitionsPerCell.put(cell, count + 1);
            }
            i = (i + 1) % nodesOrderedByLeaders.size();
        }
        ArrayList<List<Integer>> assignment = new ArrayList<List<Integer>>(newPartitions);
        int totalPartitions = topicInfo.firstNewPartition;
        int firstNewPartition = topicInfo.firstNewPartition;
        for (Map.Entry entry : partitionsPerCell.entrySet()) {
            Integer cell = (Integer)entry.getKey();
            Integer nbPartitions = (Integer)entry.getValue();
            TopicInfo cellTopicInfo = new TopicInfo(totalPartitions += nbPartitions.intValue(), topicInfo.replicationFactor, firstNewPartition);
            Set<Integer> eligibleBrokersFromCell = clusterMetadata.eligibleBrokersFromCell(cell);
            if (clusterMetadata.rackAware()) {
                assignment.addAll(this.assignReplicasToBrokersRackAware(clusterMetadata, cellTopicInfo, eligibleBrokersFromCell, nodeReplicaCounter));
            } else {
                assignment.addAll(this.assignReplicasToBrokersRackUnaware(clusterMetadata, cellTopicInfo, eligibleBrokersFromCell, nodeReplicaCounter));
            }
            firstNewPartition += nbPartitions.intValue();
        }
        return assignment;
    }

    private List<List<Integer>> assignReplicasToBrokersTenantCellAware(ClusterMetadata clusterMetadata, TopicInfo topicInfo, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter) {
        if (clusterMetadata.rackAware()) {
            return this.assignReplicasToBrokersRackAware(clusterMetadata, topicInfo, clusterMetadata.eligibleBrokers(), nodeReplicaCounter);
        }
        return this.assignReplicasToBrokersRackUnaware(clusterMetadata, topicInfo, clusterMetadata.eligibleBrokers(), nodeReplicaCounter);
    }

    private List<List<Integer>> assignReplicasToBrokersRackUnaware(ClusterMetadata clusterMetadata, TopicInfo topicInfo, Set<Integer> eligibleBrokers, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter) {
        List<Integer> nodesOrderedByLeaders = nodeReplicaCounter.orderLeaderNodes(eligibleBrokers);
        List<Integer> nodesOrderedByFollowers = nodeReplicaCounter.orderFollowerNodes(eligibleBrokers);
        return this.assignReplicasToBrokers(clusterMetadata, topicInfo, nodeReplicaCounter, 1, nodesOrderedByLeaders, nodesOrderedByFollowers);
    }

    private List<List<Integer>> assignReplicasToBrokersRackAware(ClusterMetadata clusterMetadata, TopicInfo topicInfo, Set<Integer> eligibleBrokers, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter) {
        List<Integer> nodesOrderedByLeaders = nodeReplicaCounter.orderLeaderNodes(eligibleBrokers);
        nodesOrderedByLeaders = TenantPartitionAssignor.rackAlternatedBrokerList(nodesOrderedByLeaders, clusterMetadata, Collections.emptyList());
        List<String> leaderRackOrder = nodesOrderedByLeaders.stream().map(clusterMetadata::rackForBroker).collect(Collectors.toList());
        List<Integer> nodesOrderedByFollowers = nodeReplicaCounter.orderFollowerNodes(eligibleBrokers);
        nodesOrderedByFollowers = TenantPartitionAssignor.rackAlternatedBrokerList(nodesOrderedByFollowers, clusterMetadata, leaderRackOrder);
        int numRacks = eligibleBrokers.stream().map(clusterMetadata::rackForBroker).collect(Collectors.toSet()).size();
        return this.assignReplicasToBrokers(clusterMetadata, topicInfo, nodeReplicaCounter, numRacks, nodesOrderedByLeaders, nodesOrderedByFollowers);
    }

    static List<Integer> rackAlternatedBrokerList(List<Integer> orderedEligibleBrokers, RackMetadata rackMetadata, List<String> disallowedOrder) {
        ArrayList<String> rackList = new ArrayList<String>();
        HashMap<String, List<Integer>> brokersByRack = new HashMap<String, List<Integer>>();
        for (Integer brokerId : orderedEligibleBrokers) {
            String rack = rackMetadata.rackForBroker(brokerId);
            if (!rackList.contains(rack)) {
                rackList.add(rack);
                brokersByRack.put(rack, new ArrayList());
            }
            ((List)brokersByRack.get(rack)).add(brokerId);
        }
        int numRacks = rackList.size();
        if (numRacks <= 1) {
            return orderedEligibleBrokers;
        }
        return TenantPartitionAssignor.rackAlternatedBrokerList(brokersByRack, rackList, disallowedOrder);
    }

    private static List<Integer> rackAlternatedBrokerList(Map<String, List<Integer>> brokersByRack, List<String> rackList, List<String> disallowedOrder) {
        List<String> rackOrder;
        int numRacks = rackList.size();
        long numBrokers = brokersByRack.values().stream().mapToLong(Collection::size).sum();
        if (disallowedOrder.isEmpty()) {
            rackOrder = rackList;
        } else {
            rackOrder = new ArrayList<String>(numRacks);
            block0: for (int i = 0; i < numRacks; ++i) {
                Iterator<String> it = rackList.iterator();
                while (it.hasNext()) {
                    String nextRack = it.next();
                    if (disallowedOrder.get(i).equals(nextRack)) continue;
                    rackOrder.add(nextRack);
                    it.remove();
                    continue block0;
                }
            }
            if (!rackList.isEmpty()) {
                rackOrder.add(rackOrder.size() - 1, rackList.get(0));
            }
        }
        Map<String, Iterator> brokersIteratorByRack = brokersByRack.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).iterator()));
        ArrayList<Integer> result = new ArrayList<Integer>();
        int rackIndex = 0;
        while ((long)result.size() < numBrokers) {
            Iterator rackIterator = brokersIteratorByRack.get(rackOrder.get(rackIndex));
            if (rackIterator.hasNext()) {
                result.add((Integer)rackIterator.next());
            }
            rackIndex = (rackIndex + 1) % numRacks;
        }
        return result;
    }

    private List<List<Integer>> assignReplicasToBrokers(ClusterMetadata clusterMetadata, TopicInfo topicInfo, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter, int numRacks, List<Integer> nodesOrderedByLeaders, List<Integer> nodesOrderedByFollowers) {
        short replicationFactor = topicInfo.replicationFactor;
        int startPartitionId = topicInfo.firstNewPartition;
        int numNewPartitions = topicInfo.totalPartitions - startPartitionId;
        List<List<Integer>> assignment = this.allocateLeaders(numNewPartitions, replicationFactor, nodeReplicaCounter, nodesOrderedByLeaders);
        if (replicationFactor <= 1) {
            return assignment;
        }
        int numBrokers = nodesOrderedByLeaders.size();
        int remainder = numNewPartitions % numBrokers;
        int batch = 0;
        int p = 0;
        while (p < numNewPartitions) {
            int batchSize = batch == 0 && remainder != 0 ? remainder : numBrokers;
            this.allocateFollowers(clusterMetadata, p, batchSize, replicationFactor, numRacks, batch, nodeReplicaCounter, assignment, nodesOrderedByFollowers);
            p += batchSize;
            ++batch;
        }
        return assignment;
    }

    private List<List<Integer>> allocateLeaders(int numNewPartitions, short replicationFactor, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter, List<Integer> orderedBrokerList) {
        ArrayList<List<Integer>> assignment = new ArrayList<List<Integer>>(numNewPartitions);
        int numBrokers = orderedBrokerList.size();
        for (int p = 0; p < numNewPartitions; ++p) {
            int leaderId = orderedBrokerList.get(p % numBrokers);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicationFactor);
            replicas.add(leaderId);
            assignment.add(replicas);
            nodeReplicaCounter.incrementLeader(leaderId);
        }
        return assignment;
    }

    private void allocateFollowers(ClusterMetadata clusterMetadata, int firstPartitionIndex, int numPartitions, int replicationFactor, int numRacks, int batchIndex, ClusterMetadata.NodeReplicaCounter nodeReplicaCounter, List<List<Integer>> assignment, List<Integer> orderedBrokerList) {
        int replicaShift;
        List<Integer> brokerList;
        int numBrokers = orderedBrokerList.size();
        if (numPartitions < numBrokers) {
            brokerList = orderedBrokerList;
            replicaShift = 0;
        } else {
            brokerList = assignment.subList(firstPartitionIndex, firstPartitionIndex + numPartitions).stream().map(l -> (Integer)l.get(0)).collect(Collectors.toList());
            replicaShift = batchIndex * numRacks % (numBrokers - 1) + 1;
        }
        List<Object> prevUnassignedBrokers = Collections.emptyList();
        for (int r = 0; r < replicationFactor - 1; ++r) {
            List<Integer> unassignedBrokers = TenantPartitionAssignor.rotateList(brokerList, replicaShift);
            unassignedBrokers.removeAll(prevUnassignedBrokers);
            unassignedBrokers.addAll(0, prevUnassignedBrokers);
            for (int p = 0; p < numPartitions; ++p) {
                List<Integer> assignedReplicas = assignment.get(p + firstPartitionIndex);
                Integer broker = this.maybeAssign(clusterMetadata, numRacks, unassignedBrokers, assignedReplicas);
                if (broker != null) {
                    unassignedBrokers.remove(broker);
                } else {
                    List<Integer> orderedList = nodeReplicaCounter.orderFollowerNodes();
                    broker = this.maybeAssign(clusterMetadata, numRacks, orderedList, assignedReplicas);
                    if (broker == null) {
                        for (int brokerId : orderedList) {
                            this.logInvalidReplicaAssignment(clusterMetadata, numRacks, brokerId, assignedReplicas);
                        }
                        throw new InvalidReplicaAssignmentException(String.format("Failed to assign follower replicas for partition %d to reach replication factor %d", p + firstPartitionIndex, replicationFactor));
                    }
                }
                nodeReplicaCounter.incrementFollower(broker);
            }
            replicaShift = numPartitions == brokerList.size() ? replicaShift + 1 : numPartitions;
            replicaShift = replicaShift % numBrokers == 0 ? 1 : replicaShift % numBrokers;
            prevUnassignedBrokers = unassignedBrokers;
        }
    }

    private Integer maybeAssign(ClusterMetadata clusterMetadata, int numRacks, List<Integer> brokerList, List<Integer> assignedReplicas) {
        for (int k = 0; k < brokerList.size(); ++k) {
            int broker = brokerList.get(k);
            if (!this.validReplicaAssignment(clusterMetadata, numRacks, broker, assignedReplicas)) continue;
            assignedReplicas.add(broker);
            return broker;
        }
        return null;
    }

    private boolean validReplicaAssignment(ClusterMetadata clusterMetadata, int numRacks, int broker, List<Integer> assignedReplicas) {
        if (!clusterMetadata.isBrokerEligibleForReplicaPlacement(broker)) {
            return false;
        }
        if (assignedReplicas.contains(broker)) {
            return false;
        }
        if (!clusterMetadata.brokersInSameCell(assignedReplicas.get(0), broker)) {
            return false;
        }
        if (numRacks <= 1) {
            return true;
        }
        String rack = clusterMetadata.rackForBroker(broker);
        Set assignedRacks = assignedReplicas.stream().map(clusterMetadata::rackForBroker).collect(Collectors.toSet());
        return !assignedRacks.contains(rack) || assignedRacks.size() == numRacks;
    }

    private void logInvalidReplicaAssignment(ClusterMetadata clusterMetadata, int numRacks, int broker, List<Integer> assignedReplicas) {
        if (!clusterMetadata.isBrokerEligibleForReplicaPlacement(broker)) {
            log.error("Broker {} is not eligible for replica placement", (Object)broker);
        } else if (assignedReplicas.contains(broker)) {
            log.error("Broker {} has already been assigned as a replica for this partition", (Object)broker);
        } else if (!clusterMetadata.brokersInSameCell(assignedReplicas.get(0), broker)) {
            log.error("Broker {} does not reside in the same cell as this partition's assigned replicas", (Object)broker);
        } else {
            String rack = clusterMetadata.rackForBroker(broker);
            Set assignedRacks = assignedReplicas.stream().map(clusterMetadata::rackForBroker).collect(Collectors.toSet());
            if (assignedRacks.contains(rack) && assignedRacks.size() < numRacks) {
                log.error("A broker on the same rack as broker {} has already been assigned, and there are other racks without a replica", (Object)broker);
            }
        }
    }

    private static List<Integer> rotateList(List<Integer> list, int shift) {
        int count = list.size();
        ArrayList<Integer> result = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            result.add(list.get((i + shift) % count));
        }
        return result;
    }

    public static class TopicInfo {
        final int totalPartitions;
        final short replicationFactor;
        final int firstNewPartition;

        public TopicInfo(int totalPartitions, short replicationFactor, int firstNewPartition) {
            this.totalPartitions = totalPartitions;
            this.replicationFactor = replicationFactor;
            this.firstNewPartition = firstNewPartition;
        }

        public int totalPartitions() {
            return this.totalPartitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public boolean isNewTopic() {
            return this.firstNewPartition == 0;
        }
    }
}

