/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.kafka.server.plugins.auth.oauth.KafkaVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.Constraint;
import io.confluent.security.authentication.oauthbearer.JwtIssuer;
import io.confluent.security.util.SecurityContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Configurable;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

@JsonDeserialize(builder=Builder.class)
public final class JwtIssuerAuthCache
extends JwtIssuer
implements Configurable {
    private final String name;
    private final Set<String> audience;
    private String sessionUuid;

    private JwtIssuerAuthCache(String name, Set<String> audience, String sessionUuid) {
        this.name = name;
        this.audience = Collections.unmodifiableSet(audience);
        this.sessionUuid = sessionUuid;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonProperty(value="audience")
    public Set<String> audience() {
        return this.audience;
    }

    @JsonProperty(value="sessionUuid")
    public String sessionUuid() {
        return this.sessionUuid;
    }

    public ConstrainedVerificationKeyResolver keyResolver(Collection<Constraint> constraints, SecurityContext context) {
        return new ConstrainedVerificationKeyResolver((VerificationKeyResolver)new KafkaVerificationKeyResolver(this.name, this.sessionUuid, context), constraints);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void configure(Map<String, ?> configs) {
        this.sessionUuid = AuthUtils.getBrokerSessionUuid(configs);
    }

    public static class Builder {
        private String name;
        private Set<String> audience;
        private String sessionUuid;

        private Builder() {
        }

        @JsonSetter(value="name")
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonSetter(value="audience", nulls=Nulls.AS_EMPTY)
        public Builder audience(Set<String> audience) {
            this.audience = audience;
            return this;
        }

        @JsonSetter(value="sessionUuid", nulls=Nulls.AS_EMPTY)
        public Builder sessionUuid(String sessionUuid) {
            this.sessionUuid = sessionUuid;
            return this;
        }

        public JwtIssuerAuthCache build() {
            return new JwtIssuerAuthCache(this.name, this.audience == null ? Collections.emptySet() : this.audience, this.sessionUuid);
        }
    }
}

