/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Error message")
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorMessage {
    private int errorCode;
    private String message;

    public ErrorMessage(@JsonProperty(value="error_code") int errorCode, @JsonProperty(value="message") String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    @Schema(description="Error code")
    @JsonProperty(value="error_code")
    public int getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="error_code")
    public void setErrorCode(int error_code) {
        this.errorCode = error_code;
    }

    @Schema(description="Detailed error message")
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorMessage that = (ErrorMessage)o;
        return this.errorCode == that.errorCode && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.message);
    }
}

