/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.Rule;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleMode;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.rules.RulePhase;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RuleSet {
    private final List<Rule> migrationRules;
    private final List<Rule> domainRules;
    private final List<Rule> encodingRules;

    @JsonCreator
    public RuleSet(@JsonProperty(value="migrationRules") List<Rule> migrationRules, @JsonProperty(value="domainRules") List<Rule> domainRules, @JsonProperty(value="encodingRules") List<Rule> encodingRules) {
        this.migrationRules = migrationRules != null ? Collections.unmodifiableList(migrationRules) : Collections.emptyList();
        this.domainRules = domainRules != null ? Collections.unmodifiableList(domainRules) : Collections.emptyList();
        this.encodingRules = encodingRules != null ? Collections.unmodifiableList(encodingRules) : Collections.emptyList();
    }

    public RuleSet(@JsonProperty(value="migrationRules") List<Rule> migrationRules, @JsonProperty(value="domainRules") List<Rule> domainRules) {
        this(migrationRules, domainRules, null);
    }

    public List<Rule> getMigrationRules() {
        return this.migrationRules;
    }

    public List<Rule> getDomainRules() {
        return this.domainRules;
    }

    public List<Rule> getEncodingRules() {
        return this.encodingRules;
    }

    public boolean isEmpty() {
        return !(this.migrationRules != null && !this.migrationRules.isEmpty() || this.domainRules != null && !this.domainRules.isEmpty() || this.encodingRules != null && !this.encodingRules.isEmpty());
    }

    public List<Rule> getRules(RulePhase phase) {
        switch (phase) {
            case MIGRATION: {
                return this.getMigrationRules();
            }
            case DOMAIN: {
                return this.getDomainRules();
            }
            case ENCODING: {
                return this.getEncodingRules();
            }
        }
        throw new IllegalArgumentException("Unsupported rule phase " + String.valueOf((Object)phase));
    }

    public boolean hasRules(RulePhase phase, RuleMode mode) {
        switch (mode) {
            case UPGRADE: 
            case DOWNGRADE: {
                return this.getRules(phase).stream().anyMatch(r -> r.getMode() == mode || r.getMode() == RuleMode.UPDOWN);
            }
            case UPDOWN: {
                return this.getRules(phase).stream().anyMatch(r -> r.getMode() == mode);
            }
            case WRITE: 
            case READ: {
                return this.getRules(phase).stream().anyMatch(r -> r.getMode() == mode || r.getMode() == RuleMode.WRITEREAD);
            }
            case WRITEREAD: {
                return this.getRules(phase).stream().anyMatch(r -> r.getMode() == mode);
            }
        }
        return false;
    }

    public boolean hasRulesWithType(String type) {
        return this.getDomainRules().stream().anyMatch(r -> type.equals(r.getType())) || this.getMigrationRules().stream().anyMatch(r -> type.equals(r.getType())) || this.getEncodingRules().stream().anyMatch(r -> type.equals(r.getType()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSet ruleSet = (RuleSet)o;
        return Objects.equals(this.migrationRules, ruleSet.migrationRules) && Objects.equals(this.domainRules, ruleSet.domainRules) && Objects.equals(this.encodingRules, ruleSet.encodingRules);
    }

    public int hashCode() {
        return Objects.hash(this.migrationRules, this.domainRules, this.encodingRules);
    }

    public String toString() {
        return "Rules{migrationRules=" + String.valueOf(this.migrationRules) + ", domainRules=" + String.valueOf(this.domainRules) + ", encodingRules=" + String.valueOf(this.encodingRules) + "}";
    }

    public void updateHash(MessageDigest md) {
        if (this.migrationRules != null) {
            this.migrationRules.forEach(r -> r.updateHash(md));
        }
        if (this.domainRules != null) {
            this.domainRules.forEach(r -> r.updateHash(md));
        }
        if (this.encodingRules != null) {
            this.encodingRules.forEach(r -> r.updateHash(md));
        }
    }

    public void validate() throws RuleException {
        String name;
        HashSet<String> names = new HashSet<String>();
        if (this.migrationRules != null) {
            for (Rule rule : this.migrationRules) {
                name = rule.getName();
                if (names.contains(name)) {
                    throw new RuleException("Found rule with duplicate name '" + name + "'");
                }
                names.add(name);
                rule.validate();
                if (rule.getMode().isMigrationRule()) continue;
                throw new RuleException("Migration rules can only be UPGRADE, DOWNGRADE, UPDOWN");
            }
        }
        if (this.domainRules != null) {
            for (Rule rule : this.domainRules) {
                name = rule.getName();
                if (names.contains(name)) {
                    throw new RuleException("Found rule with duplicate name '" + name + "'");
                }
                names.add(name);
                rule.validate();
                if (rule.getMode().isDomainOrEncodingRule()) continue;
                throw new RuleException("Domain rules can only be WRITE, READ, WRITEREAD");
            }
        }
        if (this.encodingRules != null) {
            for (Rule rule : this.encodingRules) {
                name = rule.getName();
                if (names.contains(name)) {
                    throw new RuleException("Found rule with duplicate name '" + name + "'");
                }
                names.add(name);
                rule.validate();
                if (rule.getMode().isDomainOrEncodingRule()) continue;
                throw new RuleException("Encoding rules can only be WRITE, READ, WRITEREAD");
            }
        }
    }

    public static RuleSet mergeRuleSets(RuleSet oldRuleSet, RuleSet newRuleSet) {
        if (oldRuleSet == null) {
            return newRuleSet;
        }
        if (newRuleSet == null) {
            return oldRuleSet;
        }
        return new RuleSet(RuleSet.merge(oldRuleSet.migrationRules, newRuleSet.migrationRules), RuleSet.merge(oldRuleSet.domainRules, newRuleSet.domainRules), RuleSet.merge(oldRuleSet.encodingRules, newRuleSet.encodingRules));
    }

    private static List<Rule> merge(List<Rule> oldRules, List<Rule> newRules) {
        if (oldRules == null || oldRules.isEmpty()) {
            return newRules;
        }
        if (newRules == null || newRules.isEmpty()) {
            return oldRules;
        }
        Set newRuleNames = newRules.stream().map(Rule::getName).collect(Collectors.toSet());
        List filteredOldRules = oldRules.stream().filter(r -> !newRuleNames.contains(r.getName())).collect(Collectors.toCollection(ArrayList::new));
        filteredOldRules.addAll(newRules);
        return filteredOldRules;
    }
}

