/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.operationgroupdefinitions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.confluent.security.operationgroupdefinitions.InvalidOperationGroupDefinitionException;
import io.confluent.security.operationgroupdefinitions.OperationGroupDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class IpfOperationGroupDefinitions {
    private static final ObjectMapper YAML_OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String KAFKA_DATA_FILE = "KafkaData.yaml";
    private static final String KAFKA_MANAGEMENT_FILE = "KafkaManagement.yaml";
    public static final String OPG_DEFINITIONS_FOLDER = "operation-group-definitions/";
    private final Map<String, OperationGroupDefinition> opgDefMapping = new HashMap<String, OperationGroupDefinition>();
    public static final String YAML_FILE_SUFFIX = ".yaml";

    public static ObjectMapper yamlObjectMapper() {
        return YAML_OBJECT_MAPPER;
    }

    public IpfOperationGroupDefinitions(List<OperationGroupDefinition> operationGroupDefinitions) {
        operationGroupDefinitions.forEach(ogm -> this.opgDefMapping.put(ogm.name(), (OperationGroupDefinition)ogm));
    }

    public static IpfOperationGroupDefinitions loadDefaultPolicy() {
        return IpfOperationGroupDefinitions.loadKafkaPolicy();
    }

    public static IpfOperationGroupDefinitions loadKafkaPolicy() {
        return IpfOperationGroupDefinitions.load(IpfOperationGroupDefinitions.class.getClassLoader(), Arrays.asList(KAFKA_DATA_FILE, KAFKA_MANAGEMENT_FILE));
    }

    public static IpfOperationGroupDefinitions loadAllPolicies() {
        try {
            ClassLoader classLoader = IpfOperationGroupDefinitions.class.getClassLoader();
            ArrayList<String> fileNames = new ArrayList<String>();
            URL directoryUrl = classLoader.getResource(OPG_DEFINITIONS_FOLDER);
            if (directoryUrl != null) {
                File directory = new File(directoryUrl.toURI());
                if (directory.exists() && directory.isDirectory()) {
                    File[] files = directory.listFiles((dir, name) -> name.endsWith(YAML_FILE_SUFFIX));
                    if (files != null) {
                        for (File file : files) {
                            fileNames.add(file.getName());
                        }
                    }
                } else {
                    try (InputStream in = classLoader.getResourceAsStream(OPG_DEFINITIONS_FOLDER);
                         BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                        String resource;
                        while ((resource = br.readLine()) != null) {
                            if (!resource.endsWith(YAML_FILE_SUFFIX)) continue;
                            fileNames.add(resource);
                        }
                    }
                }
            }
            if (fileNames.isEmpty()) {
                return IpfOperationGroupDefinitions.loadKafkaPolicy();
            }
            return IpfOperationGroupDefinitions.load(classLoader, fileNames);
        }
        catch (Exception e) {
            throw new InvalidOperationGroupDefinitionException("Failed to load operation group definitions", e);
        }
    }

    public OperationGroupDefinition operationGroupDefinition(String name) {
        return this.opgDefMapping.get(name);
    }

    public Collection<OperationGroupDefinition> operationGroupDefinitions() {
        return new ArrayList<OperationGroupDefinition>(this.opgDefMapping.values());
    }

    public Map<String, OperationGroupDefinition> operationGroupDefinitionsMap() {
        return this.opgDefMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IpfOperationGroupDefinitions)) {
            return false;
        }
        IpfOperationGroupDefinitions that = (IpfOperationGroupDefinitions)o;
        return Objects.equals(this.opgDefMapping, that.opgDefMapping);
    }

    public int hashCode() {
        return Objects.hash(this.opgDefMapping);
    }

    public static IpfOperationGroupDefinitions load(ClassLoader classLoader, String policyResourceName) {
        return IpfOperationGroupDefinitions.load(classLoader, Collections.singletonList(policyResourceName));
    }

    public static IpfOperationGroupDefinitions load(ClassLoader classLoader, List<String> policyResourceNames) {
        if (policyResourceNames.isEmpty()) {
            throw new InvalidOperationGroupDefinitionException("Need at least one Operation Group Definition file");
        }
        if (policyResourceNames.size() == 1) {
            return IpfOperationGroupDefinitions.parseIpfOpgDefs(classLoader, policyResourceNames.get(0));
        }
        return IpfOperationGroupDefinitions.mergedIpfOpgDefs(classLoader, policyResourceNames);
    }

    public static IpfOperationGroupDefinitions mergedIpfOpgDefs(ClassLoader classLoader, List<String> policyResourceNames) {
        List ipfOpgDefsList = policyResourceNames.stream().map(policy -> IpfOperationGroupDefinitions.parseIpfOpgDefs(classLoader, policy)).collect(Collectors.toList());
        IpfOperationGroupDefinitions merged = (IpfOperationGroupDefinitions)ipfOpgDefsList.remove(0);
        for (IpfOperationGroupDefinitions ipfOpgDefs : ipfOpgDefsList) {
            merged = IpfOperationGroupDefinitions.merge(merged, ipfOpgDefs);
        }
        return merged;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IpfOperationGroupDefinitions parseIpfOpgDefs(ClassLoader classLoader, String policyResourceName) {
        if (!policyResourceName.endsWith(YAML_FILE_SUFFIX)) {
            throw new InvalidOperationGroupDefinitionException("Operation Group Definition must be defined as a YAML file.");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(classLoader.getResourceAsStream(OPG_DEFINITIONS_FOLDER + policyResourceName)), StandardCharsets.UTF_8));){
            OperationGroupDefinition opgDef = (OperationGroupDefinition)IpfOperationGroupDefinitions.yamlObjectMapper().readValue((Reader)reader, OperationGroupDefinition.class);
            IpfOperationGroupDefinitions ipfOperationGroupDefinitions = new IpfOperationGroupDefinitions(new ArrayList<OperationGroupDefinition>(Collections.singletonList(opgDef)));
            return ipfOperationGroupDefinitions;
        }
        catch (IOException e) {
            throw new InvalidOperationGroupDefinitionException("Operation Group Definition could not be loaded from " + policyResourceName, e);
        }
        catch (NullPointerException e) {
            throw new InvalidOperationGroupDefinitionException("No Operation Group Definition file named " + policyResourceName, e);
        }
    }

    public static IpfOperationGroupDefinitions merge(IpfOperationGroupDefinitions ipfOpgDefs1, IpfOperationGroupDefinitions ipfOpgDefs2) {
        HashMap<String, OperationGroupDefinition> mergedOpgDefsMap = new HashMap<String, OperationGroupDefinition>(ipfOpgDefs1.opgDefMapping);
        ipfOpgDefs2.opgDefMapping.forEach((key, value) -> mergedOpgDefsMap.merge((String)key, (OperationGroupDefinition)value, OperationGroupDefinition::merge));
        return new IpfOperationGroupDefinitions(new ArrayList<OperationGroupDefinition>(mergedOpgDefsMap.values()));
    }
}

