/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.mtls;

import io.confluent.security.auth.mtls.CertIdentityPool;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public enum CertIdentityPoolExternalIdentifier {
    CN(0, "CN", "First instance of Common Name"),
    DN(1, "DN", "Entire subject Distinguished Name"),
    SNID(2, "SNID", "Serial Number"),
    CN_SNID(3, "CN+SNID", "{CN string}, {Serial Number}"),
    SAN(4, "SAN", "Entire Subject Alternative Name"),
    SAN_SNID(5, "SAN+SNID", "{SAN string}, {Serial Number}"),
    SHA1(6, "SHA1", "SHA-1 Fingerprint");

    private static final Map<String, CertIdentityPoolExternalIdentifier> LOOKUP;
    private static final CertIdentityPoolExternalIdentifier HIGHEST_PRIORITY;
    private static final CertIdentityPoolExternalIdentifier LOWEST_PRIORITY;
    private final int priority;
    private final String value;
    private final String description;

    private CertIdentityPoolExternalIdentifier(int priority, String value, String description) {
        this.value = value;
        this.priority = priority;
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getDescription() {
        return this.description;
    }

    static CertIdentityPoolExternalIdentifier fromValue(String value) {
        CertIdentityPoolExternalIdentifier result = LOOKUP.get(value);
        if (result == null) {
            throw new IllegalArgumentException("Invalid value: " + value);
        }
        return result;
    }

    public static CertIdentityPoolExternalIdentifier findExternalIdentifierFromIdentityPools(Collection<CertIdentityPool> pools) {
        if (pools == null || pools.isEmpty()) {
            return HIGHEST_PRIORITY;
        }
        CertIdentityPoolExternalIdentifier ret = LOWEST_PRIORITY;
        boolean hasValidExternalId = false;
        for (CertIdentityPool identityPool : pools) {
            try {
                CertIdentityPoolExternalIdentifier externalId = CertIdentityPoolExternalIdentifier.fromValue(identityPool.externalIdentifier());
                hasValidExternalId = true;
                if (externalId == HIGHEST_PRIORITY) {
                    return HIGHEST_PRIORITY;
                }
                if (externalId.getPriority() >= ret.getPriority()) continue;
                ret = externalId;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return hasValidExternalId ? ret : HIGHEST_PRIORITY;
    }

    static {
        LOOKUP = new HashMap<String, CertIdentityPoolExternalIdentifier>();
        HIGHEST_PRIORITY = CN;
        LOWEST_PRIORITY = SHA1;
        for (CertIdentityPoolExternalIdentifier item : CertIdentityPoolExternalIdentifier.values()) {
            LOOKUP.put(item.getValue(), item);
        }
    }
}

