/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.authorizer.acl.AclRule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AclBindingValue
extends AuthValue {
    private final Set<AclRule> aclRules;

    @JsonCreator
    public AclBindingValue(@JsonProperty(value="aclRules") Collection<AclRule> aclRules) {
        this.aclRules = aclRules == null ? Collections.emptySet() : new HashSet<AclRule>(aclRules);
    }

    @JsonProperty
    public Collection<AclRule> aclRules() {
        return this.aclRules;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.ACL_BINDING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AclBindingValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AclBindingValue that = (AclBindingValue)o;
        return Objects.equals(this.aclRules, that.aclRules);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.aclRules);
    }

    public String toString() {
        return "AclBindingValue{accessRules=" + String.valueOf(this.aclRules) + "}";
    }
}

