/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import java.util.Objects;

public class CertIdentityPoolValue
extends AuthValue {
    private final String poolId;
    private final String providerId;
    private final String organizationId;
    private final String externalId;
    private final String filter;

    @JsonCreator
    public CertIdentityPoolValue(@JsonProperty(value="poolId") String poolId, @JsonProperty(value="providerId") String providerId, @JsonProperty(value="organizationId") String organizationId, @JsonProperty(value="externalId") String externalId, @JsonProperty(value="filter") String filter) {
        this.poolId = poolId;
        this.providerId = providerId;
        this.organizationId = organizationId;
        this.externalId = externalId;
        this.filter = filter;
    }

    @JsonProperty(value="poolId")
    public String poolId() {
        return this.poolId;
    }

    @JsonProperty(value="providerId")
    public String providerId() {
        return this.providerId;
    }

    @JsonProperty(value="organizationId")
    public String organizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="externalId")
    public String externalId() {
        return this.externalId;
    }

    @JsonProperty(value="filter")
    public String filter() {
        return this.filter;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.CERT_IDENTITY_POOL;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.poolId, this.providerId, this.organizationId, this.externalId, this.filter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertIdentityPoolValue)) {
            return false;
        }
        CertIdentityPoolValue that = (CertIdentityPoolValue)o;
        return Objects.equals(this.poolId, that.poolId) && Objects.equals(this.providerId, that.providerId) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.externalId, that.externalId) && Objects.equals(this.filter, that.filter);
    }

    public String toString() {
        return String.format("CertIdentityPoolValue{\n\tpoolId=%s\n\tproviderId=%s\n\torganizationId=%s\n\texternalId=%s\n\tfilter=%s\n}", this.poolId, this.providerId, this.organizationId, this.externalId, this.filter);
    }
}

