/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthKey;
import java.util.Objects;

public final class IdentityPoolKey
extends AuthKey {
    private final String poolId;

    public IdentityPoolKey(@JsonProperty(value="poolId") String poolId) {
        this.poolId = Objects.requireNonNull(poolId, "Argument `poolId` must not be null");
    }

    @JsonProperty
    public String poolId() {
        return this.poolId;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IDENTITY_POOL;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IdentityPoolKey) {
            IdentityPoolKey that = (IdentityPoolKey)o;
            return Objects.equals(this.poolId, that.poolId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.poolId);
    }

    public String toString() {
        return String.format("IdentityPoolKey{\n\tpoolId=%s\n}", this.poolId);
    }
}

