/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLSocketFactory
extends SSLSocketFactory {
    protected final ContextData contextData;

    ProvSSLSocketFactory(ContextData contextData) {
        this.contextData = contextData;
    }

    @Override
    public Socket createSocket() throws IOException {
        return SSLSocketUtil.create(this.contextData);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return SSLSocketUtil.create(this.contextData, host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return SSLSocketUtil.create(this.contextData, address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return SSLSocketUtil.create(this.contextData, host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return SSLSocketUtil.create(this.contextData, host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
        return SSLSocketUtil.create(this.contextData, s, consumed, autoClose);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return SSLSocketUtil.create(this.contextData, s, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.contextData.getContext().getDefaultCipherSuites(true);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }
}

