/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.crypto;

import com.google.common.io.BaseEncoding;
import io.confluent.kafka.secretregistry.crypto.Encrypted;
import io.confluent.kafka.secretregistry.crypto.Hkdf;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cryptor {
    private static final Logger logger = LoggerFactory.getLogger(Cryptor.class);
    private static final String ENCRYPTION_ALGORITHM = "AES/GCM/NoPadding";
    private static final String KEY_ALGORITHM = "AES";
    private static final int TAG_BITS = 128;
    private static final int NONCE_BYTES = 12;
    private final SecretKey key;
    private final Provider provider;
    private final SecureRandom random;

    public Cryptor(SecretKey key, Provider provider, SecureRandom random) {
        this.key = key;
        this.provider = provider;
        this.random = random;
    }

    public Encrypter encryptionKeyDerivedFrom(String secretName) {
        return new Encrypter(secretName);
    }

    public byte[] decrypt(Encrypted encrypted) {
        return this.gcm(Mode.DECRYPT, encrypted.derivationInfo(), encrypted.ivBytes(), encrypted.contentBytes());
    }

    public String computeHmac(byte[] data) {
        SecretKey hmacKey = this.deriveKey(32, "hmackey");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(hmacKey);
            return BaseEncoding.base16().encode(mac.doFinal(data));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            logger.warn("Error computing HMAC: ", (Throwable)e);
            return null;
        }
    }

    private SecretKey deriveKey(int blockSize, String info) {
        Hkdf hkdf = Hkdf.usingProvider(this.provider);
        byte[] infoBytes = info.getBytes(StandardCharsets.UTF_8);
        byte[] derivedKeyBytes = hkdf.expand(this.key, infoBytes, blockSize);
        return new SecretKeySpec(derivedKeyBytes, KEY_ALGORITHM);
    }

    private byte[] gcm(Mode mode, String info, byte[] nonce, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM, this.provider);
            SecretKey derivedKey = this.deriveKey(cipher.getBlockSize(), info);
            GCMParameterSpec gcmParameters = new GCMParameterSpec(128, nonce);
            cipher.init(mode.cipherMode, (Key)derivedKey, gcmParameters);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public class Encrypter {
        private final String derivationInfo;

        private Encrypter(String derivationInfo) {
            this.derivationInfo = derivationInfo;
        }

        public Encrypted encrypt(byte[] plaintext) {
            byte[] nonce = new byte[12];
            Cryptor.this.random.nextBytes(nonce);
            byte[] ciphertext = Cryptor.this.gcm(Mode.ENCRYPT, this.derivationInfo, nonce, plaintext);
            return Encrypted.of(this.derivationInfo, ciphertext, nonce);
        }
    }

    private static enum Mode {
        ENCRYPT(1),
        DECRYPT(2);

        final int cipherMode;

        private Mode(int cipherMode) {
            this.cipherMode = cipherMode;
        }
    }
}

