/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Hkdf {
    private static final Hash DEFAULT_HASH = Hash.SHA256;
    private final Hash hash;
    private final Provider provider;

    private Hkdf(Hash hash, Provider provider) {
        this.hash = hash;
        this.provider = provider;
    }

    public static Hkdf usingDefaults() {
        return new Hkdf(DEFAULT_HASH, null);
    }

    public static Hkdf usingHash(Hash hash) {
        return new Hkdf(Objects.requireNonNull(hash), null);
    }

    public static Hkdf usingProvider(Provider provider) {
        return new Hkdf(DEFAULT_HASH, Objects.requireNonNull(provider));
    }

    public SecretKey extract(SecretKey salt, byte[] ikm) {
        Objects.requireNonNull(ikm, "ikm must not be null");
        if (salt == null) {
            salt = new SecretKeySpec(new byte[this.hash.byteLength], this.hash.algorithm);
        }
        Mac mac = this.initMac(salt);
        byte[] keyBytes = mac.doFinal(ikm);
        return new SecretKeySpec(keyBytes, this.hash.algorithm);
    }

    public byte[] expand(SecretKey key, byte[] info, int outputLength) {
        Objects.requireNonNull(key, "key must not be null");
        if (outputLength < 1) {
            throw new IllegalArgumentException("outputLength must be positive");
        }
        int hashLen = this.hash.byteLength;
        if (outputLength > 255 * hashLen) {
            throw new IllegalArgumentException("outputLength must be less than or equal to 255*HashLen");
        }
        if (info == null) {
            info = new byte[]{};
        }
        int n = outputLength % hashLen == 0 ? outputLength / hashLen : outputLength / hashLen + 1;
        byte[] hashRound = new byte[]{};
        ByteBuffer generatedBytes = ByteBuffer.allocate(Math.multiplyExact(n, hashLen));
        Mac mac = this.initMac(key);
        for (int roundNum = 1; roundNum <= n; ++roundNum) {
            mac.reset();
            ByteBuffer t = ByteBuffer.allocate(hashRound.length + info.length + 1);
            t.put(hashRound);
            t.put(info);
            t.put((byte)roundNum);
            hashRound = mac.doFinal(t.array());
            generatedBytes.put(hashRound);
        }
        byte[] result = new byte[outputLength];
        generatedBytes.rewind();
        generatedBytes.get(result, 0, outputLength);
        return result;
    }

    public SecretKey randomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] randBytes = new byte[this.hash.byteLength];
        random.nextBytes(randBytes);
        return new SecretKeySpec(randBytes, this.hash.algorithm);
    }

    private Mac initMac(SecretKey key) {
        try {
            Mac mac = this.provider != null ? Mac.getInstance(this.hash.algorithm, this.provider) : Mac.getInstance(this.hash.algorithm);
            mac.init(key);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static enum Hash {
        SHA256("HmacSHA256", 32),
        SHA1("HmacSHA1", 20);

        final String algorithm;
        final int byteLength;

        private Hash(String algorithm, int byteLength) {
            if (byteLength <= 0) {
                throw new IllegalArgumentException("byteLength must be positive");
            }
            this.algorithm = algorithm;
            this.byteLength = byteLength;
        }
    }
}

