/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.masterelector.kafka;

import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryInitializationException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryStoreException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryTimeoutException;
import io.confluent.kafka.secretregistry.masterelector.kafka.ClientConfig;
import io.confluent.kafka.secretregistry.masterelector.kafka.SecretRegistryCoordinator;
import io.confluent.kafka.secretregistry.masterelector.kafka.SecretRegistryProtocol;
import io.confluent.kafka.secretregistry.masterelector.kafka.SecretRegistryRebalanceListener;
import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.kafka.secretregistry.storage.MasterElector;
import io.confluent.kafka.secretregistry.storage.SecretRegistryIdentity;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaGroupMasterElector
implements MasterElector,
SecretRegistryRebalanceListener {
    private static final Logger log = LoggerFactory.getLogger(KafkaGroupMasterElector.class);
    private static final AtomicInteger SR_CLIENT_ID_SEQUENCE = new AtomicInteger(1);
    private static final String JMX_PREFIX = "kafka.secret.registry";
    private final int initTimeout;
    private final String clientId;
    private final ConsumerNetworkClient client;
    private final Metrics metrics;
    private final Metadata metadata;
    private final long retryBackoffMs;
    private final long retryBackoffMaxMs;
    private final SecretRegistryCoordinator coordinator;
    private final KafkaSecretRegistry secretRegistry;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private ExecutorService executor;
    private CountDownLatch joinedLatch = new CountDownLatch(1);

    public KafkaGroupMasterElector(SecretRegistryConfig config, SecretRegistryIdentity myIdentity, KafkaSecretRegistry secretRegistry) throws SecretRegistryInitializationException {
        try {
            this.secretRegistry = secretRegistry;
            this.clientId = "sr-" + SR_CLIENT_ID_SEQUENCE.getAndIncrement();
            LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>();
            metricsTags.put("client-id", this.clientId);
            long sampleWindowMs = config.getLong("metrics.sample.window.ms");
            MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).timeWindow(sampleWindowMs, TimeUnit.MILLISECONDS).tags(metricsTags);
            List reporters = config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            JmxReporter reporter = new JmxReporter();
            KafkaMetricsContext context = new KafkaMetricsContext(JMX_PREFIX);
            reporter.contextChange((MetricsContext)context);
            reporters.add(reporter);
            Time time = Time.SYSTEM;
            ClientConfig clientConfig = new ClientConfig(config.originalsWithPrefix("kafkastore."), false);
            this.metrics = new Metrics(metricConfig, reporters, time);
            this.retryBackoffMs = clientConfig.getLong("retry.backoff.ms");
            this.retryBackoffMaxMs = clientConfig.getLong("retry.backoff.max.ms");
            String groupId = config.getString("secret.registry.group.id");
            LogContext logContext = new LogContext("[Secret registry clientId=" + this.clientId + ", groupId=" + groupId + "] ");
            this.metadata = new Metadata(this.retryBackoffMs, this.retryBackoffMaxMs, clientConfig.getLong("metadata.max.age.ms").longValue(), logContext, new ClusterResourceListeners());
            List bootstrapServers = config.getList("kafkastore.bootstrap.servers");
            List addresses = ClientUtils.parseAndValidateAddresses((List)bootstrapServers, (String)ClientDnsLookup.USE_ALL_DNS_IPS.name());
            this.metadata.bootstrap(addresses);
            String metricGrpPrefix = JMX_PREFIX;
            ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder((AbstractConfig)clientConfig, (Time)time, (LogContext)logContext);
            long maxIdleMs = clientConfig.getLong("connections.max.idle.ms");
            NetworkClient netClient = new NetworkClient((Selectable)new Selector(maxIdleMs, this.metrics, time, metricGrpPrefix, channelBuilder, logContext), this.metadata, this.clientId, 100, clientConfig.getLong("reconnect.backoff.ms").longValue(), clientConfig.getLong("reconnect.backoff.max.ms").longValue(), clientConfig.getInt("send.buffer.bytes").intValue(), clientConfig.getInt("receive.buffer.bytes").intValue(), clientConfig.getInt("request.timeout.ms").intValue(), CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS.longValue(), CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS.longValue(), time, true, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
            this.client = new ConsumerNetworkClient(logContext, (KafkaClient)netClient, this.metadata, time, this.retryBackoffMs, clientConfig.getInt("request.timeout.ms").intValue(), Integer.MAX_VALUE);
            this.coordinator = new SecretRegistryCoordinator(logContext, this.client, groupId, 300000, 10000, 3000, this.metrics, metricGrpPrefix, time, this.retryBackoffMs, this.retryBackoffMaxMs, myIdentity, this);
            AppInfoParser.registerAppInfo((String)JMX_PREFIX, (String)this.clientId, (Metrics)this.metrics, (long)time.milliseconds());
            this.initTimeout = config.getInt("kafkastore.init.timeout.ms");
            log.debug("Secret registry group member created");
        }
        catch (Throwable t) {
            this.stop(true);
            throw new SecretRegistryInitializationException("Failed to construct kafka consumer", t);
        }
    }

    @Override
    public void init() throws SecretRegistryTimeoutException, SecretRegistryStoreException {
        log.debug("Initializing secret registry group member");
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!KafkaGroupMasterElector.this.stopped.get()) {
                        KafkaGroupMasterElector.this.coordinator.poll(Integer.MAX_VALUE);
                    }
                }
                catch (Throwable t) {
                    log.error("Unexpected exception in secret registry group processing thread", t);
                }
            }
        });
        try {
            if (!this.joinedLatch.await(this.initTimeout, TimeUnit.MILLISECONDS)) {
                throw new SecretRegistryTimeoutException("Timed out waiting for join group to complete");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SecretRegistryStoreException("Interrupted while waiting for join group to complete", e);
        }
        log.debug("Secret registry group member initialized and joined group");
    }

    @Override
    public void close() {
        if (this.stopped.get()) {
            return;
        }
        this.stop(false);
    }

    @Override
    public void onAssigned(SecretRegistryProtocol.Assignment assignment, int generation) {
        log.info("Finished rebalance with master election result: {}", (Object)assignment);
        try {
            switch (assignment.error()) {
                case 0: {
                    if (assignment.masterIdentity() == null) {
                        log.error("No master eligible secret registry instances joined the secret registry group. Rebalancing was successful and this instance can serve reads, but no writes can be processed.");
                    }
                    this.secretRegistry.setMaster(assignment.masterIdentity());
                    this.joinedLatch.countDown();
                    break;
                }
                case 1: {
                    throw new IllegalStateException("The secret registry group contained multiple members advertising the same URL. Verify that each instance has a unique, routable listener by setting the 'listeners' configuration. This error may happen if executing in containers where the default hostname is 'localhost'.");
                }
                default: {
                    throw new IllegalStateException("Unknown error returned from secret registry coordination protocol");
                }
            }
        }
        catch (SecretRegistryException e) {
            log.error("Error when updating master, we will not be able to forward requests to the master", (Throwable)e);
        }
    }

    @Override
    public void onRevoked() {
        log.info("Rebalance started");
        try {
            this.secretRegistry.setMaster(null);
        }
        catch (SecretRegistryException e) {
            log.error("Error when updating master, we will not be able to forward requests to the master", (Throwable)e);
        }
    }

    private void stop(boolean swallowException) {
        log.trace("Stopping the secret registry group member.");
        if (this.client != null) {
            this.client.wakeup();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted waiting for secret registry group processing thread to exit", e);
            }
        }
        AtomicReference firstException = new AtomicReference();
        this.stopped.set(true);
        Utils.closeQuietly((AutoCloseable)this.coordinator, (String)"coordinator", firstException);
        Utils.closeQuietly((AutoCloseable)this.metrics, (String)"consumer metrics", firstException);
        Utils.closeQuietly((AutoCloseable)this.client, (String)"consumer network client", firstException);
        AppInfoParser.unregisterAppInfo((String)JMX_PREFIX, (String)this.clientId, (Metrics)this.metrics);
        if (firstException.get() != null && !swallowException) {
            throw new KafkaException("Failed to stop the secret registry group member", (Throwable)firstException.get());
        }
        log.debug("The secret registry group member has stopped.");
    }
}

