/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.masterelector.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.secretregistry.storage.SecretRegistryIdentity;
import java.io.IOException;
import java.nio.ByteBuffer;

class SecretRegistryProtocol {
    public static final short SR_PROTOCOL_V0 = 0;

    SecretRegistryProtocol() {
    }

    public static ByteBuffer serializeMetadata(SecretRegistryIdentity identity) {
        return identity.toJsonBytes();
    }

    public static SecretRegistryIdentity deserializeMetadata(ByteBuffer buffer) {
        return SecretRegistryIdentity.fromJson(buffer);
    }

    public static ByteBuffer serializeAssignment(Assignment assignment) {
        return assignment.toJsonBytes();
    }

    public static Assignment deserializeAssignment(ByteBuffer buffer) {
        return Assignment.fromJson(buffer);
    }

    public static class Assignment {
        public static final int CURRENT_VERSION = 1;
        public static final short NO_ERROR = 0;
        public static final short DUPLICATE_URLS = 1;
        private final int version;
        private final short error;
        private final String master;
        private final SecretRegistryIdentity masterIdentity;

        public Assignment(@JsonProperty(value="error") short error, @JsonProperty(value="master") String master, @JsonProperty(value="master_identity") SecretRegistryIdentity masterIdentity) {
            this.version = 1;
            this.error = error;
            this.master = master;
            this.masterIdentity = masterIdentity;
        }

        public static Assignment fromJson(ByteBuffer json) {
            try {
                byte[] jsonBytes = new byte[json.remaining()];
                json.get(jsonBytes);
                return (Assignment)new ObjectMapper().readValue(jsonBytes, Assignment.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error deserializing identity information", e);
            }
        }

        @JsonProperty(value="version")
        public int version() {
            return this.version;
        }

        @JsonProperty(value="error")
        public short error() {
            return this.error;
        }

        @JsonProperty(value="master")
        public String master() {
            return this.master;
        }

        @JsonProperty(value="master_identity")
        public SecretRegistryIdentity masterIdentity() {
            return this.masterIdentity;
        }

        public boolean failed() {
            return this.error != 0;
        }

        public ByteBuffer toJsonBytes() {
            try {
                return ByteBuffer.wrap(new ObjectMapper().writeValueAsBytes((Object)this));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error serializing identity information", e);
            }
        }

        public String toString() {
            return "Assignment{version=" + this.version + ", error=" + this.error + ", master='" + this.master + "', masterIdentity=" + String.valueOf(this.masterIdentity) + "}";
        }
    }
}

