/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest;

import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.util.StringUtil;

public class SslFactory {
    private String protocol;
    private String provider;
    private String kmfAlgorithm;
    private String tmfAlgorithm;
    private SecurityStore keystore = null;
    private String keyPassword;
    private SecurityStore truststore;
    private SSLContext sslContext;

    public SslFactory(Map<String, String> configs) throws SecretRegistryException {
        this.protocol = configs.getOrDefault("ssl.protocol", "TLS");
        this.provider = configs.getOrDefault("ssl.provider", "");
        this.kmfAlgorithm = configs.getOrDefault("ssl.keymanager.algorithm", "");
        this.tmfAlgorithm = configs.getOrDefault("ssl.trustmanager.algorithm", "");
        this.createKeystore(configs.getOrDefault("ssl.keystore.type", "JKS"), configs.getOrDefault("ssl.keystore.location", ""), configs.getOrDefault("ssl.keystore.password", ""), configs.getOrDefault("ssl.key.password", ""));
        this.createTruststore(configs.getOrDefault("ssl.truststore.type", "JKS"), configs.getOrDefault("ssl.truststore.location", ""), configs.getOrDefault("ssl.truststore.password", ""));
        try {
            this.sslContext = this.createSslContext();
        }
        catch (Exception e) {
            throw new SecretRegistryException("Error initializing the ssl context for RestService", e);
        }
    }

    public SslFactory(SecretRegistryConfig configs) throws SecretRegistryException {
        this.protocol = configs.getString("ssl.protocol");
        this.provider = configs.getString("ssl.provider");
        this.kmfAlgorithm = configs.getString("ssl.keymanager.algorithm");
        this.tmfAlgorithm = configs.getString("ssl.trustmanager.algorithm");
        this.createKeystore(configs.getString("ssl.keystore.type"), configs.getString("ssl.keystore.location"), configs.getPassword("ssl.keystore.password").value(), configs.getPassword("ssl.key.password").value());
        this.createTruststore(configs.getString("ssl.truststore.type"), configs.getString("ssl.truststore.location"), configs.getPassword("ssl.truststore.password").value());
        try {
            this.sslContext = this.createSslContext();
        }
        catch (Exception e) {
            throw new SecretRegistryException("Error initializing the ssl context for RestService", e);
        }
    }

    private SSLContext createSslContext() throws GeneralSecurityException, IOException {
        SSLContext sslContext = StringUtil.isNotBlank((String)this.provider) ? SSLContext.getInstance(this.protocol, this.provider) : SSLContext.getInstance(this.protocol);
        KeyManager[] keyManagers = null;
        if (this.keystore != null) {
            String kmfAlgorithm = StringUtil.isNotBlank((String)this.kmfAlgorithm) ? this.kmfAlgorithm : KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmfAlgorithm);
            KeyStore ks = this.keystore.load();
            String keyPassword = this.keyPassword != null ? this.keyPassword : this.keystore.password;
            kmf.init(ks, keyPassword.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        String tmfAlgorithm = StringUtil.isNotBlank((String)this.tmfAlgorithm) ? this.tmfAlgorithm : TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        KeyStore ts = this.truststore == null ? null : this.truststore.load();
        tmf.init(ts);
        sslContext.init(keyManagers, tmf.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    private void createKeystore(String type, String path, String password, String keyPassword) throws SecretRegistryException {
        if (path == null && password != null) {
            throw new SecretRegistryException("SSL key store is not specified, but key store password is specified.");
        }
        if (path != null && password == null) {
            throw new SecretRegistryException("SSL key store is specified, but key store password is not specified.");
        }
        if (StringUtil.isNotBlank((String)path) && StringUtil.isNotBlank((String)password)) {
            this.keystore = new SecurityStore(type, path, password);
            this.keyPassword = keyPassword;
        }
    }

    private void createTruststore(String type, String path, String password) throws SecretRegistryException {
        if (path == null && password != null) {
            throw new SecretRegistryException("SSL trust store is not specified, but trust store password is specified.");
        }
        if (StringUtil.isNotBlank((String)path)) {
            this.truststore = new SecurityStore(type, path, password);
        }
    }

    private static class SecurityStore {
        private final String type;
        private final String path;
        private final String password;

        private SecurityStore(String type, String path, String password) {
            this.type = type == null ? KeyStore.getDefaultType() : type;
            this.path = path;
            this.password = password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyStore load() throws GeneralSecurityException, IOException {
            try (FileInputStream in = null;){
                KeyStore ks = KeyStore.getInstance(this.type);
                in = new FileInputStream(this.path);
                char[] passwordChars = this.password != null ? this.password.toCharArray() : null;
                ks.load(in, passwordChars);
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
    }
}

