/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest.resources;

import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryRequestForwardingException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryStoreException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryTimeoutException;
import io.confluent.kafka.secretregistry.exceptions.UnknownMasterException;
import io.confluent.kafka.secretregistry.rest.exceptions.Errors;
import io.confluent.kafka.secretregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/secret/paths/{path}/keys")
@Produces(value={"application/vnd.secretregistry.v1+json", "application/vnd.secretregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.secretregistry.v1+json", "application/vnd.secretregistry+json", "application/json", "application/octet-stream"})
public class PathKeyResource {
    private static final Logger log = LoggerFactory.getLogger(PathKeyResource.class);
    private final KafkaSecretRegistry secretRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public PathKeyResource(KafkaSecretRegistry registry) {
        this.secretRegistry = registry;
    }

    @GET
    @Path(value="/{key}")
    @PerformanceMetric(value="paths.keys.get-key")
    public List<Secret> getAllVersions(@Context SecurityContext securityContext, @PathParam(value="path") String path, @PathParam(value="key") String key) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' getting versions for '{}:{}'", new Object[]{name, path, key});
        } else {
            log.info("Unknown user getting versions for '{}:{}'", (Object)path, (Object)key);
        }
        try {
            if (!this.secretRegistry.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            if (!this.secretRegistry.listKeys(path).contains(key)) {
                throw Errors.keyNotFoundException();
            }
            return this.secretRegistry.getAllVersions(path, key);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Error while listing versions", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while listing versions", e);
        }
    }

    @GET
    @PerformanceMetric(value="paths.keys.list")
    public Set<String> list(@Context SecurityContext securityContext, @PathParam(value="path") String path) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' listing keys for '{}'", (Object)name, (Object)path);
        } else {
            log.info("Unknown user listing keys for '{}'", (Object)path);
        }
        try {
            if (!this.secretRegistry.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            return this.secretRegistry.listKeys(path);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Error while listing paths", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while listing paths", e);
        }
    }

    @DELETE
    @Path(value="/{key}")
    @PerformanceMetric(value="paths.keys.delete-key")
    public void deleteKey(@Suspended AsyncResponse asyncResponse, @Context SecurityContext securityContext, @Context HttpHeaders headers, @PathParam(value="path") String path, @PathParam(value="key") String key) {
        List<Integer> deletedVersions;
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' deleting key '{}:{}'", new Object[]{name, path, key});
        } else {
            log.info("Unknown user deleting key '{}:{}'", (Object)path, (Object)key);
        }
        String errorMessage = "Error while validating that path " + path + " and key " + key + " exist in the registry";
        try {
            if (!this.secretRegistry.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            if (!this.secretRegistry.listKeys(path).contains(key)) {
                throw Errors.keyNotFoundException();
            }
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException(errorMessage, e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException(errorMessage, e);
        }
        try {
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.secretRegistry.config().whitelistHeaders());
            deletedVersions = this.secretRegistry.deleteKeyOrForward(headerProperties, path, key);
        }
        catch (SecretRegistryTimeoutException e) {
            throw Errors.operationTimeoutException("Delete Secret Version operation timed out", e);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Delete Secret Version operation failed while writing to the Kafka store", e);
        }
        catch (SecretRegistryRequestForwardingException e) {
            throw Errors.requestForwardingFailedException("Error while forwarding delete secret version request to the master", e);
        }
        catch (UnknownMasterException e) {
            throw Errors.unknownMasterException("Master not known.", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while deleting Secret Version", e);
        }
        asyncResponse.resume(deletedVersions);
    }
}

