/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest.resources;

import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryStoreException;
import io.confluent.kafka.secretregistry.rest.exceptions.Errors;
import io.confluent.kafka.secretregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/secret/paths")
@Produces(value={"application/vnd.secretregistry.v1+json", "application/vnd.secretregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.secretregistry.v1+json", "application/vnd.secretregistry+json", "application/json", "application/octet-stream"})
public class PathResource {
    private static final Logger log = LoggerFactory.getLogger(PathResource.class);
    private final KafkaSecretRegistry secretRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    public PathResource(KafkaSecretRegistry secretRegistry) {
        this.secretRegistry = secretRegistry;
    }

    @GET
    @Valid
    @PerformanceMetric(value="paths.list")
    public Set<String> list(@Context SecurityContext securityContext) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' listing all paths", (Object)name);
        } else {
            log.info("Unknown user listing all paths");
        }
        try {
            return this.secretRegistry.listPaths();
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Error while listing paths", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while listing paths", e);
        }
    }

    @GET
    @Path(value="/{path}")
    @PerformanceMetric(value="paths.get-latest")
    public List<Secret> allLatest(@Context SecurityContext securityContext, @PathParam(value="path") String path) {
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' getting latest for '{}'", (Object)name, (Object)path);
        } else {
            log.info("Unknown user getting latest for '{}'", (Object)path);
        }
        try {
            if (!this.secretRegistry.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            return this.secretRegistry.getAllLatest(path);
        }
        catch (SecretRegistryStoreException e) {
            throw Errors.storeException("Error while listing paths", e);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while listing paths", e);
        }
    }

    @DELETE
    @Path(value="/{path}")
    @PerformanceMetric(value="paths.delete-path")
    public void deletePath(@Suspended AsyncResponse asyncResponse, @Context SecurityContext securityContext, @Context HttpHeaders headers, @PathParam(value="path") String path) {
        Set<String> deletedKeys;
        if (securityContext.getUserPrincipal() != null) {
            String name = securityContext.getUserPrincipal().getName();
            log.info("User '{}' deleting path '{}'", (Object)name, (Object)path);
        } else {
            log.info("Unknown user deleting path '{}'", (Object)path);
        }
        try {
            if (!this.secretRegistry.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            Map<String, String> headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.secretRegistry.config().whitelistHeaders());
            deletedKeys = this.secretRegistry.deletePathOrForward(headerProperties, path);
        }
        catch (SecretRegistryException e) {
            throw Errors.secretRegistryException("Error while deleting the path " + path, e);
        }
        asyncResponse.resume(deletedKeys);
    }
}

