/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.secretregistry.storage.SecretRegistryKey;
import io.confluent.kafka.secretregistry.storage.SecretRegistryKeyType;
import jakarta.validation.constraints.Min;
import java.util.Objects;
import org.hibernate.validator.constraints.NotEmpty;

@JsonPropertyOrder(value={"keytype", "path", "version", "magic"})
public class SecretKey
extends SecretRegistryKey {
    public static final String MAX_KEY = "{";
    public static final String MIN_KEY = "@";
    private static final int MAGIC_BYTE = 1;
    @NotEmpty
    private String path;
    @NotEmpty
    private String key;
    @Min(value=1L)
    @NotEmpty
    private @Min(value=1L) @NotEmpty Integer version;

    public SecretKey(@JsonProperty(value="path") String path, @JsonProperty(value="key") String key, @JsonProperty(value="version") int version) {
        super(SecretRegistryKeyType.SECRET);
        this.magicByte = 1;
        this.path = path;
        this.key = key;
        this.version = version;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)o;
        return Objects.equals(this.path, secretKey.path) && Objects.equals(this.key, secretKey.key) && Objects.equals(this.version, secretKey.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.key, this.version);
    }

    public String toString() {
        return "SecretKey{path='" + this.path + "', key='" + this.key + "', version=" + this.version + "}";
    }

    @Override
    public int compareTo(SecretRegistryKey o) {
        int compare = super.compareTo(o);
        if (compare == 0) {
            return this.compareTo((SecretKey)o);
        }
        return compare;
    }

    @Override
    public int compareTo(SecretKey that) {
        if (this.path.compareTo(that.path) < 0) {
            return -1;
        }
        if (this.path.compareTo(that.path) > 0) {
            return 1;
        }
        if (SecretKey.compareKeys(this.key, that.key) < 0) {
            return -1;
        }
        if (SecretKey.compareKeys(this.key, that.key) > 0) {
            return 1;
        }
        if (this.version.compareTo(that.version) < 0) {
            return -1;
        }
        if (this.version.compareTo(that.version) > 0) {
            return 1;
        }
        return 0;
    }

    public static int compareKeys(String key1, String key2) {
        if (key1.equals(MIN_KEY)) {
            if (key2.equals(MIN_KEY)) {
                return 0;
            }
            return -1;
        }
        if (key2.equals(MAX_KEY)) {
            if (key1.equals(MAX_KEY)) {
                return 0;
            }
            return -1;
        }
        return key1.compareTo(key2);
    }
}

