/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.secretregistry.storage.SecretRegistryKeyType;
import jakarta.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public abstract class SecretRegistryKey
implements Comparable<SecretRegistryKey> {
    @Min(value=0L)
    protected @Min(value=0L) int magicByte;
    @NotEmpty
    protected SecretRegistryKeyType keyType;

    public SecretRegistryKey(@JsonProperty(value="keytype") SecretRegistryKeyType keyType) {
        this.keyType = keyType;
    }

    @JsonProperty(value="magic")
    public int getMagicByte() {
        return this.magicByte;
    }

    @JsonProperty(value="magic")
    public void setMagicByte(int magicByte) {
        this.magicByte = magicByte;
    }

    @JsonProperty(value="keytype")
    public SecretRegistryKeyType getKeyType() {
        return this.keyType;
    }

    @JsonProperty(value="keytype")
    public void setKeyType(SecretRegistryKeyType keyType) {
        this.keyType = keyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretRegistryKey that = (SecretRegistryKey)o;
        if (this.magicByte != that.magicByte) {
            return false;
        }
        return this.keyType.equals((Object)that.keyType);
    }

    public int hashCode() {
        int result = 31 * this.magicByte;
        result = 31 * result + this.keyType.hashCode();
        return result;
    }

    @Override
    public int compareTo(SecretRegistryKey otherKey) {
        return this.keyType.compareTo(otherKey.keyType);
    }
}

