/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.secretregistry.crypto.Encrypted;
import io.confluent.kafka.secretregistry.storage.SecretKey;
import io.confluent.kafka.secretregistry.storage.SecretRegistryValue;
import jakarta.validation.constraints.Min;
import java.util.Objects;
import org.hibernate.validator.constraints.NotEmpty;

public class SecretValue
implements Comparable<SecretValue>,
SecretRegistryValue {
    @NotEmpty
    private String path;
    @NotEmpty
    private String key;
    @Min(value=1L)
    private @Min(value=1L) Integer version;
    @NotEmpty
    private Encrypted encrypted;
    @NotEmpty
    private String checksum;
    private String createdBy;
    @NotEmpty
    private Long createdAt;

    public SecretValue(@JsonProperty(value="path") String path, @JsonProperty(value="key") String key, @JsonProperty(value="version") Integer version, @JsonProperty(value="encrypted") Encrypted encrypted, @JsonProperty(value="checksum") String checksum, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="createdAt") Long createdAt) {
        this.path = path;
        this.key = key;
        this.version = version;
        this.encrypted = encrypted;
        this.checksum = checksum;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @JsonProperty(value="encrypted")
    public Encrypted getEncrypted() {
        return this.encrypted;
    }

    @JsonProperty(value="encrypted")
    public void setEncrypted(Encrypted encrypted) {
        this.encrypted = encrypted;
    }

    @JsonProperty(value="checksum")
    public String getChecksum() {
        return this.checksum;
    }

    @JsonProperty(value="checksum")
    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @JsonProperty(value="createdAt")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretValue that = (SecretValue)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.key, that.key) && Objects.equals(this.version, that.version) && Objects.equals(this.encrypted, that.encrypted) && Objects.equals(this.checksum, that.checksum) && Objects.equals(this.createdBy, that.createdBy) && Objects.equals(this.createdAt, that.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.key, this.version, this.encrypted, this.checksum, this.createdBy, this.createdAt);
    }

    public String toString() {
        return "SecretValue{path='" + this.path + "', key='" + this.key + "', version=" + this.version + ", encrypted=" + String.valueOf(this.encrypted) + ", checksum='" + this.checksum + "', createdBy='" + this.createdBy + "', createdAt=" + this.createdAt + "}";
    }

    @Override
    public int compareTo(SecretValue that) {
        if (this.path.compareTo(that.path) < 0) {
            return -1;
        }
        if (this.path.compareTo(that.path) > 0) {
            return 1;
        }
        if (SecretKey.compareKeys(this.key, that.key) < 0) {
            return -1;
        }
        if (SecretKey.compareKeys(this.key, that.key) > 0) {
            return 1;
        }
        if (this.version.compareTo(that.version) < 0) {
            return -1;
        }
        if (this.version.compareTo(that.version) > 0) {
            return 1;
        }
        if (this.checksum.compareTo(that.checksum) < 0) {
            return -1;
        }
        if (this.checksum.compareTo(that.checksum) > 0) {
            return 1;
        }
        return 0;
    }
}

