/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.tools;

import io.confluent.common.utils.AbstractPerformanceTest;
import io.confluent.common.utils.PerformanceStats;
import io.confluent.kafka.secretregistry.client.rest.RestService;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;

public class SecretRegistryPerformance
extends AbstractPerformanceTest {
    long targetRegisteredSecrets;
    long targetSecretsPerSec;
    String baseUrl;
    RestService restService;
    String path;
    long registeredSecrets = 0L;
    long successfullyRegisteredSecrets = 0L;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.out.println("Usage: java " + SecretRegistryPerformance.class.getName() + " secret_registry_url path num_secrets target_secrets_per_sec");
            System.exit(1);
        }
        String baseUrl = args[0];
        String path = args[1];
        int numSecrets = Integer.parseInt(args[2]);
        int targetSecretsPerSec = Integer.parseInt(args[3]);
        SecretRegistryPerformance perf = new SecretRegistryPerformance(baseUrl, path, numSecrets, targetSecretsPerSec);
        perf.run(targetSecretsPerSec);
        perf.close();
    }

    public SecretRegistryPerformance(String baseUrl, String path, long numSecrets, long targetSecretsPerSec) throws Exception {
        super(numSecrets);
        this.baseUrl = baseUrl;
        this.restService = new RestService(baseUrl);
        this.path = path;
        this.targetRegisteredSecrets = numSecrets;
        this.targetSecretsPerSec = targetSecretsPerSec;
    }

    private static String makeSecret(long num) {
        String secretString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f" + num + "\"}]}";
        return secretString;
    }

    protected void doIteration(PerformanceStats.Callback cb) {
        String secret = SecretRegistryPerformance.makeSecret(this.registeredSecrets);
        String key = "key";
        try {
            this.restService.registerSecret(secret, key, this.path);
            ++this.successfullyRegisteredSecrets;
        }
        catch (IOException e) {
            System.out.println("Problem registering secret: " + e.getMessage());
        }
        catch (RestClientException e) {
            System.out.println("Problem registering secret: " + e.getMessage());
        }
        ++this.registeredSecrets;
        cb.onCompletion(1, 0L);
    }

    protected void close() {
        if ((double)this.successfullyRegisteredSecrets / (double)this.targetRegisteredSecrets < 0.99) {
            throw new RuntimeException("Too many secret registration errors: " + this.successfullyRegisteredSecrets + " registered successfully out of " + this.targetRegisteredSecrets + " attempted");
        }
    }

    protected boolean finished(int iteration) {
        return this.targetRegisteredSecrets == this.registeredSecrets;
    }

    protected boolean runningFast(int iteration, float elapsed) {
        return (float)iteration / elapsed > (float)this.targetSecretsPerSec;
    }
}

