/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.keys.implementation.models.JsonWebKeyEncryptionAlgorithm;
import java.io.IOException;
import java.util.Objects;

public final class KeyOperationsParameters
implements JsonSerializable<KeyOperationsParameters> {
    private final JsonWebKeyEncryptionAlgorithm algorithm;
    private final Base64Url value;
    private Base64Url iv;
    private Base64Url aad;
    private Base64Url tag;

    public KeyOperationsParameters(JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        this.algorithm = algorithm;
        this.value = value == null ? null : Base64Url.encode((byte[])value);
    }

    public JsonWebKeyEncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.decodedBytes();
    }

    public byte[] getIv() {
        if (this.iv == null) {
            return null;
        }
        return this.iv.decodedBytes();
    }

    public KeyOperationsParameters setIv(byte[] iv) {
        this.iv = iv == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])iv));
        return this;
    }

    public byte[] getAad() {
        if (this.aad == null) {
            return null;
        }
        return this.aad.decodedBytes();
    }

    public KeyOperationsParameters setAad(byte[] aad) {
        this.aad = aad == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])aad));
        return this;
    }

    public byte[] getTag() {
        if (this.tag == null) {
            return null;
        }
        return this.tag.decodedBytes();
    }

    public KeyOperationsParameters setTag(byte[] tag) {
        this.tag = tag == null ? null : Base64Url.encode((byte[])CoreUtils.clone((byte[])tag));
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("alg", this.algorithm == null ? null : this.algorithm.toString());
        jsonWriter.writeStringField("value", Objects.toString(this.value, null));
        jsonWriter.writeStringField("iv", Objects.toString(this.iv, null));
        jsonWriter.writeStringField("aad", Objects.toString(this.aad, null));
        jsonWriter.writeStringField("tag", Objects.toString(this.tag, null));
        return jsonWriter.writeEndObject();
    }

    public static KeyOperationsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyOperationsParameters)jsonReader.readObject(reader -> {
            JsonWebKeyEncryptionAlgorithm algorithm = null;
            byte[] value = null;
            Base64Url iv = null;
            Base64Url aad = null;
            Base64Url tag = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("alg".equals(fieldName)) {
                    algorithm = JsonWebKeyEncryptionAlgorithm.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    Base64Url valueHolder = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    if (valueHolder == null) continue;
                    value = valueHolder.decodedBytes();
                    continue;
                }
                if ("iv".equals(fieldName)) {
                    iv = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("aad".equals(fieldName)) {
                    aad = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("tag".equals(fieldName)) {
                    tag = (Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            KeyOperationsParameters deserializedKeyOperationsParameters = new KeyOperationsParameters(algorithm, value);
            deserializedKeyOperationsParameters.iv = iv;
            deserializedKeyOperationsParameters.aad = aad;
            deserializedKeyOperationsParameters.tag = tag;
            return deserializedKeyOperationsParameters;
        });
    }
}

