/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.Utils;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

class AccessibleByteArrayOutputStream
extends OutputStream
implements Cloneable {
    private final int limit;
    private byte[] buf;
    private int count;

    AccessibleByteArrayOutputStream() {
        this(32, Integer.MAX_VALUE);
    }

    AccessibleByteArrayOutputStream(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Limit must be non-negative");
        }
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("Capacity must be non-negative and less than limit");
        }
        this.buf = n == 0 ? Utils.EMPTY_ARRAY : new byte[n];
        this.limit = n2;
        this.count = 0;
    }

    public AccessibleByteArrayOutputStream clone() {
        try {
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = (AccessibleByteArrayOutputStream)super.clone();
            accessibleByteArrayOutputStream.buf = (byte[])this.buf.clone();
            return accessibleByteArrayOutputStream;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeCryptoException("Unexpected exception", cloneNotSupportedException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        Utils.checkArrayLimits(byArray, n, n2);
        this.growCapacity(this.count + n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    void finalWrite(byte[] byArray, int n, int n2) {
        Utils.checkArrayLimits(byArray, n, n2);
        this.growCapacity(this.count + n2, true);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    @Override
    public void write(int n) {
        this.growCapacity(this.count + 1);
        this.buf[this.count++] = (byte)n;
    }

    int size() {
        return this.count;
    }

    boolean isEmpty() {
        return this.count == 0;
    }

    byte[] getDataBuffer() {
        return this.buf;
    }

    void reset() {
        Arrays.fill(this.buf, 0, this.count, (byte)0);
        this.count = 0;
    }

    void write(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.growCapacity(this.count + n);
        byteBuffer.get(this.buf, this.count, n);
        this.count += n;
    }

    private void growCapacity(int n) {
        this.growCapacity(n, false);
    }

    private void growCapacity(int n, boolean bl) {
        if (n < 0 || n > this.limit) {
            throw new IllegalArgumentException(String.format("Invalid capacity. Limit: %d, Requested: %d.", this.limit, n));
        }
        if (n <= this.buf.length) {
            return;
        }
        byte[] byArray = Arrays.copyOf(this.buf, bl ? n : Math.max(Math.min(this.limit, this.buf.length << 1), n));
        byte[] byArray2 = this.buf;
        this.buf = byArray;
        Arrays.fill(byArray2, 0, this.count, (byte)0);
    }
}

