/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.ConcatenationKdfSpec;
import com.amazon.corretto.crypto.provider.KdfSpi;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class ConcatenationKdfSpi
extends KdfSpi {
    private final int digestCode;
    private final boolean digestAsPrf;
    static final Map<String, ConcatenationKdfSpi> INSTANCES = ConcatenationKdfSpi.getInstances();
    private static final String CKDF = "ConcatenationKdf";
    private static final String WITH = "With";
    static final String CKDF_WITH_SHA256 = "ConcatenationKdfWithSHA256";
    static final String CKDF_WITH_SHA384 = "ConcatenationKdfWithSHA384";
    static final String CKDF_WITH_SHA512 = "ConcatenationKdfWithSHA512";
    static final String CKDF_WITH_HMAC_SHA256 = "ConcatenationKdfWithHmacSHA256";
    static final String CKDF_WITH_HMAC_SHA512 = "ConcatenationKdfWithHmacSHA512";

    ConcatenationKdfSpi(int n, boolean bl) {
        this.digestCode = n;
        this.digestAsPrf = bl;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof ConcatenationKdfSpec)) {
            throw new InvalidKeySpecException("Expected a key spec of type ConcatenationKdfSpi.");
        }
        ConcatenationKdfSpec concatenationKdfSpec = (ConcatenationKdfSpec)keySpec;
        byte[] byArray = new byte[concatenationKdfSpec.getOutputLen()];
        if (this.digestAsPrf) {
            ConcatenationKdfSpi.nSskdfDigest(this.digestCode, concatenationKdfSpec.getSecret(), concatenationKdfSpec.getSecret().length, concatenationKdfSpec.getInfo(), concatenationKdfSpec.getInfo().length, byArray, byArray.length);
        } else {
            ConcatenationKdfSpi.nSskdfHmac(this.digestCode, concatenationKdfSpec.getSecret(), concatenationKdfSpec.getSecret().length, concatenationKdfSpec.getInfo(), concatenationKdfSpec.getInfo().length, concatenationKdfSpec.getSalt(), concatenationKdfSpec.getSalt().length, byArray, byArray.length);
        }
        return new SecretKeySpec(byArray, concatenationKdfSpec.getAlgorithmName());
    }

    private static native void nSskdfDigest(int var0, byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void nSskdfHmac(int var0, byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    private static Map<String, ConcatenationKdfSpi> getInstances() {
        HashMap<String, ConcatenationKdfSpi> hashMap = new HashMap<String, ConcatenationKdfSpi>();
        hashMap.put(ConcatenationKdfSpi.getSpiFactoryForAlgName(CKDF_WITH_SHA256), new ConcatenationKdfSpi(2, true));
        hashMap.put(ConcatenationKdfSpi.getSpiFactoryForAlgName(CKDF_WITH_SHA384), new ConcatenationKdfSpi(3, true));
        hashMap.put(ConcatenationKdfSpi.getSpiFactoryForAlgName(CKDF_WITH_SHA512), new ConcatenationKdfSpi(4, true));
        hashMap.put(ConcatenationKdfSpi.getSpiFactoryForAlgName(CKDF_WITH_HMAC_SHA256), new ConcatenationKdfSpi(2, false));
        hashMap.put(ConcatenationKdfSpi.getSpiFactoryForAlgName(CKDF_WITH_HMAC_SHA512), new ConcatenationKdfSpi(4, false));
        return Collections.unmodifiableMap(hashMap);
    }

    static String getSpiFactoryForAlgName(String string) {
        return string.toUpperCase();
    }
}

