/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.CounterKdfSpec;
import com.amazon.corretto.crypto.provider.KdfSpi;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class CounterKdfSpi
extends KdfSpi {
    private final int digestCode;
    static final Map<String, CounterKdfSpi> INSTANCES = CounterKdfSpi.getInstances();
    static final String CTR_KDF_WITH_HMAC_SHA256 = "CounterKdfWithHmacSHA256";
    static final String CTR_KDF_WITH_HMAC_SHA384 = "CounterKdfWithHmacSHA384";
    static final String CTR_KDF_WITH_HMAC_SHA512 = "CounterKdfWithHmacSHA512";

    CounterKdfSpi(int n) {
        this.digestCode = n;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof CounterKdfSpec)) {
            throw new InvalidKeySpecException("Expected a key spec of type CounterKdfSpec");
        }
        CounterKdfSpec counterKdfSpec = (CounterKdfSpec)keySpec;
        byte[] byArray = counterKdfSpec.getSecret();
        byte[] byArray2 = counterKdfSpec.getInfo();
        byte[] byArray3 = new byte[counterKdfSpec.getOutputLen()];
        CounterKdfSpi.nKdf(this.digestCode, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length);
        return new SecretKeySpec(byArray3, counterKdfSpec.getAlgorithName());
    }

    private static native void nKdf(int var0, byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static Map<String, CounterKdfSpi> getInstances() {
        HashMap<String, CounterKdfSpi> hashMap = new HashMap<String, CounterKdfSpi>();
        hashMap.put(CounterKdfSpi.getSpiFactoryForAlgName(CTR_KDF_WITH_HMAC_SHA256), new CounterKdfSpi(2));
        hashMap.put(CounterKdfSpi.getSpiFactoryForAlgName(CTR_KDF_WITH_HMAC_SHA384), new CounterKdfSpi(3));
        hashMap.put(CounterKdfSpi.getSpiFactoryForAlgName(CTR_KDF_WITH_HMAC_SHA512), new CounterKdfSpi(4));
        return Collections.unmodifiableMap(hashMap);
    }

    static String getSpiFactoryForAlgName(String string) {
        return string.toUpperCase();
    }
}

