/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class URLEncodeFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$encodeUrl");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$encodeUrl");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$encodeUrl");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        NullNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = URLEncodeFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount != 1) throw new EvaluateRuntimeException(argCount == 0 ? ERR_BAD_CONTEXT : ERR_ARG2BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) {
            return null;
        }
        if (!argString.isTextual()) throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        String str = argString.textValue();
        try {
            String strResult = "";
            URL url = new URL(str);
            String query = url.getQuery();
            if (query == null) return new TextNode(str);
            int offset = str.indexOf(query);
            if (offset <= 0) return result;
            strResult = str.substring(0, offset);
            return new TextNode(strResult + this.encodeURI(query));
        }
        catch (MalformedURLException e) {
            throw new EvaluateRuntimeException("Malformed URL passed to $encodeUrl: \"" + str + "\"");
        }
    }

    String encodeURI(String uri) {
        String result = null;
        if (uri != null) {
            try {
                result = URLEncoder.encode(uri, "UTF-8").replaceAll("\\+", "%20").replaceAll("%20", " ").replaceAll("\\%21", "!").replaceAll("\\%23", "#").replaceAll("\\%24", "$").replaceAll("\\%26", "&").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%2A", "*").replaceAll("\\%2B", "+").replaceAll("\\%2C", ",").replaceAll("\\%2D", "-").replaceAll("\\%2E", ".").replaceAll("\\%2F", "/").replaceAll("\\%3A", ":").replaceAll("\\%3B", ";").replaceAll("\\%3D", "=").replaceAll("\\%3F", "?").replaceAll("\\%40", "@").replaceAll("\\%5F", "_").replaceAll("\\%7E", "~");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 1;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<s-:n>";
    }
}

