/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.svid.jwtsvid;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.spiffe.bundle.BundleSource;
import io.spiffe.bundle.jwtbundle.JwtBundle;
import io.spiffe.exception.AuthorityNotFoundException;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.exception.InvalidSpiffeIdException;
import io.spiffe.exception.JwtSvidException;
import io.spiffe.internal.JwtSignatureAlgorithm;
import io.spiffe.spiffeid.SpiffeId;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class JwtSvid {
    private final SpiffeId spiffeId;
    private final Set<String> audience;
    private final Date expiry;
    private final Map<String, Object> claims;
    private final String token;
    private final Date issuedAt;
    private final String hint;
    public static final String HEADER_TYP_JWT = "JWT";
    public static final String HEADER_TYP_JOSE = "JOSE";

    private JwtSvid(SpiffeId spiffeId, Set<String> audience, Date issuedAt, Date expiry, Map<String, Object> claims, String token, String hint) {
        this.spiffeId = spiffeId;
        this.audience = audience;
        this.expiry = expiry;
        this.claims = claims;
        this.token = token;
        this.issuedAt = issuedAt;
        this.hint = hint;
    }

    public static JwtSvid parseAndValidate(@NonNull String token, @NonNull BundleSource<JwtBundle> jwtBundleSource, @NonNull Set<String> audience) throws JwtSvidException, BundleNotFoundException, AuthorityNotFoundException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (jwtBundleSource == null) {
            throw new NullPointerException("jwtBundleSource is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        return JwtSvid.parseAndValidate(token, jwtBundleSource, audience, null);
    }

    public static JwtSvid parseAndValidate(@NonNull String token, @NonNull BundleSource<JwtBundle> jwtBundleSource, @NonNull Set<String> audience, String hint) throws JwtSvidException, BundleNotFoundException, AuthorityNotFoundException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (jwtBundleSource == null) {
            throw new NullPointerException("jwtBundleSource is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token cannot be blank");
        }
        SignedJWT signedJwt = JwtSvid.getSignedJWT(token);
        JwtSvid.validateTypeHeader(signedJwt.getHeader());
        JwtSignatureAlgorithm algorithm = JwtSvid.parseAlgorithm(signedJwt.getHeader().getAlgorithm());
        JWTClaimsSet claimsSet = JwtSvid.getJwtClaimsSet(signedJwt);
        JwtSvid.validateAudience(claimsSet.getAudience(), audience);
        Date issuedAt = claimsSet.getIssueTime();
        Date expirationTime = claimsSet.getExpirationTime();
        JwtSvid.validateExpiration(expirationTime);
        SpiffeId spiffeId = JwtSvid.getSpiffeIdOfSubject(claimsSet);
        JwtBundle jwtBundle = jwtBundleSource.getBundleForTrustDomain(spiffeId.getTrustDomain());
        String keyId = JwtSvid.getKeyId(signedJwt.getHeader());
        PublicKey jwtAuthority = jwtBundle.findJwtAuthority(keyId);
        JwtSvid.verifySignature(signedJwt, jwtAuthority, algorithm, keyId);
        HashSet<String> claimAudience = new HashSet<String>(claimsSet.getAudience());
        return new JwtSvid(spiffeId, claimAudience, issuedAt, expirationTime, claimsSet.getClaims(), token, hint);
    }

    public static JwtSvid parseInsecure(@NonNull String token, @NonNull Set<String> audience) throws JwtSvidException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        return JwtSvid.parseInsecure(token, audience, null);
    }

    public static JwtSvid parseInsecure(@NonNull String token, @NonNull Set<String> audience, String hint) throws JwtSvidException {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (audience == null) {
            throw new NullPointerException("audience is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token cannot be blank");
        }
        SignedJWT signedJwt = JwtSvid.getSignedJWT(token);
        JwtSvid.validateTypeHeader(signedJwt.getHeader());
        JwtSvid.parseAlgorithm(signedJwt.getHeader().getAlgorithm());
        JWTClaimsSet claimsSet = JwtSvid.getJwtClaimsSet(signedJwt);
        JwtSvid.validateAudience(claimsSet.getAudience(), audience);
        Date issuedAt = claimsSet.getIssueTime();
        Date expirationTime = claimsSet.getExpirationTime();
        JwtSvid.validateExpiration(expirationTime);
        SpiffeId spiffeId = JwtSvid.getSpiffeIdOfSubject(claimsSet);
        HashSet<String> claimAudience = new HashSet<String>(claimsSet.getAudience());
        return new JwtSvid(spiffeId, claimAudience, issuedAt, expirationTime, claimsSet.getClaims(), token, hint);
    }

    public String marshal() {
        return this.token;
    }

    public Date getExpiry() {
        return new Date(this.expiry.getTime());
    }

    public String getHint() {
        return this.hint;
    }

    public Map<String, Object> getClaims() {
        return Collections.unmodifiableMap(this.claims);
    }

    public Set<String> getAudience() {
        return Collections.unmodifiableSet(this.audience);
    }

    private static JWTClaimsSet getJwtClaimsSet(SignedJWT signedJwt) {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = signedJwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse JWT token", e);
        }
        return claimsSet;
    }

    private static SignedJWT getSignedJWT(String token) {
        SignedJWT signedJwt;
        try {
            signedJwt = SignedJWT.parse((String)token);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to parse JWT token", e);
        }
        return signedJwt;
    }

    private static void verifySignature(SignedJWT signedJwt, PublicKey jwtAuthority, JwtSignatureAlgorithm algorithm, String keyId) throws JwtSvidException {
        boolean verify;
        try {
            JWSVerifier verifier = JwtSvid.getJwsVerifier(jwtAuthority, algorithm);
            verify = signedJwt.verify(verifier);
        }
        catch (JOSEException | ClassCastException e) {
            throw new JwtSvidException(String.format("Error verifying signature with the authority with keyId=%s", keyId), e);
        }
        if (!verify) {
            throw new JwtSvidException(String.format("Signature invalid: cannot be verified with the authority with keyId=%s", keyId));
        }
    }

    private static JWSVerifier getJwsVerifier(PublicKey jwtAuthority, JwtSignatureAlgorithm algorithm) throws JOSEException, JwtSvidException {
        ECDSAVerifier verifier;
        if (JwtSignatureAlgorithm.Family.EC.contains(algorithm)) {
            verifier = new ECDSAVerifier((ECPublicKey)jwtAuthority);
        } else if (JwtSignatureAlgorithm.Family.RSA.contains(algorithm)) {
            verifier = new RSASSAVerifier((RSAPublicKey)jwtAuthority);
        } else {
            throw new JwtSvidException(String.format("Unsupported token signature algorithm %s", new Object[]{algorithm}));
        }
        return verifier;
    }

    private static String getKeyId(JWSHeader header) throws JwtSvidException {
        String keyId = header.getKeyID();
        if (keyId == null) {
            throw new JwtSvidException("Token header missing key id");
        }
        if (StringUtils.isBlank((CharSequence)keyId)) {
            throw new JwtSvidException("Token header key id contains an empty value");
        }
        return keyId;
    }

    private static void validateExpiration(Date expirationTime) throws JwtSvidException {
        if (expirationTime == null) {
            throw new JwtSvidException("Token missing expiration claim");
        }
        if (expirationTime.before(new Date())) {
            throw new JwtSvidException("Token has expired");
        }
    }

    private static SpiffeId getSpiffeIdOfSubject(JWTClaimsSet claimsSet) throws JwtSvidException {
        String subject = claimsSet.getSubject();
        if (StringUtils.isBlank((CharSequence)subject)) {
            throw new JwtSvidException("Token missing subject claim");
        }
        try {
            return SpiffeId.parse(subject);
        }
        catch (InvalidSpiffeIdException e) {
            throw new JwtSvidException(String.format("Subject %s cannot be parsed as a SPIFFE ID", subject), e);
        }
    }

    private static void validateAudience(List<String> audClaim, Set<String> expectedAudiences) throws JwtSvidException {
        if (!audClaim.containsAll(expectedAudiences)) {
            throw new JwtSvidException(String.format("expected audience in %s (audience=%s)", expectedAudiences, audClaim));
        }
    }

    private static JwtSignatureAlgorithm parseAlgorithm(JWSAlgorithm algorithm) throws JwtSvidException {
        if (algorithm == null) {
            throw new JwtSvidException("JWT header 'alg' is required");
        }
        try {
            return JwtSignatureAlgorithm.parse(algorithm.getName());
        }
        catch (IllegalArgumentException e) {
            throw new JwtSvidException(e.getMessage(), e);
        }
    }

    private static void validateTypeHeader(JWSHeader headers) throws JwtSvidException {
        JOSEObjectType type = headers.getType();
        if (type == null || StringUtils.isBlank((CharSequence)type.toString())) {
            return;
        }
        String typValue = type.toString();
        if (!HEADER_TYP_JWT.equals(typValue) && !HEADER_TYP_JOSE.equals(typValue)) {
            throw new JwtSvidException(String.format("If JWT header 'typ' is present, it must be either 'JWT' or 'JOSE'. Got: '%s'.", type.toString()));
        }
    }

    @Generated
    public SpiffeId getSpiffeId() {
        return this.spiffeId;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Date getIssuedAt() {
        return this.issuedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtSvid)) {
            return false;
        }
        JwtSvid other = (JwtSvid)o;
        SpiffeId this$spiffeId = this.getSpiffeId();
        SpiffeId other$spiffeId = other.getSpiffeId();
        if (this$spiffeId == null ? other$spiffeId != null : !((Object)this$spiffeId).equals(other$spiffeId)) {
            return false;
        }
        Set<String> this$audience = this.getAudience();
        Set<String> other$audience = other.getAudience();
        if (this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience)) {
            return false;
        }
        Date this$expiry = this.getExpiry();
        Date other$expiry = other.getExpiry();
        if (this$expiry == null ? other$expiry != null : !((Object)this$expiry).equals(other$expiry)) {
            return false;
        }
        Map<String, Object> this$claims = this.getClaims();
        Map<String, Object> other$claims = other.getClaims();
        if (this$claims == null ? other$claims != null : !((Object)this$claims).equals(other$claims)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Date this$issuedAt = this.getIssuedAt();
        Date other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        String this$hint = this.getHint();
        String other$hint = other.getHint();
        return !(this$hint == null ? other$hint != null : !this$hint.equals(other$hint));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpiffeId $spiffeId = this.getSpiffeId();
        result = result * 59 + ($spiffeId == null ? 43 : ((Object)$spiffeId).hashCode());
        Set<String> $audience = this.getAudience();
        result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
        Date $expiry = this.getExpiry();
        result = result * 59 + ($expiry == null ? 43 : ((Object)$expiry).hashCode());
        Map<String, Object> $claims = this.getClaims();
        result = result * 59 + ($claims == null ? 43 : ((Object)$claims).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Date $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        String $hint = this.getHint();
        result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JwtSvid(spiffeId=" + this.getSpiffeId() + ", audience=" + this.getAudience() + ", expiry=" + this.getExpiry() + ", claims=" + this.getClaims() + ", token=" + this.getToken() + ", issuedAt=" + this.getIssuedAt() + ", hint=" + this.getHint() + ")";
    }
}

