/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.AsyncProxyManager;
import io.github.bucket4j.distributed.proxy.RemoteAsyncBucketBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class AsyncProxyManagerView<K, OldKey>
implements AsyncProxyManager<K> {
    private final AsyncProxyManager<OldKey> target;
    private final Function<? super K, OldKey> mapper;

    public AsyncProxyManagerView(AsyncProxyManager<OldKey> target, Function<K, OldKey> mapper) {
        this.target = target;
        this.mapper = mapper;
    }

    @Override
    public AsyncBucketProxy getProxy(K key, Supplier<CompletableFuture<BucketConfiguration>> configurationSupplier) {
        return this.target.getProxy(this.mapper.apply(key), configurationSupplier);
    }

    @Override
    public RemoteAsyncBucketBuilder<K> builder() {
        return this.target.builder().withMapper(this.mapper);
    }

    @Override
    public CompletableFuture<Void> removeProxy(K key) {
        return this.target.removeProxy(this.mapper.apply(key));
    }

    @Override
    public CompletableFuture<Optional<BucketConfiguration>> getProxyConfiguration(K key) {
        return this.target.getProxyConfiguration(this.mapper.apply(key));
    }

    @Override
    public <K2> AsyncProxyManager<K2> withMapper(Function<? super K2, ? extends K> innerMapper) {
        return this.target.withMapper(this.mapper.compose(innerMapper));
    }
}

