/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandError;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.UsageOfObsoleteApiException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UsageOfObsoleteApiError
implements ComparableByContent<UsageOfObsoleteApiError>,
CommandError {
    private final int requestedFormatNumber;
    private final int minSupportedFormatNumber;
    public static final SerializationHandle<UsageOfObsoleteApiError> SERIALIZATION_HANDLE = new SerializationHandle<UsageOfObsoleteApiError>(){

        @Override
        public <S> UsageOfObsoleteApiError deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int requestedFormatNumber = adapter.readInt(input);
            int minSupportedFormatNumber = adapter.readInt(input);
            return new UsageOfObsoleteApiError(requestedFormatNumber, minSupportedFormatNumber);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, UsageOfObsoleteApiError error, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter.writeInt(output, error.requestedFormatNumber);
            adapter.writeInt(output, error.minSupportedFormatNumber);
        }

        @Override
        public int getTypeId() {
            return 17;
        }

        @Override
        public Class<UsageOfObsoleteApiError> getSerializedType() {
            return UsageOfObsoleteApiError.class;
        }

        @Override
        public UsageOfObsoleteApiError fromJsonCompatibleSnapshot(Map<String, Object> snapshot) {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            int requestedFormatNumber = this.readIntValue(snapshot, "requestedFormatNumber");
            int minSupportedFormatNumber = this.readIntValue(snapshot, "minSupportedFormatNumber");
            return new UsageOfObsoleteApiError(requestedFormatNumber, minSupportedFormatNumber);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(UsageOfObsoleteApiError error, Version backwardCompatibilityVersion, Scope scope) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("requestedFormatNumber", error.requestedFormatNumber);
            result.put("minSupportedFormatNumber", error.minSupportedFormatNumber);
            return result;
        }

        @Override
        public String getTypeName() {
            return "UsageOfObsoleteApiError";
        }
    };

    public UsageOfObsoleteApiError(int requestedFormatNumber, int minSupportedFormatNumber) {
        this.requestedFormatNumber = requestedFormatNumber;
        this.minSupportedFormatNumber = minSupportedFormatNumber;
    }

    public int getRequestedFormatNumber() {
        return this.requestedFormatNumber;
    }

    public int getMinSupportedFormatNumber() {
        return this.minSupportedFormatNumber;
    }

    @Override
    public RuntimeException asException() {
        return new UsageOfObsoleteApiException(this.requestedFormatNumber, this.minSupportedFormatNumber);
    }

    @Override
    public boolean equalsByContent(UsageOfObsoleteApiError other) {
        return other.requestedFormatNumber == this.requestedFormatNumber && other.minSupportedFormatNumber == this.minSupportedFormatNumber;
    }
}

