/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer;
import kafka.server.Server;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.DefaultUncaughtExceptionHandler;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Java;
import org.apache.kafka.common.utils.LoggingSignalHandler;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function0;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.ScalaRunTime$;

public final class Kafka$
implements Logging {
    public static final Kafka$ MODULE$ = new Kafka$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Kafka$ kafka$ = this;
        synchronized (kafka$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Properties getPropsFromArgs(String[] args) {
        Properties props;
        block3: {
            OptionParser optionParser = new OptionParser(false);
            ArgumentAcceptingOptionSpec<String> overrideOpt = optionParser.accepts("override", "Optional property that should override values set in server.properties file").withRequiredArg().ofType(String.class);
            optionParser.accepts("version", "Print version information and exit.");
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(args)) || ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(args), "--help")) {
                CommandLineUtils.printUsageAndExit(optionParser, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("USAGE: java [options] %s server.properties [--override property=value]*"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.getClass().getCanonicalName()), '$')))})));
            }
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(args), "--version")) {
                CommandLineUtils.printVersionAndExit();
            }
            props = Utils.loadProps(args[0]);
            if (args.length <= 1) break block3;
            OptionSet options = optionParser.parse((String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps(args), 1, args.length));
            if (options.nonOptionArguments().size() > 0) {
                CommandLineUtils.printUsageAndExit(optionParser, "Found non argument parameters: " + Predef$.MODULE$.wrapRefArray(options.nonOptionArguments().toArray()).mkString(","));
            }
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(CommandLineUtils.parseKeyValueArgs(options.valuesOf(overrideOpt)));
        }
        return props;
    }

    private Server buildServer(Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props, false);
        return new KafkaRaftServer(config, Time.SYSTEM);
    }

    public void main(String[] args) {
        try {
            DefaultUncaughtExceptionHandler.enableExitOnOutOfMemoryError(true);
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(this.logger().underlying()));
            Properties serverProps = this.getPropsFromArgs(args);
            Server server = this.buildServer(serverProps);
            try {
                if (!OperatingSystem.IS_WINDOWS && !Java.isIbmJdk()) {
                    new LoggingSignalHandler().register();
                }
            }
            catch (ReflectiveOperationException e) {
                this.warn((Function0<String> & Serializable)() -> "Failed to register optional signal handler that logs a message when the process is terminated by a signal. Reason for registration failure is: " + e, (Function0<Throwable>)(Function0<ReflectiveOperationException> & Serializable)() -> e);
            }
            Exit.addShutdownHook("kafka-shutdown-hook", () -> {
                try {
                    server.shutdown();
                }
                catch (Throwable throwable) {
                    MODULE$.fatal((Function0<String> & Serializable)() -> "Halting Kafka.");
                    Exit.halt(1);
                }
            });
            try {
                server.startup();
            }
            catch (Throwable e) {
                this.fatal((Function0<String> & Serializable)() -> "Exiting Kafka due to fatal exception during startup.", (Function0<Throwable> & Serializable)() -> e);
                Exit.exit(1);
            }
            server.awaitShutdown();
        }
        catch (Throwable e) {
            this.fatal((Function0<String> & Serializable)() -> "Exiting Kafka due to fatal exception", (Function0<Throwable> & Serializable)() -> e);
            Exit.exit(1);
        }
        Exit.exit(0);
    }

    private Kafka$() {
    }
}

