/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import kafka.admin.ClusterLinkCommandOptions;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.TopicFilterJson;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DescribeClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.AdminCommandFailedException;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkCommand$
implements Logging {
    public static final ClusterLinkCommand$ MODULE$ = new ClusterLinkCommand$();
    private static final SimpleDateFormat dateFormatter;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClusterLinkCommand$ clusterLinkCommand$ = this;
        synchronized (clusterLinkCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public SimpleDateFormat dateFormatter() {
        return dateFormatter;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Error while executing cluster link command: " + e.getMessage());
                this.error((Function0<String> & Serializable)() -> Utils.stackTrace(e));
                exitCode = 1;
            }
        }
        finally {
            Exit.exit(exitCode);
        }
    }

    private ConfluentAdmin createAdminClient(ClusterLinkCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps(opts.options.valueOf(opts.commandConfigOpt())) : new Properties();
        props.setProperty("bootstrap.servers", opts.options.valueOf(opts.bootstrapServer()));
        return (ConfluentAdmin)((Object)AdminClient.create(props));
    }

    private String verifyPropertyAndFilters(ClusterLinkCommandOptions opts, Properties props, String propName, ArgumentAcceptingOptionSpec<String> jsonFileOpt, ArgumentAcceptingOptionSpec<String> filterJsonOpt) {
        String jsonString;
        block6: {
            Tuple2<String, Boolean> tuple2;
            boolean isSourceLink = Option$.MODULE$.apply(props.getProperty(ClusterLinkConfig$.MODULE$.LinkModeProp())).contains(ClusterLinkConfig.LinkMode.SOURCE.name());
            boolean propValue = props.getProperty(propName, "false").equals("true");
            Tuple2<String, Boolean> tuple22 = opts.options.has(jsonFileOpt) ? new Tuple2<String, Boolean>(Utils.readFileAsString(opts.valueOf(jsonFileOpt)), BoxesRunTime.boxToBoolean(false)) : (tuple2 = opts.options.has(filterJsonOpt) ? new Tuple2<String, Boolean>(opts.valueOf(filterJsonOpt), BoxesRunTime.boxToBoolean(true)) : new Tuple2<String, Boolean>("", BoxesRunTime.boxToBoolean(false)));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String jsonString2 = tuple2._1();
            boolean isFilterJsonOpt = tuple2._2$mcZ$sp();
            Tuple2<String, Boolean> tuple23 = new Tuple2<String, Boolean>(jsonString2, BoxesRunTime.boxToBoolean(isFilterJsonOpt));
            jsonString = tuple23._1();
            boolean isFilterJsonOpt2 = tuple23._2$mcZ$sp();
            if (isSourceLink) {
                if (propValue) {
                    Predef$.MODULE$.println("Ignoring " + propName + " for source cluster link creation");
                    v1 = props.remove(propName);
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(jsonString))) {
                    String optionName = isFilterJsonOpt2 ? filterJsonOpt.options().get(0) : jsonFileOpt.options().get(0);
                    Predef$.MODULE$.println("Ignoring " + optionName + " for source cluster link creation");
                }
                return "";
            }
            if (propValue && jsonString.trim().isEmpty()) {
                opts.printMessageAndExit(propName + " is set to true but the JSON filters are not passed in. Please pass in the path to the JSON file using the --" + jsonFileOpt.options().get(0) + " option and rerun the create link command.");
            }
            if (propValue || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(jsonString.trim()))) break block6;
            opts.printMessageAndExit(propName + " is set to false but JSON filters are passed in. Please set " + propName + " to true in the link configuration and rerun the create link command with the passed in JSON filters.");
        }
        return jsonString;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Map<String, String> loadConfigs(ClusterLinkCommandOptions opts) {
        Properties properties;
        if (opts.options.has(opts.configOpt())) {
            properties = this.parseConfigs(opts.valueOf(opts.configOpt()));
        } else {
            Predef$.MODULE$.require(opts.options.has(opts.configFileOpt()));
            properties = Utils.loadProps(opts.options.valueOf(opts.configFileOpt()));
        }
        Properties props = properties;
        String aclFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), opts.aclFiltersJsonFileOpt(), opts.aclFiltersJsonOpt());
        String consumerOffsetFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), opts.consumerGroupFiltersJsonFileOpt(), opts.consumerGroupFiltersJsonOpt());
        String topicFilterJsonString = this.verifyPropertyAndFilters(opts, props, ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), opts.topicFiltersJsonFileOpt(), opts.topicFiltersJsonOpt());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(aclFilterJsonString))) {
            Option<AclFiltersJson> aclJson = AclJson$.MODULE$.parse(aclFilterJsonString);
            Option<AclFiltersJson> option = aclJson;
            if (option instanceof Some) {
                v1 = props.put(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilterJsonString);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                opts.printMessageAndExit(ClusterLinkConfig$.MODULE$.AclSyncEnableProp() + " is set to true but the JSON file passed has invalid values. Please put valid values in the JSON file and rerun the create link command.");
                v1 = BoxedUnit.UNIT;
            }
        } else {
            v1 = BoxedUnit.UNIT;
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(consumerOffsetFilterJsonString))) {
            Option<GroupFilterJson> offsetJson = ClusterLinkFilterJson$.MODULE$.parseGroup(consumerOffsetFilterJsonString);
            Option<GroupFilterJson> option = offsetJson;
            if (option instanceof Some) {
                v2 = props.put(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), consumerOffsetFilterJsonString);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                opts.printMessageAndExit(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp() + " is set to true but the JSON file passed has invalid values. Please put valid values in the JSON file and rerun the create link command.");
                v2 = BoxedUnit.UNIT;
            }
        } else {
            v2 = BoxedUnit.UNIT;
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicFilterJsonString))) {
            Option<TopicFilterJson> topicsJson = ClusterLinkFilterJson$.MODULE$.parseTopic(topicFilterJsonString);
            Option<TopicFilterJson> option = topicsJson;
            if (option instanceof Some) {
                v3 = props.put(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), topicFilterJsonString);
                return CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().toMap($less$colon$less$.MODULE$.refl());
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                opts.printMessageAndExit(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp() + " is set to true but the JSON file passed has invalid values. Please put valid values in the JSON file and rerun the create link command.");
                v3 = BoxedUnit.UNIT;
            }
            return CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().toMap($less$colon$less$.MODULE$.refl());
        } else {
            v3 = BoxedUnit.UNIT;
        }
        return CollectionConverters$.MODULE$.PropertiesHasAsScala(props).asScala().toMap($less$colon$less$.MODULE$.refl());
    }

    public Properties parseConfigs(String configs) {
        String pattern = "(?=[^\\]]*(?:\\[|$))";
        String[][] splitConfigs = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(configs.split("," + pattern)), (Function1<String, String[]> & Serializable)x$2 -> x$2.split("\\s*=\\s*" + pattern, -1), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])splitConfigs), (Function1<String[], Object> & Serializable)config -> BoxesRunTime.boxToBoolean(ClusterLinkCommand$.$anonfun$parseConfigs$2(config))), (Function0<Object>)(Function0<String> & Serializable)() -> "Invalid config: all configs must be in the format \"key=val\".");
        Properties props = new Properties();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])splitConfigs), (Function1<String[], Object> & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
        return props;
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        block17: {
            ClusterLinkCommandOptions opts = new ClusterLinkCommandOptions(args);
            opts.checkArgs();
            try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0<ConfluentAdmin> & Serializable)() -> MODULE$.createAdminClient(opts));){
                try {
                    if (opts.options.has(opts.createOpt())) {
                        this.createClusterLink(opts, client);
                    } else if (opts.options.has(opts.listOpt())) {
                        this.listClusterLinks(opts, client);
                    } else if (opts.options.has(opts.deleteOpt())) {
                        this.deleteClusterLink(opts, client);
                    } else if (opts.options.has(opts.describeOpt())) {
                        this.describeClusterLinks(opts, client);
                    } else if (opts.options.has(opts.listTasksOpt())) {
                        this.listClusterLinkTasks(opts, client);
                    }
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof TimeoutException) {
                        ClusterLinkCommand$.throwAdminCommandFailedException$1("Timed out waiting for results", e);
                        break block17;
                    }
                    if (throwable instanceof ClusterAuthorizationException) {
                        ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                        ClusterLinkCommand$.throwAdminCommandFailedException$1(clusterAuthorizationException.getMessage(), e);
                        break block17;
                    }
                    throw e;
                }
                catch (Throwable e) {
                    Predef$.MODULE$.println("Error while issuing request");
                    throw e;
                }
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void createClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        Option<String> clusterId = opts.valueAsOption(opts.clusterIdOpt());
        boolean validateOnly = opts.options.has(opts.validateOnlyOpt());
        boolean excludeValidateLink = opts.options.has(opts.excludeValidateLinkOpt());
        NewClusterLink clusterLink = new NewClusterLink(linkName, (String)clusterId.orNull($less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.MapHasAsJava(this.loadConfigs(opts)).asJava());
        CreateClusterLinksOptions options = new CreateClusterLinksOptions().validateOnly(validateOnly).validateLink(!excludeValidateLink);
        try {
            client.createClusterLinks(CollectionConverters$.MODULE$.SeqHasAsJava(new $colon$colon<Nothing$>((Nothing$)((Object)clusterLink), Nil$.MODULE$)).asJava(), options).all().get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof InvalidClusterLinkException) {
                InvalidClusterLinkException invalidClusterLinkException = (InvalidClusterLinkException)throwable;
                if (!invalidClusterLinkException.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR)) {
                    Predef$.MODULE$.println("Error creating link. Link error: " + invalidClusterLinkException.clusterLinkError() + ". Link error message: " + invalidClusterLinkException.linkErrorMessage());
                }
                throw e;
            }
            throw e;
        }
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println("Cluster link '" + linkName + "' creation successfully " + action + ".");
    }

    private void listClusterLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Option<String> linkName = opts.valueAsOption(opts.linkNameOpt());
        boolean includeTopics = opts.options.has(opts.includeTopicsOpt());
        ListClusterLinksOptions options = new ListClusterLinksOptions().includeTopics(includeTopics);
        linkName.foreach((Function1<String, ListClusterLinksOptions> & Serializable)ln -> options.linkNames(Optional.of(Collections.singletonList(ln))));
        Iterable<ClusterLinkListing> result = CollectionConverters$.MODULE$.CollectionHasAsScala(client.listClusterLinks(options).result().get()).asScala();
        if (result.nonEmpty()) {
            result.foreach((Function1<ClusterLinkListing, Object> & Serializable)cl -> {
                ClusterLinkCommand$.$anonfun$listClusterLinks$2(cl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Option<String> option = linkName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String ln2 = (String)some.value();
            Predef$.MODULE$.println("Link name '" + ln2 + "' not found.");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println("No cluster links found.");
            return;
        }
        throw new MatchError(option);
    }

    private void listClusterLinkTasks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        None$ linkDescriptionsOpt;
        Option option;
        Set<String> set;
        Option<String> linkName = opts.valueAsOption(opts.linkNameOpt());
        Option<String> option2 = linkName;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String ln = (String)some.value();
            set = Collections.singleton(ln);
        } else if (None$.MODULE$.equals(option2)) {
            set = null;
        } else {
            throw new MatchError(option2);
        }
        Set<String> linkNames = set;
        try {
            Collection<ClusterLinkDescription> resp = client.describeClusterLinks(new DescribeClusterLinksOptions().linkNames(linkNames).includeTasks(true)).result().get();
            option = new Some<Iterable<ClusterLinkDescription>>(CollectionConverters$.MODULE$.CollectionHasAsScala(resp).asScala());
        }
        catch (ExecutionException e) {
            this.warn((Function0<String> & Serializable)() -> "Failed to call describe cluster links.", (Function0<Throwable>)(Function0<ExecutionException> & Serializable)() -> e);
            option = None$.MODULE$;
        }
        None$ none$ = linkDescriptionsOpt = option;
        if (none$ instanceof Some) {
            Some some = (Some)((Object)none$);
            Iterable linkDescriptions = (Iterable)some.value();
            if (linkDescriptions.nonEmpty()) {
                linkDescriptions.foreach((Function1<ClusterLinkDescription, Object> & Serializable)cl -> {
                    ClusterLinkCommand$.$anonfun$listClusterLinkTasks$3(cl);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (linkName.isEmpty()) {
                Predef$.MODULE$.println("No cluster links found.");
                return;
            }
            Predef$.MODULE$.println("Link name '" + linkName.get() + "' not found.");
            return;
        }
        if (None$.MODULE$.equals(none$)) {
            Predef$.MODULE$.println("Failed to get the task descriptions.");
            return;
        }
        throw new MatchError(none$);
    }

    private String taskDescriptionStr(ClusterLinkTaskDescription desc) {
        Object object;
        if (desc.errors().isEmpty()) {
            object = "";
        } else {
            String errs = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(desc.errors()).asScala().toSeq().map((Function1<ClusterLinkTaskError, String> & Serializable)taskErr -> "(" + taskErr.errorCode().name() + ") \"" + taskErr.errorMessage() + "\"")).mkString(", ");
            object = "\tErrors: " + errs;
        }
        String taskErrsStr = object;
        return "Task name: " + desc.name() + "\tState: " + desc.state().name() + taskErrsStr;
    }

    private void describeClusterLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Seq<String> linkNames = this.resolveLinks(opts, client);
        Iterable<ClusterLinkDescription> linkDescriptions = CollectionConverters$.MODULE$.CollectionHasAsScala(client.describeClusterLinks(new DescribeClusterLinksOptions().linkNames(CollectionConverters$.MODULE$.IterableHasAsJava(linkNames).asJavaCollection()).includeTopics(true).includeTasks(true)).result().get()).asScala();
        ArrayList<ConfigResource> configResources = new ArrayList<ConfigResource>();
        linkNames.foreach((Function1<String, Object> & Serializable)linkName -> BoxesRunTime.boxToBoolean(configResources.add(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName))));
        Map<ConfigResource, Config> linkConfigs = client.describeConfigs(configResources).all().get();
        if (linkDescriptions.nonEmpty() && !linkConfigs.isEmpty()) {
            linkDescriptions.foreach((Function1<ClusterLinkDescription, Object> & Serializable)cl -> {
                ClusterLinkCommand$.$anonfun$describeClusterLinks$2(linkConfigs, cl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (linkNames.isEmpty()) {
            Predef$.MODULE$.println("No cluster links found.");
            return;
        }
        Predef$.MODULE$.println("Link name '" + linkNames.head() + "' not found.");
    }

    private Seq<String> resolveLinks(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        Option<String> option = opts.valueAsOption(opts.linkNameOpt());
        if (option instanceof Some) {
            Some some = (Some)option;
            String linkName = (String)some.value();
            return new $colon$colon<Nothing$>((Nothing$)((Object)linkName), Nil$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(client.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala().map((Function1<ClusterLinkListing, String> & Serializable)x$4 -> x$4.linkName())).toSeq();
        }
        throw new MatchError(option);
    }

    private void deleteClusterLink(ClusterLinkCommandOptions opts, ConfluentAdmin client) {
        String linkName = opts.valueOf(opts.linkNameOpt());
        boolean validateOnly = opts.options.has(opts.validateOnlyOpt());
        boolean force = opts.options.has(opts.forceOpt());
        DeleteClusterLinksOptions options = new DeleteClusterLinksOptions().validateOnly(validateOnly).force(force);
        client.deleteClusterLinks(CollectionConverters$.MODULE$.SeqHasAsJava(new $colon$colon<Nothing$>((Nothing$)((Object)linkName), Nil$.MODULE$)).asJava(), options).all().get();
        String action = validateOnly ? "validated" : "completed";
        Predef$.MODULE$.println("Cluster link '" + linkName + "' deletion successfully " + action + ".");
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigs$2(String[] config) {
        return config.length == 2;
    }

    private static final void throwAdminCommandFailedException$1(String message, Throwable cause) {
        Predef$.MODULE$.println(message);
        throw new AdminCommandFailedException(message, cause);
    }

    public static final /* synthetic */ void $anonfun$listClusterLinks$2(ClusterLinkListing cl) {
        String localClusterId = cl.localClusterId() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cl.localClusterId())) ? ", local cluster ID: '" + cl.localClusterId() + "'" : "";
        String unavailableLinkReason = cl.clusterLinkError() != null && !cl.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR) ? ", link error: '" + cl.clusterLinkError().name() + "'" : "";
        String unavailableLinkErrMsg = cl.linkErrorMessage() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cl.linkErrorMessage())) ? ", link error message: '" + cl.linkErrorMessage() + "'" : "";
        String linkState = cl.linkState() != null && !cl.linkState().equals((Object)ClusterLinkDescription.LinkState.UNKNOWN) ? ", link state: '" + cl.linkState() + "'" : "";
        Predef$.MODULE$.print("Link name: '" + cl.linkName() + "', link ID: '" + cl.clusterLinkId() + "', remote cluster ID: '" + cl.remoteClusterId() + "'" + localClusterId + ", remote cluster available: '" + cl.available() + "'" + unavailableLinkReason + unavailableLinkErrMsg + linkState);
        if (cl.topics().isPresent()) {
            Predef$.MODULE$.print(", topics: " + cl.topics().get());
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$listClusterLinkTasks$3(ClusterLinkDescription cl) {
        Predef$.MODULE$.println("Link: " + cl.linkName());
        CollectionConverters$.MODULE$.ListHasAsScala(cl.taskDescriptions()).asScala().toSeq().foreach((Function1<ClusterLinkTaskDescription, Object> & Serializable)desc -> {
            Predef$.MODULE$.println(ClusterLinkCommand$.MODULE$.taskDescriptionStr(desc));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ boolean $anonfun$describeClusterLinks$5(ConfigEntry x$3) {
        return !x$3.isDefault();
    }

    public static final /* synthetic */ void $anonfun$describeClusterLinks$2(Map linkConfigs$1, ClusterLinkDescription cl) {
        boolean hasRemoteLinkErrorMessage;
        String localClusterId = cl.localClusterId() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cl.localClusterId())) ? ", local cluster ID: '" + cl.localClusterId() + "'" : "";
        String linkMode = cl.linkMode() != null ? ", link mode: '" + cl.linkMode().toString() + "'" : "";
        String connectionMode = cl.connectionMode() != null ? ", connection mode: '" + cl.connectionMode().toString() + "'" : "";
        String clusterLinkError = cl.clusterLinkError() != null && !cl.clusterLinkError().equals((Object)ClusterLinkError.NO_ERROR) ? ", link error: '" + cl.clusterLinkError().name() + "'" : "";
        String clusterLinkErrorMsg = cl.linkErrorMessage() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cl.linkErrorMessage())) ? ", link error message: '" + cl.linkErrorMessage() + "'" : "";
        String linkState = cl.linkState() != null && !cl.linkState().equals((Object)ClusterLinkDescription.LinkState.UNKNOWN) ? ", link state: '" + cl.linkState().toString() + "'" : "";
        String linkCoordinator = ", link coordinator id: '" + cl.linkCoordinatorId() + "', link coordinator host: '" + cl.linkCoordinatorHost() + "'";
        ClusterLinkDescription.LinkState linkState2 = cl.linkState();
        ClusterLinkDescription.LinkState linkState3 = ClusterLinkDescription.LinkState.UNMANAGED_SOURCE;
        String unmanagedSource = !(linkState2 != null ? !((Object)((Object)linkState2)).equals((Object)linkState3) : linkState3 != null) ? " (Source-side of a destination-initiated cluster link)" : "";
        String taskDescription = !cl.taskDescriptions().isEmpty() ? ", task states: [" + ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(cl.taskDescriptions()).asScala().map((Function1<ClusterLinkTaskDescription, String> & Serializable)desc -> desc.name() + ": " + desc.state().name())).toSeq().mkString(", ") + "]" : "";
        String mirrorStateSummery = !cl.partitionStateCategoryCounts().isEmpty() ? ", mirror partition states: [" + ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(cl.partitionStateCategoryCounts()).asScala().map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ReplicaStatus.MirrorInfo.StateCategory key = (ReplicaStatus.MirrorInfo.StateCategory)((Object)((Object)tuple2._1()));
                Integer value = (Integer)tuple2._2();
                return key + ": " + value;
            }
            throw new MatchError(tuple2);
        })).toSeq().mkString(", ") + "]" : "";
        String linkCoordinatorPartitionId = ", link coordinator partition id: '" + cl.linkCoordinatorPartitionId() + "'";
        Predef$.MODULE$.print("Link name: '" + cl.linkName() + "', link ID: '" + cl.clusterLinkId() + "', remote cluster ID: '" + cl.remoteClusterId() + "'" + localClusterId + linkMode + connectionMode + clusterLinkError + clusterLinkErrorMsg + linkState + linkCoordinator + unmanagedSource + taskDescription + mirrorStateSummery + linkCoordinatorPartitionId);
        if (cl.topics().isPresent()) {
            Predef$.MODULE$.print(", topics: " + cl.topics().get());
        }
        Predef$.MODULE$.println();
        boolean bl = hasRemoteLinkErrorMessage = cl.remoteLinkErrorMessage() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(cl.remoteLinkErrorMessage()));
        if (cl.remoteLinkState() != null && cl.remoteLinkError() != null) {
            ClusterLinkDescription.LinkState linkState4 = cl.remoteLinkState();
            ClusterLinkDescription.LinkState linkState5 = ClusterLinkDescription.LinkState.UNKNOWN;
            if ((linkState4 != null ? !((Object)((Object)linkState4)).equals((Object)linkState5) : linkState5 != null) || hasRemoteLinkErrorMessage) {
                String remoteLinkState = "Remote link state: '" + cl.remoteLinkState() + "'";
                String remoteLinkError = ", remote link error: '" + cl.remoteLinkError().name() + "'";
                String remoteLinkErrorMessage = hasRemoteLinkErrorMessage ? ", remote link error message: '" + cl.remoteLinkErrorMessage() + "'" : "";
                String remoteLinkStateTime = cl.remoteLinkStateTimeMs() > 0L ? ", remote link state update time: " + MODULE$.dateFormatter().format(new Date(cl.remoteLinkStateTimeMs())) : "";
                Predef$.MODULE$.println(remoteLinkState + remoteLinkError + remoteLinkErrorMessage + remoteLinkStateTime);
            }
        }
        if (unmanagedSource.isEmpty()) {
            Config cfg = (Config)linkConfigs$1.get(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, cl.linkName()));
            String configsAsString = cfg == null ? "Null config" : ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(cfg.entries()).asScala().filter((Function1<ConfigEntry, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ClusterLinkCommand$.$anonfun$describeClusterLinks$5(x$3)))).map((Function1<ConfigEntry, String> & Serializable)ce -> ce.name() + "=" + ce.value())).mkString(",");
            Predef$.MODULE$.println("Configs: " + configsAsString);
            Predef$.MODULE$.println();
            return;
        }
    }

    private ClusterLinkCommand$() {
    }
}

