/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kafka.server.DynamicBrokerConfig;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;

public class CatalogTopicConfigUtils {
    public static final Set<String> CATALOG_TOPIC_CONFIGS = Set.of("cleanup.policy", "retention.bytes", "retention.ms", "confluent.key.schema.validation", "confluent.value.schema.validation");
    public static final Set<String> ADDITIONAL_CATALOG_TOPIC_CONFIGS = Set.of("compression.type", "delete.retention.ms", "file.delete.delay.ms", "flush.messages", "flush.ms", "follower.replication.throttled.replicas", "leader.replication.throttled.replicas", "index.interval.bytes", "max.compaction.lag.ms", "max.message.bytes", "message.timestamp.type", "min.cleanable.dirty.ratio", "min.compaction.lag.ms", "min.insync.replicas", "preallocate", "segment.bytes", "segment.index.bytes", "segment.jitter.ms", "segment.ms", "unclean.leader.election.enable");
    public static final Set<String> FULL_CATALOG_TOPIC_CONFIGS = new HashSet<String>(CATALOG_TOPIC_CONFIGS);
    public static final Set<String> BROKER_DEFAULT_CONFIGS_TO_PROPAGATE;
    public static final Set<String> FULL_BROKER_DEFAULT_CONFIGS_TO_PROPAGATE;
    public static final Map<String, String> SERVER_CONFIG_TO_TOPIC_CONFIG;

    public static String serverSynonymIfExist(String topicConfigName) {
        try {
            return ServerTopicConfigSynonyms.serverSynonym(topicConfigName);
        }
        catch (NoSuchElementException e) {
            return topicConfigName;
        }
    }

    public static String configNameToField(String topicConfigName) {
        if (topicConfigName.startsWith("confluent.")) {
            topicConfigName = topicConfigName.substring("confluent.".length());
        }
        return topicConfigName.replaceAll("\\.", "_");
    }

    static {
        FULL_CATALOG_TOPIC_CONFIGS.addAll(ADDITIONAL_CATALOG_TOPIC_CONFIGS);
        SERVER_CONFIG_TO_TOPIC_CONFIG = CATALOG_TOPIC_CONFIGS.stream().collect(Collectors.toMap(CatalogTopicConfigUtils::serverSynonymIfExist, Function.identity()));
        BROKER_DEFAULT_CONFIGS_TO_PROPAGATE = Collections.unmodifiableSet(SERVER_CONFIG_TO_TOPIC_CONFIG.keySet().stream().filter(DynamicBrokerConfig.AllDynamicConfigs()::contains).collect(Collectors.toSet()));
        SERVER_CONFIG_TO_TOPIC_CONFIG.putAll(ADDITIONAL_CATALOG_TOPIC_CONFIGS.stream().collect(Collectors.toMap(CatalogTopicConfigUtils::serverSynonymIfExist, Function.identity())));
        FULL_BROKER_DEFAULT_CONFIGS_TO_PROPAGATE = Collections.unmodifiableSet(SERVER_CONFIG_TO_TOPIC_CONFIG.keySet().stream().filter(DynamicBrokerConfig.AllDynamicConfigs()::contains).collect(Collectors.toSet()));
    }
}

