/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.replication.push.PushManager;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.Executor;
import kafka.availability.BrokerHealthManager;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.PartitionLinkState;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class Partition$
implements Logging {
    public static final Partition$ MODULE$ = new Partition$();
    private static final KafkaMetricsGroup kafka$cluster$Partition$$metricsGroup;
    private static final Histogram firstFetchFromLeaderHist;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        kafka$cluster$Partition$$metricsGroup = new KafkaMetricsGroup(Partition.class);
        firstFetchFromLeaderHist = MODULE$.kafka$cluster$Partition$$metricsGroup().newHistogram("FirstFetchFromLeader");
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Partition$ partition$ = this;
        synchronized (partition$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Option<Executor> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$16() {
        return false;
    }

    public Option<BrokerHealthManager> $lessinit$greater$default$17() {
        return None$.MODULE$;
    }

    public Option<PushManager> $lessinit$greater$default$18() {
        return None$.MODULE$;
    }

    public Option<Uuid> $lessinit$greater$default$19() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$20() {
        return false;
    }

    public KafkaMetricsGroup kafka$cluster$Partition$$metricsGroup() {
        return kafka$cluster$Partition$$metricsGroup;
    }

    public Partition apply(TopicIdPartition topicIdPartition, Time time, ReplicaManager replicaManager, Option<OffsetAndEpoch> metadataOffsetAndEpoch) {
        return this.apply(topicIdPartition.topicPartition(), new Some<Uuid>(topicIdPartition.topicId()), time, replicaManager, metadataOffsetAndEpoch);
    }

    public Partition apply(TopicPartition topicPartition, Option<Uuid> topicId, Time time, ReplicaManager replicaManager, Option<OffsetAndEpoch> metadataOffsetAndEpoch) {
        AlterPartitionListener alterPartitionListener = new AlterPartitionListener(replicaManager){
            private final ReplicaManager replicaManager$1;

            public void markIsrExpand() {
                this.replicaManager$1.isrExpandRate().mark();
            }

            public void markIsrShrink() {
                this.replicaManager$1.isrShrinkRate().mark();
            }

            public void markUnderMinIsrTransition() {
                this.replicaManager$1.underMinIsrTransitionCount().inc();
            }

            public void markFailed() {
                this.replicaManager$1.failedIsrUpdatesRate().mark();
            }

            public void markFollowerStateUpdated(Partition partition) {
                this.replicaManager$1.clusterLinkManager().foreach((Function1<ClusterLinkFactory.LinkManager, Object> & Serializable)manager -> {
                    anon.1.$anonfun$markFollowerStateUpdated$1(partition, manager);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$markFollowerStateUpdated$1(Partition partition$1, ClusterLinkFactory.LinkManager manager) {
                manager.maybeNotifyReadyForFetch(partition$1);
            }
            {
                this.replicaManager$1 = replicaManager$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$markFollowerStateUpdated$1$adapted(kafka.cluster.Partition kafka.server.link.ClusterLinkFactory$LinkManager )}, serializedLambda);
            }
        };
        DelayedOperations delayedOperations = new DelayedOperations(topicId, topicPartition, replicaManager.delayedProducePurgatory(), replicaManager.delayedFetchPurgatory(), replicaManager.delayedDeleteRecordsPurgatory(), replicaManager.delayedShareFetchPurgatory());
        return new Partition(topicPartition, Predef$.MODULE$.Long2long(replicaManager.config().replicaLagTimeMaxMs()), replicaManager.config().interBrokerListenerName(), replicaManager.config().brokerId(), replicaManager.brokerEpochSupplier(), time, alterPartitionListener, delayedOperations, replicaManager.metadataCache(), replicaManager.logManager(), replicaManager.tierReplicaComponents().replicaManagerOpt(), replicaManager.tierReplicaComponents().stateFetcherOpt(), new Some<Executor>(replicaManager.executor()), replicaManager.alterPartitionManager(), metadataOffsetAndEpoch, replicaManager.deferIsrShrinkEnable(), replicaManager.brokerHealthManager(), replicaManager.pushReplicationManager(), topicId, Predef$.MODULE$.Boolean2boolean(replicaManager.config().clusterLinkK1ToK2MigrationEnable()));
    }

    public void removeMetrics(TopicPartition topicPartition) {
        java.util.Map<String, String> tags = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("topic"), topicPartition.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partition"), Integer.toString(topicPartition.partition()))}))).asJava();
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderReplicated", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderMinIsr", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("InSyncReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("ReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("LastStableOffsetLag", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("AtMinIsr", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("CaughtUpReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("DeferredUnderMinIsr", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("IsNotCaughtUp", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("ObserverReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("ObserversInIsrCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("MirrorReplicasCount", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderReplicatedMirror", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("UnderMinIsrMirror", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("AtMinIsrMirror", tags);
        this.kafka$cluster$Partition$$metricsGroup().removeMetric("BlockedOnMirrorSource", tags);
    }

    public Option<ClusterLinkState> clusterLinkState(LeaderAndIsrRequest.PartitionState partitionState) {
        return Option$.MODULE$.apply(partitionState.clusterLinkId()).map((Function1<String, Uuid> & Serializable)id -> CoreUtils$.MODULE$.toKafkaUuidFromJavaUUIDString((String)id)).flatMap((Function1<Uuid, Option> & Serializable)linkId -> Option$.MODULE$.apply(partitionState.clusterLinkTopicState()).map((Function1<String, ClusterLinkState> & Serializable)state -> {
            TopicLinkState topicState;
            TopicLinkState topicLinkState;
            try {
                topicLinkState = TopicLinkState$.MODULE$.fromString((String)state);
            }
            catch (IllegalArgumentException e) {
                MODULE$.error((Function0<String> & Serializable)() -> "Unknown cluster link state " + state + ", disable mirroring", (Function0<Throwable>)(Function0<IllegalArgumentException> & Serializable)() -> e);
                topicLinkState = TopicLinkFailedMirror$.MODULE$;
            }
            TopicLinkState topicLinkState2 = topicState = topicLinkState;
            TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
            boolean failed = !(topicLinkState2 != null ? !topicLinkState2.equals(topicLinkFailedMirror$) : topicLinkFailedMirror$ != null);
            MirrorTopicError mirrorTopicError = MirrorTopicError.forCode(partitionState.mirrorTopicError(), failed);
            PartitionLinkState linkedPartitionState = new PartitionLinkState(partitionState.linkedLeaderEpoch(), failed, mirrorTopicError);
            return new ClusterLinkState((Uuid)linkId, topicState, linkedPartitionState);
        }));
    }

    public boolean isActiveLinkDestination(LeaderAndIsrRequest.PartitionState partitionState) {
        return this.clusterLinkState(partitionState).exists((Function1<ClusterLinkState, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isActiveLinkDestination()));
    }

    public Histogram firstFetchFromLeaderHist() {
        return firstFetchFromLeaderHist;
    }

    private Partition$() {
    }
}

