/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.Objects;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

public class BrokerAdditionDescriptionInternal {
    private final int brokerId;
    private BalancerOperationStatus operationStatus;
    private final long creationTimeMs;
    private final long lastUpdateTimeMs;
    private final Exception exception;
    private final PartitionReassignmentsStatus partitionReassignmentsStatus;

    public BrokerAdditionDescriptionInternal(int brokerId, PartitionReassignmentsStatus partitionReassignmentsStatus, BalancerOperationStatus operationStatus, long creationTimeMs, long lastUpdateTimeMs, Exception e) {
        this.brokerId = brokerId;
        this.partitionReassignmentsStatus = partitionReassignmentsStatus;
        this.operationStatus = operationStatus;
        this.creationTimeMs = creationTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimeMs;
        this.exception = e;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Exception exception() {
        return this.exception;
    }

    public PartitionReassignmentsStatus partitionReassignmentsStatus() {
        return this.partitionReassignmentsStatus;
    }

    public BalancerOperationStatus generalOperationStatus() {
        return this.operationStatus;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public long creationTimeMs() {
        return this.creationTimeMs;
    }

    public String toString() {
        return "BrokerAdditionDescriptionInternal{brokerId=" + this.brokerId + ", exception=" + String.valueOf(this.exception) + ", status=" + String.valueOf((Object)this.partitionReassignmentsStatus) + ", creationTime=" + ClientUtils.utcDateFor(this.creationTimeMs) + ", lastUpdateTime=" + ClientUtils.utcDateFor(this.lastUpdateTimeMs) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerAdditionDescriptionInternal that = (BrokerAdditionDescriptionInternal)o;
        return this.brokerId == that.brokerId;
    }

    public int hashCode() {
        return Objects.hash(this.brokerId);
    }
}

