/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit.manager;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.AbstractAuditManagerTrait;
import kafka.durability.audit.manager.ControllerAuditManager;
import kafka.durability.audit.request.AuditManagerRequest;
import kafka.durability.audit.request.HealthCheckRequest;
import kafka.durability.audit.request.KRaftHWMChangeRequest;
import kafka.durability.audit.request.KRaftLeaderChangeRequest;
import kafka.durability.audit.request.KRaftLogSnapshotGenerationRequest;
import kafka.durability.audit.request.KRaftLogStartOffsetChangeRequest;
import kafka.durability.audit.request.KRaftNodeStartUpRequest;
import kafka.durability.db.kraft.KRaftPartitionState;
import kafka.durability.db.kraft.KRaftPartitionState$;
import kafka.durability.events.DurabilityEventType$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005M4q\u0001C\u0005\u0011\u0002\u0007\u0005!\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0004#\u0001\t\u0007I\u0011A\u0012\t\u000b}\u0002A\u0011\u0001!\t\u000bU\u0003A\u0011\t,\t\u000fq\u0003\u0011\u0013!C\u0001;\")\u0001\u000e\u0001C\u0005S\")A\u000e\u0001C![\nY2i\u001c8ue>dG.\u001a:Bk\u0012LG/T1oC\u001e,'\u000f\u0016:bSRT!AC\u0006\u0002\u000f5\fg.Y4fe*\u0011A\"D\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\u001d=\t!\u0002Z;sC\nLG.\u001b;z\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\t\u0011\"\u0003\u0002\u001d\u0013\tI\u0012IY:ue\u0006\u001cG/Q;eSRl\u0015M\\1hKJ$&/Y5u\u0003\u0019!\u0013N\\5uIQ\tq\u0004\u0005\u0002\u0015A%\u0011\u0011%\u0006\u0002\u0005+:LG/\u0001\rqK:$\u0017N\\4O_\u0012,7\u000b^1siV\u0003XI^3oiN,\u0012\u0001\n\t\u0005K1r\u0013(D\u0001'\u0015\t9\u0003&\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u000b\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002W\u0005!!.\u0019<b\u0013\ticEA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"aL\u001c\u000e\u0003AR!!\r\u001a\u0002\r\r|W.\\8o\u0015\t\u00012G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d1\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002;{5\t1H\u0003\u0002=\u0017\u00059!/Z9vKN$\u0018B\u0001 <\u0005]Y%+\u00194u\u001d>$Wm\u0015;beR,\u0006OU3rk\u0016\u001cH/\u0001\u0006j]&$\u0018.\u00197ju\u0016$2!Q$N!\r!\"\tR\u0005\u0003\u0007V\u0011aa\u00149uS>t\u0007C\u0001\u000eF\u0013\t1\u0015B\u0001\fD_:$(o\u001c7mKJ\fU\u000fZ5u\u001b\u0006t\u0017mZ3s\u0011\u0015A5\u00011\u0001J\u0003\u0019\u0019wN\u001c4jOB\u0011!jS\u0007\u0002\u0017%\u0011Aj\u0003\u0002\u0016\tV\u0014\u0018MY5mSRL\u0018)\u001e3ji\u000e{gNZ5h\u0011\u0015q5\u00011\u0001P\u0003\u0011!\u0018.\\3\u0011\u0005A\u001bV\"A)\u000b\u0005I\u0003\u0014!B;uS2\u001c\u0018B\u0001+R\u0005\u0011!\u0016.\\3\u0002!M$x\u000e]!vI&$X*\u00198bO\u0016\u0014HCA\u0010X\u0011\u001dAF\u0001%AA\u0002e\u000b\u0001b\u001d5vi\u0012|wO\u001c\t\u0003)iK!aW\u000b\u0003\u000f\t{w\u000e\\3b]\u0006Q2\u000f^8q\u0003V$\u0017\u000e^'b]\u0006<WM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\taL\u000b\u0002Z?.\n\u0001\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003KV\t!\"\u00198o_R\fG/[8o\u0013\t9'MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqbZ3u\u0003V$\u0017\u000e^'b]\u0006<WM\u001d\u000b\u0004\t*\\\u0007\"\u0002%\u0007\u0001\u0004I\u0005\"\u0002(\u0007\u0001\u0004y\u0015AE:vE6LG/Q;eSR\u0014V-];fgR$\"a\b8\t\u000b=<\u0001\u0019\u00019\u0002\u0019\u0005,H-\u001b;SKF,Xm\u001d;\u0011\u0005i\n\u0018B\u0001:<\u0005M\tU\u000fZ5u\u001b\u0006t\u0017mZ3s%\u0016\fX/Z:u\u0001")
public interface ControllerAuditManagerTrait
extends AbstractAuditManagerTrait {
    public void kafka$durability$audit$manager$ControllerAuditManagerTrait$_setter_$pendingNodeStartUpEvents_$eq(ConcurrentHashMap<TopicIdPartition, KRaftNodeStartUpRequest> var1);

    public ConcurrentHashMap<TopicIdPartition, KRaftNodeStartUpRequest> pendingNodeStartUpEvents();

    public static /* synthetic */ Option initialize$(ControllerAuditManagerTrait $this, DurabilityAuditConfig config, Time time) {
        return $this.initialize(config, time);
    }

    default public Option<ControllerAuditManager> initialize(DurabilityAuditConfig config, Time time) {
        Option option;
        ControllerAuditManagerTrait controllerAuditManagerTrait = this;
        synchronized (controllerAuditManagerTrait) {
            option = this.liftedTree1$1(config, time);
        }
        return option;
    }

    public static /* synthetic */ void stopAuditManager$(ControllerAuditManagerTrait $this, boolean shutdown) {
        $this.stopAuditManager(shutdown);
    }

    @Override
    default public void stopAuditManager(boolean shutdown) {
        Option$.MODULE$.apply(this.instance()).foreach((Function1<AbstractAuditManager, Object> & Serializable)auditManager -> {
            ControllerAuditManagerTrait.$anonfun$stopAuditManager$1(this, shutdown, auditManager);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean stopAuditManager$default$1$(ControllerAuditManagerTrait $this) {
        return $this.stopAuditManager$default$1();
    }

    @Override
    default public boolean stopAuditManager$default$1() {
        return true;
    }

    private ControllerAuditManager getAuditManager(DurabilityAuditConfig config, Time time) {
        return new ControllerAuditManager(config, time);
    }

    public static /* synthetic */ void submitAuditRequest$(ControllerAuditManagerTrait $this, AuditManagerRequest auditRequest) {
        $this.submitAuditRequest(auditRequest);
    }

    @Override
    default public void submitAuditRequest(AuditManagerRequest auditRequest) {
        block21: {
            try {
                if (auditRequest.topicIdPartition().topicPartition().topic().contains(DurabilityAuditConstants$.MODULE$.TOPIC_NAME())) {
                    return;
                }
                if (this.instance() == null) {
                    AuditManagerRequest auditManagerRequest = auditRequest;
                    if (auditManagerRequest instanceof KRaftNodeStartUpRequest) {
                        KRaftNodeStartUpRequest kRaftNodeStartUpRequest = (KRaftNodeStartUpRequest)auditManagerRequest;
                        this.pendingNodeStartUpEvents().put(auditRequest.topicIdPartition(), kRaftNodeStartUpRequest);
                    }
                    return;
                }
                Enumeration.Value durabilityEventType = null;
                AuditManagerRequest auditManagerRequest = auditRequest;
                if (auditManagerRequest instanceof KRaftNodeStartUpRequest) {
                    durabilityEventType = DurabilityEventType$.MODULE$.KRaftNodeStartUpType();
                } else if (auditManagerRequest instanceof KRaftLeaderChangeRequest) {
                    durabilityEventType = DurabilityEventType$.MODULE$.KRaftLeaderChangeType();
                } else if (auditManagerRequest instanceof KRaftHWMChangeRequest) {
                    durabilityEventType = DurabilityEventType$.MODULE$.KRaftHWMChangeType();
                } else if (auditManagerRequest instanceof KRaftLogSnapshotGenerationRequest) {
                    durabilityEventType = DurabilityEventType$.MODULE$.KRaftLogSnapshotGenerationType();
                } else if (auditManagerRequest instanceof KRaftLogStartOffsetChangeRequest) {
                    durabilityEventType = DurabilityEventType$.MODULE$.KRaftLogStartOffsetChangeType();
                } else if (auditManagerRequest instanceof HealthCheckRequest) {
                    durabilityEventType = DurabilityEventType$.MODULE$.HealthCheckType();
                } else {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("DurabilityRequest: Unknown request {}, ignoring.", (Object)auditRequest);
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    return;
                }
                if (this.instance().config().enableDurabilityAudits() && this.instance().auditEvents().contains(durabilityEventType)) {
                    this.instance().auditRequestsQueue().offer(auditRequest);
                }
            }
            catch (Exception ex) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Fatal exception in processing ControllerAuditManager request " + auditRequest, ex);
                    boxedUnit = BoxedUnit.UNIT;
                    break block21;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static /* synthetic */ boolean $anonfun$initialize$2(ControllerAuditManagerTrait $this, Tuple2 x0$1) {
        KRaftNodeStartUpRequest value;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (value = (KRaftNodeStartUpRequest)tuple2._2()) != null) {
            KRaftNodeStartUpRequest kRaftNodeStartUpRequest = value;
            return $this.instance().auditRequestsQueue().offer(kRaftNodeStartUpRequest);
        }
        throw new MatchError(tuple2);
    }

    private /* synthetic */ Option liftedTree1$1(DurabilityAuditConfig config$1, Time time$1) {
        Option option;
        try {
            if (this.instance() != null) {
                throw new IllegalStateException("initialize called again on an already initialized manager; this is unexpected behavior.");
            }
            this.instance_$eq(this.getAuditManager(config$1, time$1));
            this.instance().db().setKRaftLocalNodeId(config$1.nodeId());
            config$1.kRaftMetadataPartitionsToMonitor().foreach((Function1<TopicIdPartition, Object> & Serializable)metadataTpid -> {
                if (this.instance().db().fetchKRaftPartitionState((TopicIdPartition)metadataTpid).isEmpty()) {
                    KRaftPartitionState newKraftPartitionState = KRaftPartitionState$.MODULE$.apply((TopicIdPartition)metadataTpid, None$.MODULE$, None$.MODULE$, (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$), this.instance().db().kraftQuorumState().epochLeaderIds(), 0L, -1L, false, None$.MODULE$);
                    return this.instance().db().addKRaftPartitionState(newKraftPartitionState);
                }
                return BoxedUnit.UNIT;
            });
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.pendingNodeStartUpEvents()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ControllerAuditManagerTrait.$anonfun$initialize$2(this, x0$1)));
            this.pendingNodeStartUpEvents().clear();
            this.info((Function0<String> & Serializable)() -> "Initialized ControllerAuditManager with config: " + config$1);
            option = new Some<ControllerAuditManager>((ControllerAuditManager)this.instance());
        }
        catch (Exception ex) {
            this.error((Function0<String> & Serializable)() -> "Fatal exception initializing Controller Audit Manager", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> ex);
            option = None$.MODULE$;
        }
        return option;
    }

    public static /* synthetic */ void $anonfun$stopAuditManager$1(ControllerAuditManagerTrait $this, boolean shutdown$1, AbstractAuditManager auditManager) {
        if (shutdown$1) {
            auditManager.shutdown();
            ((ControllerAuditManager)auditManager).cleanup();
            $this.instance_$eq(null);
            return;
        }
    }

    public static void $init$(ControllerAuditManagerTrait $this) {
        $this.kafka$durability$audit$manager$ControllerAuditManagerTrait$_setter_$pendingNodeStartUpEvents_$eq(new ConcurrentHashMap<TopicIdPartition, KRaftNodeStartUpRequest>());
    }
}

