/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\u0012%\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003F\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u000bq\u0003A\u0011A/\t\u000f\u0011\u0004!\u0019!C\u0005K\"1\u0001\u000f\u0001Q\u0001\n\u0019Dq!\u001d\u0001C\u0002\u0013%Q\r\u0003\u0004s\u0001\u0001\u0006IA\u001a\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u0019A\b\u0001)A\u0005k\"9\u0011\u0010\u0001b\u0001\n\u0013!\bB\u0002>\u0001A\u0003%Q\u000fC\u0004|\u0001\t\u0007I\u0011\u0002;\t\rq\u0004\u0001\u0015!\u0003v\u0011\u001di\bA1A\u0005\u0002yDq!!\u0002\u0001A\u0003%q\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u0011\u0005=\u0001A1A\u0005\nQDq!!\u0005\u0001A\u0003%Q\u000f\u0003\u0005&\u0001\t\u0007I\u0011AA\n\u0011!\t)\u0003\u0001Q\u0001\n\u0005U\u0001\"CA\u0014\u0001\t\u0007I\u0011BA\u0015\u0011!\tY\u0004\u0001Q\u0001\n\u0005-\u0002\"CA\u001f\u0001\t\u0007I\u0011BA \u0011!\tI\u0006\u0001Q\u0001\n\u0005\u0005\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!a\"\u0001\t\u0003\tI\tC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \nIB*\u001b8vq\u0012K7o['fiJL7m]\"pY2,7\r^8s\u0015\t)c%A\u0004nKR\u0014\u0018nY:\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\faaY8oM&<\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b'\u0003\u0019\u0019XM\u001d<fe&\u0011ag\r\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005qe>\u001c'k\\8u!\tI\u0004I\u0004\u0002;}A\u00111\bL\u0007\u0002y)\u0011Q\bK\u0001\u0007yI|w\u000e\u001e \n\u0005}b\u0013A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u0017\u0002\tQLW.Z\u000b\u0002\u000bB\u0011a\tU\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0006kRLGn\u001d\u0006\u0003\u0015.\u000baaY8n[>t'BA\u0014M\u0015\tie*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005E;%\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001\\8hO\u0016\u0014X#A+\u0011\u0005YKV\"A,\u000b\u0005as\u0015!B:mMRR\u0017B\u0001.X\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0003_A\u0006\u00147\r\u0005\u0002`\u00015\tA\u0005C\u00031\u000f\u0001\u0007\u0011\u0007C\u00038\u000f\u0001\u0007\u0001\bC\u0003D\u000f\u0001\u0007Q\tC\u0003T\u000f\u0001\u0007Q+\u0001\u0005ti\u0006$\b+\u0019;i+\u00051\u0007CA4o\u001b\u0005A'BA5k\u0003\u00111\u0017\u000e\\3\u000b\u0005-d\u0017a\u00018j_*\tQ.\u0001\u0003kCZ\f\u0017BA8i\u0005\u0011\u0001\u0016\r\u001e5\u0002\u0013M$\u0018\r\u001e)bi\"\u0004\u0013!C7pk:$\b+\u0019;i\u0003)iw.\u001e8u!\u0006$\b\u000eI\u0001\u001a'R\u000bEk\u0018#F-&\u001bUi\u0018(B\u001b\u0016{f)S#M\t~KE)F\u0001v!\tYc/\u0003\u0002xY\t\u0019\u0011J\u001c;\u00025M#\u0016\tV0E\u000bZK5)R0O\u00036+uLR%F\u0019\u0012{\u0016\n\u0012\u0011\u000255{UK\u0014+`\t\u00163\u0016jQ#`\u001d\u0006kUi\u0018$J\u000b2#u,\u0013#\u000275{UK\u0014+`\t\u00163\u0016jQ#`\u001d\u0006kUi\u0018$J\u000b2#u,\u0013#!\u0003]iu*\u0016(U?\u0012K%k\u0018(B\u001b\u0016{f)S#M\t~KE)\u0001\rN\u001fVsEk\u0018#J%~s\u0015)T#`\r&+E\nR0J\t\u0002\nq\u0001Z3wS\u000e,7/F\u0001\u0000!\u0015I\u0014\u0011\u0001\u001d9\u0013\r\t\u0019A\u0011\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u00033fm&\u001cWm\u001d\u0011\u00021\u0019Lg\u000e\u001a#fm&\u001cWMT1nK\u001a\u0013x.\u001c'pO\u0012K'\u000fF\u00029\u0003\u0017Aa!!\u0004\u0015\u0001\u0004A\u0014A\u00027pO\u0012K'/\u0001\u0006nCb4\u0015.\u001a7e\u0013\u0012\f1\"\\1y\r&,G\u000eZ%eAU\u0011\u0011Q\u0003\t\u0006W\u0005]\u00111D\u0005\u0004\u00033a#!B!se\u0006L\b\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005B.\u0001\u0003mC:<\u0017bA!\u0002 \u0005AQ.\u001a;sS\u000e\u001c\b%\u0001\neSJ,7\r\u001e*fiV\u0014hNR5fY\u0012\u001cXCAA\u0016!\u0015\ti#a\u000ev\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012!C5n[V$\u0018M\u00197f\u0015\r\t)\u0004L\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001d\u0003_\u00111aU3u\u0003M!\u0017N]3diJ+G/\u001e:o\r&,G\u000eZ:!\u0003%\u0001(/\u001a<Ti\u0006$X-\u0006\u0002\u0002BA9\u00111IA%q\u0005-SBAA#\u0015\u0011\t9%a\r\u0002\u000f5,H/\u00192mK&!\u00111AA#!\u0015Y\u0013qCA'!\u001dY\u0013qJA*\u0003'J1!!\u0015-\u0005\u0019!V\u000f\u001d7feA\u00191&!\u0016\n\u0007\u0005]CF\u0001\u0003M_:<\u0017A\u00039sKZ\u001cF/\u0019;fA\u0005QQ.\u001a;sS\u000e\u0014\u0016\r^3\u0015\r\u0005}\u0013QMA5!\rY\u0013\u0011M\u0005\u0004\u0003Gb#A\u0002#pk\ndW\r\u0003\u0004\u0002hu\u0001\r\u0001O\u0001\u0007I\u00164\u0018nY3\t\r\u0005-T\u00041\u0001v\u0003\u0015Ig\u000eZ3y\u0003a9W\r\u001e*bo\u0012K7o[*uCR\u001chi\u001c:EKZL7-\u001a\u000b\u0005\u0003c\n\u0019\b\u0005\u0003,\u0003/A\u0004BBA4=\u0001\u0007\u0001(\u0001\tnKR\u0014\u0018nY,j]\u0012|woQ1mGRQ\u0011qLA=\u0003{\ny(a!\t\u000f\u0005mt\u00041\u0001\u0002r\u0005\u0011B-\u001a<jG\u0016\u0014\u0016m\u001e#jg.\u001cF/\u0019;t\u0011\u0019\t9g\ba\u0001q!1\u0011\u0011Q\u0010A\u0002U\f1C\\;nKJ\fGo\u001c:GS\u0016dG-\u00138eKbDa!!\" \u0001\u0004)\u0018!\u00063f]>l\u0017N\\1u_J4\u0015.\u001a7e\u0013:$W\r_\u0001\u0017[\u0016$(/[2XS:$wn^\"bY\u000e\u0014\u0015\u0010V5nKRA\u0011qLAF\u0003\u001b\u000by\tC\u0004\u0002|\u0001\u0002\r!!\u001d\t\r\u0005\u001d\u0004\u00051\u00019\u0011\u0019\t\t\n\ta\u0001k\u0006\tR.\u001a;sS\u000e\u001ch)[3mI&sG-\u001a=\u0002\rU\u001c\u0018M\u00197f)\t\t9\nE\u0002,\u00033K1!a'-\u0005\u001d\u0011un\u001c7fC:\fA#\\1zE\u0016\u0014VmZ5ti\u0016\u0014X*\u001a;sS\u000e\u001cH\u0003BAQ\u0003O\u00032aKAR\u0013\r\t)\u000b\f\u0002\u0005+:LG\u000fC\u0004\u0002*\n\u0002\r!a+\u0002\u0011I,w-[:uef\u0004B!!,\u0002>6\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0003d_J,'bA\u0013\u00026*!\u0011qWA]\u0003\u0019I\u0018-\\7fe*\u0011\u00111X\u0001\u0004G>l\u0017\u0002BA`\u0003_\u0013q\"T3ue&\u001c7OU3hSN$(/\u001f")
public class LinuxDiskMetricsCollector {
    private final KafkaConfig config;
    private final Time time;
    private final Logger logger;
    private final Path statPath;
    private final Path mountPath;
    private final int STAT_DEVICE_NAME_FIELD_ID;
    private final int MOUNT_DEVICE_NAME_FIELD_ID;
    private final int MOUNT_DIR_NAME_FIELD_ID;
    private final Map<String, String> devices;
    private final int maxFieldId;
    private final String[] metrics;
    private final Set<Object> directReturnFields;
    private final scala.collection.mutable.Map<String, Tuple2<Object, Object>[]> prevState;

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    private Path statPath() {
        return this.statPath;
    }

    private Path mountPath() {
        return this.mountPath;
    }

    private int STAT_DEVICE_NAME_FIELD_ID() {
        return this.STAT_DEVICE_NAME_FIELD_ID;
    }

    private int MOUNT_DEVICE_NAME_FIELD_ID() {
        return this.MOUNT_DEVICE_NAME_FIELD_ID;
    }

    private int MOUNT_DIR_NAME_FIELD_ID() {
        return this.MOUNT_DIR_NAME_FIELD_ID;
    }

    public Map<String, String> devices() {
        return this.devices;
    }

    public String findDeviceNameFromLogDir(String logDir) {
        return (String)this.devices().find((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$findDeviceNameFromLogDir$1(logDir, x0$1))).map((Function1<Tuple2, String> & Serializable)x$2 -> (String)x$2._1()).getOrElse((Function0<String> & Serializable)() -> "");
    }

    private int maxFieldId() {
        return this.maxFieldId;
    }

    public String[] metrics() {
        return this.metrics;
    }

    private Set<Object> directReturnFields() {
        return this.directReturnFields;
    }

    private scala.collection.mutable.Map<String, Tuple2<Object, Object>[]> prevState() {
        return this.prevState;
    }

    public synchronized double metricRate(String device, int index) {
        double d;
        if (!this.prevState().contains(device) || index >= this.metrics().length || index < 0) {
            return -1.0;
        }
        try {
            Buffer validLines = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.statPath())).asScala().map((Function1<String, String[]> & Serializable)line -> line.trim().split("\\s+"))).filter((Function1<String[], Object> & Serializable)fields -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$metricRate$2(this, index, device, fields)));
            if (validLines.isEmpty()) {
                return -1.0;
            }
            long now = this.time().milliseconds();
            long value = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(((String[])validLines.head())[index + this.STAT_DEVICE_NAME_FIELD_ID() + 1]));
            if (this.directReturnFields().contains(BoxesRunTime.boxToInteger(index))) {
                return value;
            }
            Tuple2 tuple2 = ((Tuple2[])this.prevState().apply(device))[index];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long prevTime = tuple2._1$mcJ$sp();
            long prevValue = tuple2._2$mcJ$sp();
            Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(prevTime, prevValue);
            long prevTime2 = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
            long prevValue2 = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
            if (prevTime2 == 0L) {
                ((Tuple2[])this.prevState().apply(device))[index] = new Tuple2$mcJJ$sp(now, value);
                return 0.0;
            }
            long windowTime = now - prevTime2;
            if (windowTime <= 0L) {
                return -1.0;
            }
            long windowValue = value - prevValue2;
            ((Tuple2[])this.prevState().apply(device))[index] = new Tuple2$mcJJ$sp(now, value);
            d = (double)windowValue / ((double)windowTime / (double)1000);
        }
        catch (Throwable t) {
            this.logger().warn("Unable to retrieve disk metrics", t);
            d = -1.0;
        }
        return d;
    }

    public String[] getRawDiskStatsForDevice(String device) {
        return (String[])((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.statPath())).asScala().map((Function1<String, String[]> & Serializable)line -> line.trim().split("\\s+"))).filter((Function1<String[], Object> & Serializable)fields -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$getRawDiskStatsForDevice$2(this, device, fields)))).headOption().getOrElse((Function0<String[]> & Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
    }

    public synchronized double metricWindowCalc(String[] deviceRawDiskStats, String device, int numeratorFieldIndex, int denominatorFieldIndex) {
        double d;
        if (!this.prevState().contains(device) || numeratorFieldIndex >= this.metrics().length || numeratorFieldIndex < 0 || denominatorFieldIndex >= this.metrics().length || denominatorFieldIndex < 0 || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(deviceRawDiskStats))) {
            return -1.0;
        }
        try {
            long now = this.time().milliseconds();
            long numeratorField = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(deviceRawDiskStats[numeratorFieldIndex + this.STAT_DEVICE_NAME_FIELD_ID() + 1]));
            Tuple2 tuple2 = ((Tuple2[])this.prevState().apply(device))[numeratorFieldIndex];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long prevNumeratorFieldTime = tuple2._1$mcJ$sp();
            long prevNumeratorField = tuple2._2$mcJ$sp();
            Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(prevNumeratorFieldTime, prevNumeratorField);
            long prevNumeratorFieldTime2 = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
            long prevNumeratorField2 = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
            if (prevNumeratorFieldTime2 == 0L) {
                ((Tuple2[])this.prevState().apply(device))[numeratorFieldIndex] = new Tuple2$mcJJ$sp(now, numeratorField);
            }
            long numeratorWindowValue = numeratorField - prevNumeratorField2;
            ((Tuple2[])this.prevState().apply(device))[numeratorFieldIndex] = new Tuple2$mcJJ$sp(now, numeratorField);
            long denominatorField = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(deviceRawDiskStats[denominatorFieldIndex + this.STAT_DEVICE_NAME_FIELD_ID() + 1]));
            Tuple2 tuple22 = ((Tuple2[])this.prevState().apply(device))[denominatorFieldIndex];
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            long prevDenominatorFieldTime = tuple22._1$mcJ$sp();
            long prevDenominatorField = tuple22._2$mcJ$sp();
            Tuple2$mcJJ$sp tuple2$mcJJ$sp2 = new Tuple2$mcJJ$sp(prevDenominatorFieldTime, prevDenominatorField);
            long prevDenominatorFieldTime2 = ((Tuple2)tuple2$mcJJ$sp2)._1$mcJ$sp();
            long prevDenominatorField2 = ((Tuple2)tuple2$mcJJ$sp2)._2$mcJ$sp();
            if (prevDenominatorFieldTime2 == 0L) {
                ((Tuple2[])this.prevState().apply(device))[denominatorFieldIndex] = new Tuple2$mcJJ$sp(now, denominatorField);
                return 0.0;
            }
            long denominatorWindowValue = denominatorField - prevDenominatorField2;
            ((Tuple2[])this.prevState().apply(device))[denominatorFieldIndex] = new Tuple2$mcJJ$sp(now, denominatorField);
            if (denominatorWindowValue <= 0L) {
                return -1.0;
            }
            d = (double)numeratorWindowValue / (double)denominatorWindowValue;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to retrieve disk metrics", t);
            d = -1.0;
        }
        return d;
    }

    public synchronized double metricWindowCalcByTime(String[] deviceRawDiskStats, String device, int metricsFieldIndex) {
        double d;
        if (!this.prevState().contains(device) || metricsFieldIndex >= this.metrics().length || metricsFieldIndex < 0 || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(deviceRawDiskStats))) {
            return -1.0;
        }
        try {
            long now = this.time().milliseconds();
            long metricsField = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(deviceRawDiskStats[metricsFieldIndex + this.STAT_DEVICE_NAME_FIELD_ID() + 1]));
            Tuple2 tuple2 = ((Tuple2[])this.prevState().apply(device))[metricsFieldIndex];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long prevMetricsFieldTime = tuple2._1$mcJ$sp();
            long prevMetricsField = tuple2._2$mcJ$sp();
            Tuple2$mcJJ$sp tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(prevMetricsFieldTime, prevMetricsField);
            long prevMetricsFieldTime2 = ((Tuple2)tuple2$mcJJ$sp)._1$mcJ$sp();
            long prevMetricsField2 = ((Tuple2)tuple2$mcJJ$sp)._2$mcJ$sp();
            if (prevMetricsFieldTime2 == 0L) {
                ((Tuple2[])this.prevState().apply(device))[metricsFieldIndex] = new Tuple2$mcJJ$sp(now, metricsField);
                return 0.0;
            }
            long metricWindowValue = metricsField - prevMetricsField2;
            ((Tuple2[])this.prevState().apply(device))[metricsFieldIndex] = new Tuple2$mcJJ$sp(now, metricsField);
            long timePassed = now - prevMetricsFieldTime2;
            if (timePassed <= 0L) {
                return -1.0;
            }
            d = (double)metricWindowValue / (double)timePassed;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to retrieve disk metrics", t);
            d = -1.0;
        }
        return d;
    }

    public boolean usable() {
        return this.statPath().toFile().exists() && CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.statPath())).asScala().nonEmpty() && this.mountPath().toFile().exists() && CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.mountPath())).asScala().nonEmpty();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            this.devices().withFilter((Function1<Tuple2<String, String>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$maybeRegisterMetrics$1(check$ifrefutable$2))).foreach((Function1<Tuple2, Object> & Serializable)x$8 -> {
                LinuxDiskMetricsCollector.$anonfun$maybeRegisterMetrics$2(this, registry, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$devices$2(LinuxDiskMetricsCollector $this, String[] fields) {
        return fields.length > RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper($this.MOUNT_DIR_NAME_FIELD_ID()), $this.MOUNT_DEVICE_NAME_FIELD_ID());
    }

    public static final /* synthetic */ boolean $anonfun$devices$3(LinuxDiskMetricsCollector $this, String[] fields) {
        return !fields[$this.MOUNT_DIR_NAME_FIELD_ID()].equals("/") && ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala($this.config.logDirs()).asScala().filter((Function1<String, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.startsWith(fields[$this.MOUNT_DIR_NAME_FIELD_ID()])))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$findDeviceNameFromLogDir$1(String logDir$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String path = (String)tuple2._2();
            return logDir$1.startsWith(path);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$new$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$new$2(LinuxDiskMetricsCollector $this, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            String device = (String)tuple2._1();
            $this.prevState().update(device, (Tuple2<Object, Object>[])Array$.MODULE$.fill($this.metrics().length, (Function0<Tuple2> & Serializable)() -> new Tuple2$mcJJ$sp(0L, 0L), ClassTag$.MODULE$.apply(Tuple2.class)));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$metricRate$2(LinuxDiskMetricsCollector $this, int index$1, String device$1, String[] fields) {
        return fields.length > index$1 + $this.STAT_DEVICE_NAME_FIELD_ID() + 1 && fields[$this.STAT_DEVICE_NAME_FIELD_ID()].equals(device$1);
    }

    public static final /* synthetic */ boolean $anonfun$getRawDiskStatsForDevice$2(LinuxDiskMetricsCollector $this, String device$2, String[] fields) {
        return fields.length >= $this.maxFieldId() + $this.STAT_DEVICE_NAME_FIELD_ID() + 1 && fields[$this.STAT_DEVICE_NAME_FIELD_ID()].equals(device$2);
    }

    private static final void registerGauge$1(String name, LinkedHashMap tags, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName("kafka.server", "KafkaServer", name, tags);
        registry$1.newGauge(metricName, gauge);
    }

    public static final /* synthetic */ boolean $anonfun$maybeRegisterMetrics$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public final /* synthetic */ double kafka$metrics$LinuxDiskMetricsCollector$$$anonfun$maybeRegisterMetrics$4(String device$3, int index$2) {
        return this.metricRate(device$3, index$2);
    }

    public static final /* synthetic */ void $anonfun$maybeRegisterMetrics$2(LinuxDiskMetricsCollector $this, MetricsRegistry registry$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            String device = (String)tuple2._1();
            String dir = (String)tuple2._2();
            ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps($this.metrics())).foreach$mVc$sp(index -> {
                String name = $this.metrics()[index];
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
                tags.put("device", device);
                tags.put("metric", name);
                tags.put("mount-point", dir);
                LinuxDiskMetricsCollector.registerGauge$1("linux-diskstats", tags, new Gauge<Object>($this, device, index){
                    private final /* synthetic */ LinuxDiskMetricsCollector $outer;
                    private final String device$3;
                    private final int index$2;

                    public final double value() {
                        return this.$outer.kafka$metrics$LinuxDiskMetricsCollector$$$anonfun$maybeRegisterMetrics$4(this.device$3, this.index$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.device$3 = device$3;
                        this.index$2 = index$2;
                    }
                }, registry$1);
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public LinuxDiskMetricsCollector(KafkaConfig config, String procRoot, Time time, Logger logger) {
        this.config = config;
        this.time = time;
        this.logger = logger;
        this.statPath = Paths.get(procRoot, "diskstats");
        this.mountPath = Paths.get(procRoot, "mounts");
        this.STAT_DEVICE_NAME_FIELD_ID = 2;
        this.MOUNT_DEVICE_NAME_FIELD_ID = 0;
        this.MOUNT_DIR_NAME_FIELD_ID = 1;
        this.devices = this.usable() ? ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.mountPath())).asScala().map((Function1<String, String[]> & Serializable)line -> line.trim().split("\\s+"))).filter((Function1<String[], Object> & Serializable)fields -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$devices$2(this, fields)))).filter((Function1<String[], Object> & Serializable)fields -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$devices$3(this, fields)))).map((Function1<String[], Tuple2> & Serializable)fields -> new Tuple2<String, String>(((Object)Paths.get(fields[this.MOUNT_DEVICE_NAME_FIELD_ID()], new String[0]).getFileName()).toString(), fields[this.MOUNT_DIR_NAME_FIELD_ID()]))).toMap($less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
        this.maxFieldId = this.usable() ? ((String)CollectionConverters$.MODULE$.ListHasAsScala(Files.readAllLines(this.statPath())).asScala().head()).trim().split("\\s+").length - this.STAT_DEVICE_NAME_FIELD_ID() - 1 : 0;
        this.metrics = (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps(new String[]{"reads-completed", "reads-merged", "sectors-read", "time-spent-reading-ms", "writes-completed", "writes-merged", "sectors-written", "time-spent-writing-ms", "IOs-currently-in-progress", "time-spent-doing-IOs-ms", "weighted-time-spent-doing-IOs-ms", "discards-completed", "discards-merged", "sectors-discarded", "time-spent-discarding-ms", "flush-requests-completed", "time-spent-flushing-ms"}), 0, this.maxFieldId());
        this.directReturnFields = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8}));
        this.prevState = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.devices().withFilter((Function1<Tuple2<String, String>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(LinuxDiskMetricsCollector.$anonfun$new$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$3 -> {
            LinuxDiskMetricsCollector.$anonfun$new$2(this, x$3);
            return BoxedUnit.UNIT;
        });
    }
}

