/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.network.RequestInterceptor;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2A\u0001B\u0003\u0001\u0015!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C!3!)q\u0005\u0001C)Q\tI\u0002K]8ek\u000e,'+Z9vKN$\u0018J\u001c;fe\u000e,\u0007\u000f^8s\u0015\t1q!A\u0004oKR<xN]6\u000b\u0003!\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0017=\u0001\"\u0001D\u0007\u000e\u0003\u0015I!AD\u0003\u0003%I+\u0017/^3ti&sG/\u001a:dKB$xN\u001d\t\u0003!Mi\u0011!\u0005\u0006\u0003%\u001d\tQ!\u001e;jYNL!\u0001F\t\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012a\u0006\t\u0003\u0019\u0001\t1B]3rk\u0016\u001cH\u000fV=qKV\t!\u0004\u0005\u0002\u001cK5\tAD\u0003\u0002\u001e=\u0005A\u0001O]8u_\u000e|GN\u0003\u0002 A\u000511m\\7n_:T!\u0001C\u0011\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0005\u0003Mq\u0011q!\u00119j\u0017\u0016L8/A\u0007sK*,7\r\u001e*fcV,7\u000f\u001e\u000b\u0003S=\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0010\u0002\u0011I,\u0017/^3tiNL!AL\u0016\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007\"\u0002\u0019\u0004\u0001\u0004\t\u0014a\u0001:fcB\u0011!'\u000e\b\u0003\u0019MJ!\u0001N\u0003\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011ag\u000e\u0002\b%\u0016\fX/Z:u\u0015\t!T\u0001")
public class ProduceRequestInterceptor
extends RequestInterceptor {
    @Override
    public ApiKeys requestType() {
        return ApiKeys.PRODUCE;
    }

    @Override
    public AbstractResponse rejectRequest(RequestChannel.Request req) {
        ProduceRequest produceRequest = (ProduceRequest)req.body(ClassTag$.MODULE$.apply(ProduceRequest.class));
        HashMap<TopicIdPartition, ProduceResponse.PartitionResponse> partitionToResponse = new HashMap<TopicIdPartition, ProduceResponse.PartitionResponse>();
        produceRequest.data().topicData().forEach(topic -> topic.partitionData().forEach(partition -> {
            TopicIdPartition topicPartition = new TopicIdPartition(topic.topicId(), partition.index(), topic.name());
            ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(Errors.TOPIC_AUTHORIZATION_FAILED, "Failed to produce to " + topicPartition + " due to misconfigured BYOK encryption.");
            partitionToResponse.put(topicPartition, partitionResponse);
        }));
        return new ProduceResponse(partitionToResponse);
    }
}

