/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.state.SegmentState;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;

public class SegmentStateAndPath {
    private final SegmentState segmentState;
    private final String path;
    private final TopicIdPartition topicIdPartition;

    public SegmentStateAndPath(TopicIdPartition topicIdPartition, SegmentState segmentState) {
        this(topicIdPartition, segmentState, null);
    }

    public SegmentStateAndPath(TopicIdPartition topicIdPartition, SegmentState segmentState, String path) {
        this.topicIdPartition = topicIdPartition;
        this.segmentState = segmentState;
        if (path == null) {
            ObjectMetadata objectMetadata = new ObjectMetadata(topicIdPartition, segmentState);
            this.path = objectMetadata.toFragmentLocation("", FragmentType.SEGMENT).get().objectPath();
        } else {
            this.path = path;
        }
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public SegmentState segmentState() {
        return this.segmentState;
    }

    public String path() {
        return this.path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path).append(" (").append(this.segmentState).append(")");
        return sb.toString();
    }
}

