/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rest;

import kafka.restore.RestoreMetricsManager;
import kafka.restore.db.RestoreDB;
import kafka.restore.rest.RestoreHandler;
import org.apache.kafka.common.utils.Time;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreRestServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreRestServer.class);
    private Server server;
    private final RestoreMetricsManager restoreMetricsManager;
    private final RestoreHandler restoreHandler;
    private final Time time;

    public RestoreRestServer(RestoreMetricsManager restoreMetricsManager, Time time) {
        this.restoreMetricsManager = restoreMetricsManager;
        this.restoreHandler = new RestoreHandler(restoreMetricsManager, this, time);
        this.time = time;
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("RestoreRestServer is already running.");
        }
        int port = 9090;
        LOGGER.info("RestoreRestServer start, Binding to port " + port);
        this.server = new Server(port);
        ContextHandler restoreContext = new ContextHandler("/v1/restore");
        restoreContext.setHandler(this.restoreHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection(new ContextHandler[0]);
        contexts.setHandlers(restoreContext, new DefaultHandler());
        this.server.setHandler(contexts);
        this.server.start();
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running.");
        }
        this.server.stop();
        this.server.join();
        this.server = null;
        LOGGER.info("RestoreRestServer stopped");
    }

    public void setRestoreDB(RestoreDB db) {
        this.restoreHandler.setRestoreDB(db);
    }
}

