/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.metrics.BrokerLoad;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaMetricsReporterConfig;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.QuotaFactory;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.quota.QuotaType;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001\u0002\t\u0012\u0001YA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u00037\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dCQ!\u0014\u0001\u0005\u00029CQa\u0016\u0001\u0005\u0002aCQ\u0001\u0018\u0001\u0005\u0002aCQ!\u0018\u0001\u0005\u0002yCQa\u001d\u0001\u0005\u0002QDQA\u001e\u0001\u0005\u0002]DQ!\u001f\u0001\u0005\u0002iDa!!\u0001\u0001\t\u0013A&AG\"mS\u0016tG/U;pi\u0006lU\r\u001e:jGN\u0014V\r]8si\u0016\u0014(B\u0001\n\u0014\u0003\u0019\u0019XM\u001d<fe*\tA#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0003AM\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"!\n\u0014\u000e\u0003EI!aJ\t\u0003A\rc\u0017.\u001a8u#V|G/Y'fiJL7m\u001d*fa>\u0014H/\u001a:D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\tQ3'D\u0001,\u0015\tACF\u0003\u0002.]\u000511m\\7n_:T!\u0001F\u0018\u000b\u0005A\n\u0014AB1qC\u000eDWMC\u00013\u0003\ry'oZ\u0005\u0003i-\u0012q!T3ue&\u001c7/A\tgKR\u001c\u0007.U;pi\u0006l\u0015M\\1hKJ\u0004\"!J\u001c\n\u0005a\n\"AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\f1\u0003\u001d:pIV\u001cW-U;pi\u0006l\u0015M\\1hKJ\fA#Y2uSZ,G+\u001a8b]R\u001cX*\u00198bO\u0016\u0014\bc\u0001\r=}%\u0011Q(\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015z\u0014B\u0001!\u0012\u0005Q\t5\r^5wKR+g.\u00198ug6\u000bg.Y4fe\u0006\u0019C-\u001f8b[&\u001c\u0017+^8uCJ+\u0007o\u001c:uS:<7\t[1o]\u0016dW*\u00198bO\u0016\u0014\bc\u0001\r=\u0007B\u0011Q\u0005R\u0005\u0003\u000bF\u0011!\u0005R=oC6L7-U;pi\u0006\u0014V\r]8si&twMU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017A\u00032s_.,'\u000fT8bIB\u0019\u0001\u0004\u0010%\u0011\u0005%[U\"\u0001&\u000b\u0005!\u001a\u0012B\u0001'K\u0005)\u0011%o\\6fe2{\u0017\rZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011=\u0003\u0016KU*U+Z\u0003\"!\n\u0001\t\u000b\rB\u0001\u0019\u0001\u0013\t\u000b!B\u0001\u0019A\u0015\t\u000bUB\u0001\u0019\u0001\u001c\t\u000beB\u0001\u0019\u0001\u001c\t\u000biB\u0001\u0019A\u001e\t\u000b\u0005C\u0001\u0019\u0001\"\t\u000b\u0019C\u0001\u0019A$\u0002\t%t\u0017\u000e\u001e\u000b\u00023B\u0011\u0001DW\u0005\u00037f\u0011A!\u00168ji\u0006Y\u0012/^8uCV\u001b\u0018mZ3SKB|'\u000f^5oO\u000e\u000bG\u000e\u001c2bG.\f1dY8o]\u0016\u001cG/[8o\u0003R$X-\u001c9u\u001b\u0016$(/[2OC6,GCA0d!\t\u0001\u0017-D\u0001-\u0013\t\u0011GF\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016DQ\u0001Z\u0006A\u0002\u0015\f!\"\\3ue&\u001cG+Y4t!\u00111W\u000e\u001d9\u000f\u0005\u001d\\\u0007C\u00015\u001a\u001b\u0005I'B\u00016\u0016\u0003\u0019a$o\\8u}%\u0011A.G\u0001\u0007!J,G-\u001a4\n\u00059|'aA'ba*\u0011A.\u0007\t\u0003MFL!A]8\u0003\rM#(/\u001b8h\u0003y\twm\u001a:fO\u0006$XMU3rk\u0016\u001cHOU1uK6+GO]5d\u001d\u0006lW\r\u0006\u0002`k\")A\r\u0004a\u0001K\u0006I2m\u001c8oK\u000e$\u0018n\u001c8D_VtG/T3ue&\u001cg*Y7f)\ty\u0006\u0010C\u0003e\u001b\u0001\u0007Q-A\u0011va\u0012\fG/\u001a\"s_.,'OU3q_J$\u0018N\\4NS:,6/Y4f\u001b>$W\r\u0006\u0002Zw\")AP\u0004a\u0001{\u00069QM\\1cY\u0016$\u0007C\u0001\r\u007f\u0013\ty\u0018DA\u0004C_>dW-\u00198\u00027\t\u0014xn[3s\u0019>\fGMU3q_J$\u0018N\\4DC2d'-Y2l\u0001")
public class ClientQuotaMetricsReporter
implements Logging {
    private final ClientQuotaMetricsReporterConfig config;
    private final Metrics metrics;
    private final ClientQuotaManager fetchQuotaManager;
    private final ClientQuotaManager produceQuotaManager;
    private final Option<ActiveTenantsManager> activeTenantsManager;
    private final Option<DynamicQuotaReportingRequestThread> dynamicQuotaReportingChannelManager;
    private final Option<BrokerLoad> brokerLoad;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ClientQuotaMetricsReporter clientQuotaMetricsReporter = this;
        synchronized (clientQuotaMetricsReporter) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void init() {
        if (this.activeTenantsManager.isDefined()) {
            this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$1 -> {
                x$1.schedule("reporting-quota-usage", () -> this.quotaUsageReportingCallback(), this.config.consumptionReportingIntervalMs());
                return BoxedUnit.UNIT;
            });
        }
        if (this.activeTenantsManager.isDefined()) {
            this.brokerLoad.foreach((Function1<BrokerLoad, Object> & Serializable)x$2 -> {
                x$2.schedule("reporting-quota-usage-for-broker-load-metric", () -> this.brokerLoadReportingCallback(), 0L, this.config.consumptionReportingIntervalMs());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void quotaUsageReportingCallback() {
        if (QuotaFactory.quotaConsumptionReportingEnabled || this.config.elasticCkuEnabled()) {
            Seq<Map<String, String>> activeTenants = this.activeTenantsManager.get().getActiveTenants();
            activeTenants.foreach((Function1<Map, Object> & Serializable)metricTags -> {
                ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$1(this, metricTags);
                return BoxedUnit.UNIT;
            });
            this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$5 -> {
                x$5.wakeup();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public MetricName connectionAttemptMetricName(Map<String, String> metricTags) {
        scala.collection.mutable.Map tagsWithListener = (scala.collection.mutable.Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>("listener", "EXTERNAL")}));
        metricTags.foreach((Function1<Tuple2, scala.collection.mutable.Map> & Serializable)quotaEntity -> (scala.collection.mutable.Map)tagsWithListener.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(quotaEntity._1()), quotaEntity._2())));
        return this.metrics.metricName("listener-tenant-connection-accept-rate", "socket-server-metrics", "Tracking rate of accepting new connections (per second)", CollectionConverters$.MODULE$.MutableMapHasAsJava(tagsWithListener).asJava());
    }

    public MetricName aggregateRequestRateMetricName(Map<String, String> metricTags) {
        return this.metrics.metricName("aggregate-request-rate", "tenant-metrics", "Tracking total request rate (per second)", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    public MetricName connectionCountMetricName(Map<String, String> metricTags) {
        return this.metrics.metricName("authenticated-unthrottled-connection-count", "socket-server-metrics", "Tracking number of active authenticated connections", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    public void updateBrokerReportingMinUsageMode(boolean enabled) {
        this.config.enableBrokerReportMinUsageMode_$eq(enabled);
    }

    private void brokerLoadReportingCallback() {
        if (QuotaFactory.brokerLoadConsumptionReportingEnabled) {
            ClientQuotaManager[] quotaManagers = (ClientQuotaManager[])((Object[])new ClientQuotaManager[]{this.produceQuotaManager, this.fetchQuotaManager});
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(quotaManagers), (Function1<ClientQuotaManager, Object> & Serializable)quotaManager -> {
                ClientQuotaMetricsReporter.$anonfun$brokerLoadReportingCallback$1(this, quotaManager);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$quotaUsageReportingCallback$4(ReportQuotaConsumptionRequestData.EntryData entryData$1, Tuple2 quotaEntity) {
        return entryData$1.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType((String)quotaEntity._1()).setEntityName((String)quotaEntity._2()));
    }

    public static final /* synthetic */ void $anonfun$quotaUsageReportingCallback$2(ClientQuotaMetricsReporter $this, Map metricTags$1, ClientQuotaManager quotaManager) {
        if (quotaManager.hasQuotaLimit(CollectionConverters$.MODULE$.MapHasAsJava(metricTags$1).asJava())) {
            KafkaMetric clientMetric = $this.metrics.metrics().get(quotaManager.clientRateMetricName(metricTags$1));
            if (clientMetric != null) {
                double usage;
                double throttleTimeMs;
                String quotaType = QuotaType.toClientQuotaType(quotaManager.quotaType()).toString();
                $this.debug((Function0<String> & Serializable)() -> "Reporting " + quotaType + " metric for " + metricTags$1.toString());
                ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
                metricTags$1.foreach((Function1<Tuple2, Object> & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean(ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$4(entryData, quotaEntity)));
                KafkaMetric throttlingMetric = $this.metrics.metrics().get(quotaManager.throttleMetricName(metricTags$1));
                double throttledTimeMs = throttlingMetric != null ? (Double.isNaN(throttleTimeMs = BoxesRunTime.unboxToDouble(throttlingMetric.metricValue())) ? 0.0 : throttleTimeMs) : 0.0;
                double adjustedUsage = usage = BoxesRunTime.unboxToDouble(clientMetric.metricValue());
                adjustedUsage = $this.config.enableBrokerReportMinUsageMode() ? package$.MODULE$.max(usage, 102400.0) : package$.MODULE$.max(usage, 0.0);
                entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType(quotaType).setUsage(adjustedUsage).setThrottledTimeMs(throttledTimeMs));
                $this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$3 -> {
                    x$3.addEntryForNode(entryData);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$quotaUsageReportingCallback$11(ReportQuotaConsumptionRequestData.EntryData entryData$2, Tuple2 quotaEntity) {
        return entryData$2.entity().add(new ReportQuotaConsumptionRequestData.EntityData().setEntityType((String)quotaEntity._1()).setEntityName((String)quotaEntity._2()));
    }

    public static final /* synthetic */ void $anonfun$quotaUsageReportingCallback$9(ClientQuotaMetricsReporter $this, Map metricTags$1, Tuple2 mapEntry) {
        KafkaMetric metricToReport = $this.metrics.metrics().get(((Function1)mapEntry._2()).apply(metricTags$1));
        if (metricToReport != null) {
            $this.debug((Function0<String> & Serializable)() -> "Reporting " + mapEntry._1() + " metric for " + metricTags$1.toString());
            ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
            metricTags$1.foreach((Function1<Tuple2, Object> & Serializable)quotaEntity -> BoxesRunTime.boxToBoolean(ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$11(entryData, quotaEntity)));
            double metricUsage = BoxesRunTime.unboxToDouble(metricToReport.metricValue());
            entryData.consumptions().add(new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType((String)mapEntry._1()).setUsage(metricUsage));
            $this.dynamicQuotaReportingChannelManager.foreach((Function1<DynamicQuotaReportingRequestThread, Object> & Serializable)x$4 -> {
                x$4.addEntryForNode(entryData);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$quotaUsageReportingCallback$1(ClientQuotaMetricsReporter $this, Map metricTags2) {
        ClientQuotaManager[] quotaEnforcedMetricsManagers = (ClientQuotaManager[])((Object[])new ClientQuotaManager[]{$this.produceQuotaManager, $this.fetchQuotaManager});
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(quotaEnforcedMetricsManagers), (Function1<ClientQuotaManager, Object> & Serializable)quotaManager -> {
            ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$2($this, metricTags2, quotaManager);
            return BoxedUnit.UNIT;
        });
        if (metricTags2.size() == 1 && metricTags2.contains("tenant") && $this.config.elasticCkuEnabled()) {
            scala.collection.mutable.Map nonQuotaEnforcedMetricsToReport = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
            nonQuotaEnforcedMetricsToReport.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("listener-tenant-connection-accept-rate"), (Function1<Map, MetricName> & Serializable)metricTags -> $this.connectionAttemptMetricName((Map<String, String>)metricTags)));
            nonQuotaEnforcedMetricsToReport.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("aggregate-request-rate"), (Function1<Map, MetricName> & Serializable)metricTags -> $this.aggregateRequestRateMetricName((Map<String, String>)metricTags)));
            nonQuotaEnforcedMetricsToReport.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("authenticated-unthrottled-connection-count"), (Function1<Map, MetricName> & Serializable)metricTags -> $this.connectionCountMetricName((Map<String, String>)metricTags)));
            nonQuotaEnforcedMetricsToReport.foreach((Function1<Tuple2, Object> & Serializable)mapEntry -> {
                ClientQuotaMetricsReporter.$anonfun$quotaUsageReportingCallback$9($this, metricTags2, mapEntry);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$brokerLoadReportingCallback$7(ClientQuotaMetricsReporter $this, ClientQuotaManager quotaManager$1, DoubleRef totalThroughput$1, Map metricTags) {
        if (quotaManager$1.hasQuotaLimit(CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava())) {
            KafkaMetric clientMetric = $this.metrics.metrics().get(quotaManager$1.clientRateMetricName(metricTags));
            if (clientMetric != null) {
                totalThroughput$1.elem += BoxesRunTime.unboxToDouble(clientMetric.metricValue());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$brokerLoadReportingCallback$1(ClientQuotaMetricsReporter $this, ClientQuotaManager quotaManager) {
        Seq activeTenants = (Seq)$this.activeTenantsManager.map((Function1<ActiveTenantsManager, Seq> & Serializable)x$6 -> x$6.getActiveTenants((Function1<Map<String, String>, BoxedUnit>)(Function1<Map, Object> & Serializable)metricTags -> {
            quotaManager.resetQuotaCallback(metricTags);
            return BoxedUnit.UNIT;
        })).getOrElse((Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
        Map groupedQuotaEntities = activeTenants.groupBy((Function1<Map, Map> & Serializable)tags -> CollectionConverters$.MODULE$.MapHasAsScala(quotaManager.quotaCallback().parentQuotaMetricTags(quotaManager.clientQuotaType(), CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava())).asScala().toMap($less$colon$less$.MODULE$.refl()));
        DoubleRef totalThroughput = DoubleRef.create(0.0);
        Seq topLevelQuotaEntities = (Seq)groupedQuotaEntities.getOrElse(Predef$.MODULE$.Map().empty(), (Function0<Seq> & Serializable)() -> (Seq)Seq$.MODULE$.empty());
        topLevelQuotaEntities.foreach((Function1<Map, Object> & Serializable)metricTags -> {
            ClientQuotaMetricsReporter.$anonfun$brokerLoadReportingCallback$7($this, quotaManager, totalThroughput, metricTags);
            return BoxedUnit.UNIT;
        });
        $this.brokerLoad.foreach((Function1<BrokerLoad, Object> & Serializable)x$7 -> {
            x$7.updateReportedUsage(quotaManager.clientQuotaType(), totalThroughput.elem, quotaManager.getBrokerQuotaLimit());
            return BoxedUnit.UNIT;
        });
    }

    public ClientQuotaMetricsReporter(ClientQuotaMetricsReporterConfig config, Metrics metrics, ClientQuotaManager fetchQuotaManager, ClientQuotaManager produceQuotaManager, Option<ActiveTenantsManager> activeTenantsManager, Option<DynamicQuotaReportingRequestThread> dynamicQuotaReportingChannelManager, Option<BrokerLoad> brokerLoad) {
        this.config = config;
        this.metrics = metrics;
        this.fetchQuotaManager = fetchQuotaManager;
        this.produceQuotaManager = produceQuotaManager;
        this.activeTenantsManager = activeTenantsManager;
        this.dynamicQuotaReportingChannelManager = dynamicQuotaReportingChannelManager;
        this.brokerLoad = brokerLoad;
        Logging.$init$(this);
    }
}

