/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkMetrics;
import org.apache.kafka.common.TopicPartition;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00014Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000bQ\u0002A\u0011A\u001b\t\u000bm\u0002A\u0011\u0002\u001f\t\u000b\u0001\u0003A\u0011I!\t\u000b)\u0003A\u0011I&\t\u000bq\u0003A\u0011I/\t\u000by\u0003A\u0011I0\u0003=\rcWo\u001d;fe2Kgn\u001b*fa2L7-Y)v_R\f\u0017\tZ1qi\u0016\u0014(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u0003\u0019\tXo\u001c;bgB\u00111\u0003G\u0005\u000331\u0011\u0011c\u00117vgR,'\u000fT5oWF+x\u000e^1t\u0003\u001diW\r\u001e:jGN\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\u0007\u0002\t1Lgn[\u0005\u0003Au\u0011!c\u00117vgR,'\u000fT5oW6+GO]5dg\u00061A/\u001a8b]R\u00042a\t\u0014)\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB(qi&|g\u000e\u0005\u0002*a9\u0011!F\f\t\u0003W\u0011j\u0011\u0001\f\u0006\u0003[A\ta\u0001\u0010:p_Rt\u0014BA\u0018%\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\"\u0013\u0001\u00037j].t\u0015-\\3\u0002\rqJg.\u001b;?)\u00151t\u0007O\u001d;!\t\u0019\u0002\u0001C\u0003\u0017\u000b\u0001\u0007q\u0003C\u0003\u001b\u000b\u0001\u00071\u0004C\u0003\"\u000b\u0001\u0007!\u0005C\u00034\u000b\u0001\u0007\u0001&A\rdYV\u001cH/\u001a:MS:\\'+\u001a9mS\u000e\f7i\u001c8uKb$H#A\u001f\u0011\u0005Mq\u0014BA \r\u0005a\u0019E.^:uKJd\u0015N\\6UK:\fg\u000e^\"p]R,\u0007\u0010^\u0001\u0007e\u0016\u001cwN\u001d3\u0015\u0005\t+\u0005CA\u0012D\u0013\t!EE\u0001\u0003V]&$\b\"\u0002$\b\u0001\u00049\u0015!\u0002<bYV,\u0007CA\u0012I\u0013\tIEE\u0001\u0003M_:<\u0017aC5t)\"\u0014x\u000e\u001e;mK\u0012$\"\u0001T(\u0011\u0005\rj\u0015B\u0001(%\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u0015\u0005A\u0002E\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002S56\t1K\u0003\u0002U+\u000611m\\7n_:T!a\u0004,\u000b\u0005]C\u0016AB1qC\u000eDWMC\u0001Z\u0003\ry'oZ\u0005\u00037N\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bjgF+x\u000e^1Fq\u000e,W\rZ3e)\u0005a\u0015aE7be.\u0014V\r\u001d7jG\u0006$\u0006N]8ui2,G#\u0001\"")
public class ClusterLinkReplicaQuotaAdapter
extends ReplicaQuota {
    private final ClusterLinkQuotas quotas;
    private final ClusterLinkMetrics metrics;
    private final Option<String> tenant;
    private final String linkName;

    private ClusterLinkTenantContext clusterLinkReplicaContext() {
        return new ClusterLinkTenantContext(this.tenant, this.linkName);
    }

    @Override
    public void record(long value) {
        this.quotas.produce().record(this.clusterLinkReplicaContext(), value);
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        return this.quotas.produce().isThrottled(this.clusterLinkReplicaContext(), topicPartition);
    }

    @Override
    public boolean isQuotaExceeded() {
        return this.quotas.produce().isQuotaExceeded(this.clusterLinkReplicaContext()) || this.quotas.request().isQuotaExceeded(this.clusterLinkReplicaContext());
    }

    @Override
    public void markReplicaThrottle() {
        ClusterLinkTenantContext tenantContext = this.clusterLinkReplicaContext();
        if (this.quotas.request().isQuotaExceeded(tenantContext)) {
            this.metrics.linkFetcherRequestThrottleSensor().record();
        }
        if (this.quotas.produce().isQuotaExceeded(tenantContext)) {
            this.metrics.linkFetcherProduceThrottleSensor().record();
            return;
        }
    }

    public ClusterLinkReplicaQuotaAdapter(ClusterLinkQuotas quotas, ClusterLinkMetrics metrics, Option<String> tenant, String linkName) {
        this.quotas = quotas;
        this.metrics = metrics;
        this.tenant = tenant;
        this.linkName = linkName;
    }
}

