/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.server.ControllerRegistrationManager$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ControllerRegistrationRequest;
import org.apache.kafka.common.requests.ControllerRegistrationResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ControllerRegistration;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMg\u0001\u0002#F\u0001)C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005M\"A!\u000e\u0001BC\u0002\u0013\u00051\u000e\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003m\u0011!A\bA!b\u0001\n\u0003I\b\"CA\u0002\u0001\t\u0005\t\u0015!\u0003{\u0011%\t)\u0001\u0001BC\u0002\u0013\u00051\u000eC\u0005\u0002\b\u0001\u0011\t\u0011)A\u0005Y\"Q\u0011\u0011\u0002\u0001\u0003\u0006\u0004%\t!a\u0003\t\u0015\u0005%\u0002A!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002,\u0001\u0011)\u0019!C\u0001\u0003[A!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\tI\u0004\u0001BC\u0002\u0013\u0005\u00111\b\u0005\u000b\u0003\u0007\u0002!\u0011!Q\u0001\n\u0005u\u0002BCA#\u0001\t\u0015\r\u0011\"\u0001\u0002H!Q\u0011q\n\u0001\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005E\u0003A!b\u0001\n\u0003\t\u0019\u0006\u0003\u0006\u0002h\u0001\u0011\t\u0011)A\u0005\u0003+Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u0002\u0004\u0002!\t%!\"\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\u0006\"I\u0011\u0011\u0012\u0001C\u0002\u0013\u0005\u00111\u0012\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002\u000e\"I\u0011Q\u0013\u0001A\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003?\u0003\u0001\u0019!C\u0001\u0003CC\u0001\"!,\u0001A\u0003&\u0011\u0011\u0014\u0005\n\u0003_\u0003\u0001\u0019!C\u0001\u0003cC\u0011\"!/\u0001\u0001\u0004%\t!a/\t\u0011\u0005}\u0006\u0001)Q\u0005\u0003gC\u0011\"!1\u0001\u0001\u0004%\t!!-\t\u0013\u0005\r\u0007\u00011A\u0005\u0002\u0005\u0015\u0007\u0002CAe\u0001\u0001\u0006K!a-\t\u0013\u0005-\u0007\u00011A\u0005\n\u00055\u0007\"CAq\u0001\u0001\u0007I\u0011BAr\u0011!\t9\u000f\u0001Q!\n\u0005=\u0007\"CAu\u0001\u0001\u0007I\u0011AAL\u0011%\tY\u000f\u0001a\u0001\n\u0003\ti\u000f\u0003\u0005\u0002r\u0002\u0001\u000b\u0015BAM\u0011-\t\u0019\u0010\u0001a\u0001\u0002\u0004%I!!>\t\u0017\u0005u\b\u00011AA\u0002\u0013%\u0011q \u0005\f\u0005\u0007\u0001\u0001\u0019!A!B\u0013\t9\u0010\u0003\u0006\u0003\u0006\u0001\u0011\r\u0011\"\u0001F\u0005\u000fA\u0001B!\u0006\u0001A\u0003%!\u0011\u0002\u0004\u0007\u0005/\u0001AA!\u0007\t\u000f\u0005%D\u0006\"\u0001\u00036!9!1\b\u0017\u0005B\tu\u0002b\u0002B \u0001\u0011\u0005!\u0011\t\u0005\b\u0005\u000f\u0002A\u0011\u0001B\u001f\u0011\u001d\u0011I\u0005\u0001C!\u0005{AqAa\u0013\u0001\t\u0003\u0012iE\u0002\u0004\u0003v\u0001!!q\u000f\u0005\u000b\u0005#\u001a$\u0011!Q\u0001\n\tM\u0003B\u0003B/g\t\u0005\t\u0015!\u0003\u0003`!9\u0011\u0011N\u001a\u0005\u0002\te\u0004b\u0002B\u001eg\u0011\u0005#Q\b\u0005\b\u0005\u0003\u0003A\u0011\u0002B\u001f\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005{1aA!\"\u0001\t\t\u001d\u0005bBA5u\u0011\u0005!q\u0012\u0005\b\u0005'SD\u0011\tBK\u0011\u001d\u00119K\u000fC!\u0005{AqA!+\u0001\t\u0013\u0011i\u0004C\u0004\u0003,\u0002!IA!,\b\u0013\tMV)!A\t\u0002\tUf\u0001\u0003#F\u0003\u0003E\tAa.\t\u000f\u0005%\u0014\t\"\u0001\u0003:\"I!1X!\u0012\u0002\u0013\u0005!Q\u0018\u0002\u001e\u0007>tGO]8mY\u0016\u0014(+Z4jgR\u0014\u0018\r^5p]6\u000bg.Y4fe*\u0011aiR\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003!\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0017F;\u0006C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%AB!osJ+g\r\u0005\u0002S+6\t1K\u0003\u0002U\u000f\u0006)Q\u000f^5mg&\u0011ak\u0015\u0002\b\u0019><w-\u001b8h!\tA&-D\u0001Z\u0015\tQ6,A\u0005qk\nd\u0017n\u001d5fe*\u0011A,X\u0001\u0006S6\fw-\u001a\u0006\u0003\u0011zS!a\u00181\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0017aA8sO&\u00111-\u0017\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018A\u00028pI\u0016LE-F\u0001g!\tau-\u0003\u0002i\u001b\n\u0019\u0011J\u001c;\u0002\u000f9|G-Z%eA\u0005I1\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0002YB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\\'\u000e\u0003AT!!]%\u0002\rq\u0012xn\u001c;?\u0013\t\u0019X*\u0001\u0004Qe\u0016$WMZ\u0005\u0003kZ\u0014aa\u0015;sS:<'BA:N\u0003)\u0019G.^:uKJLE\rI\u0001\u0005i&lW-F\u0001{!\tYx0D\u0001}\u0015\t!VP\u0003\u0002\u007f;\u000611m\\7n_:L1!!\u0001}\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\u0018!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u0005\t2/\u001e9q_J$X\r\u001a$fCR,(/Z:\u0016\u0005\u00055\u0001cBA\b\u00033a\u0017QD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!Q\u000f^5m\u0015\t\t9\"\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003#\u00111!T1q!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012;\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002(\u0005\u0005\"\u0001\u0004,feNLwN\u001c*b]\u001e,\u0017AE:vaB|'\u000f^3e\r\u0016\fG/\u001e:fg\u0002\nQ\"\u001b8dCJt\u0017\r^5p]&#WCAA\u0018!\u0011\t\t$a\r\u000e\u0003uL1!!\u000e~\u0005\u0011)V/\u001b3\u0002\u001d%t7-\u0019:oCRLwN\\%eA\u0005aA.[:uK:,'/\u00138g_V\u0011\u0011Q\b\t\u0005\u0003?\ty$\u0003\u0003\u0002B\u0005\u0005\"\u0001\u0004'jgR,g.\u001a:J]\u001a|\u0017!\u00047jgR,g.\u001a:J]\u001a|\u0007%\u0001\rsKN,g\u000eZ#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a,\"!!\u0013\u0011\u0007m\fY%C\u0002\u0002Nq\u0014!#\u0012=q_:,g\u000e^5bY\n\u000b7m[8gM\u0006I\"/Z:f]\u0012,\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4!\u0003\u001d\u001aWO\u001d:f]RlU\r^1eCR\fWI\\2ssB$xN\u001d$bGR|'/_*vaBd\u0017.\u001a:\u0016\u0005\u0005U\u0003CBA,\u0003;\n\t'\u0004\u0002\u0002Z)!\u00111LA\t\u0003!1WO\\2uS>t\u0017\u0002BA0\u00033\u0012\u0001bU;qa2LWM\u001d\t\u0005\u0003?\t\u0019'\u0003\u0003\u0002f\u0005\u0005\"\u0001G'fi\u0006$\u0017\r^1F]\u000e\u0014\u0018\u0010\u001d;pe\u001a\u000b7\r^8ss\u0006A3-\u001e:sK:$X*\u001a;bI\u0006$\u0018-\u00128def\u0004Ho\u001c:GC\u000e$xN]=TkB\u0004H.[3sA\u00051A(\u001b8jiz\"B#!\u001c\u0002r\u0005M\u0014QOA<\u0003s\nY(! \u0002\u0000\u0005\u0005\u0005cAA8\u00015\tQ\tC\u0003e'\u0001\u0007a\rC\u0003k'\u0001\u0007A\u000eC\u0003y'\u0001\u0007!\u0010\u0003\u0004\u0002\u0006M\u0001\r\u0001\u001c\u0005\b\u0003\u0013\u0019\u0002\u0019AA\u0007\u0011\u001d\tYc\u0005a\u0001\u0003_Aq!!\u000f\u0014\u0001\u0004\ti\u0004C\u0005\u0002FM\u0001\n\u00111\u0001\u0002J!9\u0011\u0011K\nA\u0002\u0005U\u0013\u0001\u00028b[\u0016$\u0012\u0001\\\u0001\nY><\u0007K]3gSb\f!\u0002\\8h\u0007>tG/\u001a=u+\t\ti\tE\u0002|\u0003\u001fK1!!%}\u0005)aunZ\"p]R,\u0007\u0010^\u0001\fY><7i\u001c8uKb$\b%\u0001\u0006qK:$\u0017N\\4Sa\u000e,\"!!'\u0011\u00071\u000bY*C\u0002\u0002\u001e6\u0013qAQ8pY\u0016\fg.\u0001\bqK:$\u0017N\\4Sa\u000e|F%Z9\u0015\t\u0005\r\u0016\u0011\u0016\t\u0004\u0019\u0006\u0015\u0016bAAT\u001b\n!QK\\5u\u0011%\tY+GA\u0001\u0002\u0004\tI*A\u0002yIE\n1\u0002]3oI&twM\u00159dA\u0005q1/^2dKN\u001ch-\u001e7Sa\u000e\u001cXCAAZ!\ra\u0015QW\u0005\u0004\u0003ok%\u0001\u0002'p]\u001e\f!c];dG\u0016\u001c8OZ;m%B\u001c7o\u0018\u0013fcR!\u00111UA_\u0011%\tY\u000bHA\u0001\u0002\u0004\t\u0019,A\btk\u000e\u001cWm]:gk2\u0014\u0006oY:!\u0003)1\u0017-\u001b7fIJ\u00038m]\u0001\u000fM\u0006LG.\u001a3Sa\u000e\u001cx\fJ3r)\u0011\t\u0019+a2\t\u0013\u0005-v$!AA\u0002\u0005M\u0016a\u00034bS2,GM\u00159dg\u0002\nq\"\\3uC\u0012\fG/\u0019,feNLwN\\\u000b\u0003\u0003\u001f\u0004R\u0001TAi\u0003+L1!a5N\u0005\u0019y\u0005\u000f^5p]B!\u0011q[Ao\u001b\t\tINC\u0002\u007f\u00037T!AR/\n\t\u0005}\u0017\u0011\u001c\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006\u0019R.\u001a;bI\u0006$\u0018MV3sg&|gn\u0018\u0013fcR!\u00111UAs\u0011%\tYKIA\u0001\u0002\u0004\ty-\u0001\tnKR\fG-\u0019;b-\u0016\u00148/[8oA\u0005y!/Z4jgR,'/\u001a3J]2{w-A\nsK\u001eL7\u000f^3sK\u0012Le\u000eT8h?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0006=\b\"CAVK\u0005\u0005\t\u0019AAM\u0003A\u0011XmZ5ti\u0016\u0014X\rZ%o\u0019><\u0007%A\b`G\"\fgN\\3m\u001b\u0006t\u0017mZ3s+\t\t9\u0010\u0005\u0003\u0002X\u0006e\u0018\u0002BA~\u00033\u0014aDT8eKR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0002'}\u001b\u0007.\u00198oK2l\u0015M\\1hKJ|F%Z9\u0015\t\u0005\r&\u0011\u0001\u0005\n\u0003WC\u0013\u0011!a\u0001\u0003o\f\u0001cX2iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0015\u00154XM\u001c;Rk\u0016,X-\u0006\u0002\u0003\nA!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010u\u000bQ!];fk\u0016LAAa\u0005\u0003\u000e\ty1*\u00194lC\u00163XM\u001c;Rk\u0016,X-A\u0006fm\u0016tG/U;fk\u0016\u0004#!D*ikR$wn\u001e8Fm\u0016tGoE\u0003-\u00057\u00119\u0003\u0005\u0003\u0003\u001e\t\rRB\u0001B\u0010\u0015\u0011\u0011\t#!\u0006\u0002\t1\fgnZ\u0005\u0005\u0005K\u0011yB\u0001\u0004PE*,7\r\u001e\t\u0005\u0005S\u0011yC\u0004\u0003\u0003\f\t-\u0012\u0002\u0002B\u0017\u0005\u001b\t!\"\u0012<f]R\fV/Z;f\u0013\u0011\u0011\tDa\r\u0003\u000b\u00153XM\u001c;\u000b\t\t5\"Q\u0002\u000b\u0003\u0005o\u00012A!\u000f-\u001b\u0005\u0001\u0011a\u0001:v]R\u0011\u00111U\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003G\u0013\u0019\u0005C\u0004\u0003F=\u0002\r!a>\u0002\u001d\rD\u0017M\u001c8fY6\u000bg.Y4fe\u0006i!-Z4j]NCW\u000f\u001e3po:\fQa\u00197pg\u0016\f\u0001c\u001c8NKR\fG-\u0019;b+B$\u0017\r^3\u0015\u0011\u0005\r&q\nB.\u0005KBqA!\u00153\u0001\u0004\u0011\u0019&A\u0003eK2$\u0018\r\u0005\u0003\u0003V\t]S\"A.\n\u0007\te3LA\u0007NKR\fG-\u0019;b\t\u0016dG/\u0019\u0005\b\u0005;\u0012\u0004\u0019\u0001B0\u0003!qWm^%nC\u001e,\u0007\u0003\u0002B+\u0005CJ1Aa\u0019\\\u00055iU\r^1eCR\f\u0017*\\1hK\"9!q\r\u001aA\u0002\t%\u0014\u0001C7b]&4Wm\u001d;\u0011\t\t-$\u0011O\u0007\u0003\u0005[R1Aa\u001c\\\u0003\u0019aw.\u00193fe&!!1\u000fB7\u00059au.\u00193fe6\u000bg.\u001b4fgR\u00141#T3uC\u0012\fG/Y+qI\u0006$X-\u0012<f]R\u001cRa\rB\u000e\u0005O!bAa\u001f\u0003~\t}\u0004c\u0001B\u001dg!9!\u0011\u000b\u001cA\u0002\tM\u0003b\u0002B/m\u0001\u0007!qL\u0001 [\u0006L(-Z*f]\u0012\u001cuN\u001c;s_2dWM\u001d*fO&\u001cHO]1uS>t\u0017AG:f]\u0012\u001cuN\u001c;s_2dWM\u001d*fO&\u001cHO]1uS>t'a\u0007*fO&\u001cHO]1uS>t'+Z:q_:\u001cX\rS1oI2,'oE\u0003;\u00057\u0011I\t\u0005\u0003\u0002X\n-\u0015\u0002\u0002BG\u00033\u0014!eQ8oiJ|G\u000e\\3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014HC\u0001BI!\r\u0011IDO\u0001\u000b_:\u001cu.\u001c9mKR,G\u0003BAR\u0005/CqA!'=\u0001\u0004\u0011Y*\u0001\u0005sKN\u0004xN\\:f!\u0011\u0011iJa)\u000e\u0005\t}%b\u0001BQ;\u000691\r\\5f]R\u001c\u0018\u0002\u0002BS\u0005?\u0013ab\u00117jK:$(+Z:q_:\u001cX-A\u0005p]RKW.Z8vi\u0006)3o\u00195fIVdWMT3yi\u000e{W.\\;oS\u000e\fG/[8o\u0003\u001a$XM\u001d$bS2,(/Z\u0001\u001ag\u000eDW\rZ;mK:+\u0007\u0010^\"p[6,h.[2bi&|g\u000e\u0006\u0003\u0002$\n=\u0006b\u0002BY\u007f\u0001\u0007\u00111W\u0001\u000bS:$XM\u001d<bY6\u001b\u0018!H\"p]R\u0014x\u000e\u001c7feJ+w-[:ue\u0006$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007\u0005=\u0014i\u0005\u0002B\u0017R\u0011!QW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\t}&\u0006BA%\u0005\u0003\\#Aa1\u0011\t\t\u0015'qZ\u0007\u0003\u0005\u000fTAA!3\u0003L\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001bl\u0015AC1o]>$\u0018\r^5p]&!!\u0011\u001bBd\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ControllerRegistrationManager
implements Logging,
MetadataPublisher {
    private final int nodeId;
    private final String clusterId;
    private final Time time;
    private final String threadNamePrefix;
    private final Map<String, VersionRange> supportedFeatures;
    private final Uuid incarnationId;
    private final ListenerInfo listenerInfo;
    private final ExponentialBackoff resendExponentialBackoff;
    private final Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier;
    private final LogContext logContext;
    private boolean pendingRpc;
    private long successfulRpcs;
    private long failedRpcs;
    private Option<MetadataVersion> kafka$server$ControllerRegistrationManager$$metadataVersion;
    private boolean registeredInLog;
    private NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager;
    private final KafkaEventQueue eventQueue;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ExponentialBackoff $lessinit$greater$default$8() {
        return ControllerRegistrationManager$.MODULE$.$lessinit$greater$default$8();
    }

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerRegistrationManager controllerRegistrationManager = this;
        synchronized (controllerRegistrationManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Time time() {
        return this.time;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Uuid incarnationId() {
        return this.incarnationId;
    }

    public ListenerInfo listenerInfo() {
        return this.listenerInfo;
    }

    public ExponentialBackoff resendExponentialBackoff() {
        return this.resendExponentialBackoff;
    }

    public Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier() {
        return this.currentMetadataEncryptorFactorySupplier;
    }

    @Override
    public String name() {
        return "ControllerRegistrationManager";
    }

    private String logPrefix() {
        StringBuilder builder = new StringBuilder("[ControllerRegistrationManager");
        builder.append(" id=").append(this.nodeId());
        builder.append(" incarnation=").append(this.incarnationId());
        builder.append("] ");
        return builder.toString();
    }

    public LogContext logContext() {
        return this.logContext;
    }

    public boolean pendingRpc() {
        return this.pendingRpc;
    }

    public void pendingRpc_$eq(boolean x$1) {
        this.pendingRpc = x$1;
    }

    public long successfulRpcs() {
        return this.successfulRpcs;
    }

    public void successfulRpcs_$eq(long x$1) {
        this.successfulRpcs = x$1;
    }

    public long failedRpcs() {
        return this.failedRpcs;
    }

    public void failedRpcs_$eq(long x$1) {
        this.failedRpcs = x$1;
    }

    private Option<MetadataVersion> metadataVersion() {
        return this.kafka$server$ControllerRegistrationManager$$metadataVersion;
    }

    public void kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(Option<MetadataVersion> x$1) {
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = x$1;
    }

    public boolean registeredInLog() {
        return this.registeredInLog;
    }

    public void registeredInLog_$eq(boolean x$1) {
        this.registeredInLog = x$1;
    }

    public NodeToControllerChannelManager kafka$server$ControllerRegistrationManager$$_channelManager() {
        return this.kafka$server$ControllerRegistrationManager$$_channelManager;
    }

    public void kafka$server$ControllerRegistrationManager$$_channelManager_$eq(NodeToControllerChannelManager x$1) {
        this.kafka$server$ControllerRegistrationManager$$_channelManager = x$1;
    }

    public KafkaEventQueue eventQueue() {
        return this.eventQueue;
    }

    public void start(NodeToControllerChannelManager channelManager) {
        this.eventQueue().append(() -> {
            try {
                this.info((Function0<String> & Serializable)() -> "initialized channel manager.");
                this.kafka$server$ControllerRegistrationManager$$_channelManager_$eq(channelManager);
                this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
            }
            catch (Throwable t) {
                this.error((Function0<String> & Serializable)() -> "start error", (Function0<Throwable> & Serializable)() -> t);
            }
        });
    }

    public void beginShutdown() {
        this.eventQueue().beginShutdown("beginShutdown");
    }

    @Override
    public void close() {
        this.beginShutdown();
        this.eventQueue().close();
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        if (delta.featuresDelta() != null || delta.clusterDelta() != null && delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger(this.nodeId()))) {
            this.eventQueue().append(new MetadataUpdateEvent(this, delta, newImage));
            return;
        }
    }

    public void kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration() {
        Option<MetadataVersion> metadataVersion = this.metadataVersion();
        if (this.registeredInLog()) {
            this.debug((Function0<String> & Serializable)() -> "maybeSendControllerRegistration: controller is already registered.");
            return;
        }
        if (this.kafka$server$ControllerRegistrationManager$$_channelManager() == null) {
            this.debug((Function0<String> & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the channel manager has not been initialized.");
            return;
        }
        if (metadataVersion.isEmpty()) {
            this.info((Function0<String> & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the metadata.version is not known yet.");
            return;
        }
        if (!metadataVersion.get().isControllerRegistrationSupported()) {
            this.info((Function0<String> & Serializable)() -> "maybeSendControllerRegistration: cannot register yet because the metadata.version is still " + metadataVersion + ", which does not support KIP-919 controller registration.");
            return;
        }
        if (this.pendingRpc()) {
            this.info((Function0<String> & Serializable)() -> "maybeSendControllerRegistration: waiting for the previous RPC to complete.");
            return;
        }
        this.sendControllerRegistration();
    }

    private void sendControllerRegistration() {
        ControllerRegistrationRequestData.FeatureCollection features = new ControllerRegistrationRequestData.FeatureCollection();
        CollectionConverters$.MODULE$.MapHasAsScala(this.supportedFeatures()).asScala().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(ControllerRegistrationManager.$anonfun$sendControllerRegistration$1(features, x0$1)));
        List<ControllerRegistrationRequestData.Encryptor> metadataEncryptors = this.currentMetadataEncryptorFactorySupplier().get().getAllKnownEncryptorIds().stream().map(u -> new ControllerRegistrationRequestData.Encryptor().setEncryptorId((Uuid)u)).toList();
        ControllerRegistrationRequestData data = new ControllerRegistrationRequestData().setControllerId(this.nodeId()).setFeatures(features).setIncarnationId(this.incarnationId()).setListeners(this.listenerInfo().toControllerRegistrationRequest()).setZkMigrationReady(false).setMetadataEncryptors(metadataEncryptors);
        this.info((Function0<String> & Serializable)() -> "sendControllerRegistration: attempting to send " + data);
        this.kafka$server$ControllerRegistrationManager$$_channelManager().sendRequest(new ControllerRegistrationRequest.Builder(data), new RegistrationResponseHandler());
        this.pendingRpc_$eq(true);
    }

    public void kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure() {
        long delayMs = this.resendExponentialBackoff().backoff(this.failedRpcs());
        this.failedRpcs_$eq(this.failedRpcs() + 1L);
        this.scheduleNextCommunication(delayMs);
    }

    private void scheduleNextCommunication(long intervalMs) {
        this.trace((Function0<String> & Serializable)() -> "Scheduling next communication at " + intervalMs + " ms from now.");
        long deadlineNs = this.time().nanoseconds() + TimeUnit.MILLISECONDS.toNanos(intervalMs);
        this.eventQueue().scheduleDeferred("communication", new EventQueue.DeadlineFunction(deadlineNs), () -> this.kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration());
    }

    public static final /* synthetic */ boolean $anonfun$sendControllerRegistration$1(ControllerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            VersionRange range = (VersionRange)tuple2._2();
            return features$1.add(new ControllerRegistrationRequestData.Feature().setName(name).setMinSupportedVersion(range.min()).setMaxSupportedVersion(range.max()));
        }
        throw new MatchError(tuple2);
    }

    public ControllerRegistrationManager(int nodeId, String clusterId, Time time, String threadNamePrefix, Map<String, VersionRange> supportedFeatures, Uuid incarnationId, ListenerInfo listenerInfo, ExponentialBackoff resendExponentialBackoff, Supplier<MetadataEncryptorFactory> currentMetadataEncryptorFactorySupplier) {
        this.nodeId = nodeId;
        this.clusterId = clusterId;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.supportedFeatures = supportedFeatures;
        this.incarnationId = incarnationId;
        this.listenerInfo = listenerInfo;
        this.resendExponentialBackoff = resendExponentialBackoff;
        this.currentMetadataEncryptorFactorySupplier = currentMetadataEncryptorFactorySupplier;
        Logging.$init$(this);
        this.logContext = new LogContext(this.logPrefix());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.pendingRpc = false;
        this.successfulRpcs = 0L;
        this.failedRpcs = 0L;
        this.kafka$server$ControllerRegistrationManager$$metadataVersion = None$.MODULE$;
        this.registeredInLog = false;
        this.eventQueue = new KafkaEventQueue(time, this.logContext(), threadNamePrefix + "registration-manager-", new ShutdownEvent());
    }

    private class MetadataUpdateEvent
    implements EventQueue.Event {
        private final MetadataDelta delta;
        private final MetadataImage newImage;
        public final /* synthetic */ ControllerRegistrationManager $outer;

        @Override
        public String name() {
            return EventQueue.Event.super.name();
        }

        @Override
        public void handleException(Throwable e) {
            EventQueue.Event.super.handleException(e);
        }

        @Override
        public void run() {
            try {
                if (this.delta.featuresDelta() != null) {
                    this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$metadataVersion_$eq(OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.newImage.features().metadataVersion())));
                }
                if (this.delta.clusterDelta() != null && this.delta.clusterDelta().changedControllers().containsKey(BoxesRunTime.boxToInteger(this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()))) {
                    ControllerRegistration curRegistration = this.newImage.cluster().controllers().get(BoxesRunTime.boxToInteger(this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().nodeId()));
                    if (curRegistration == null) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String> & Serializable)() -> "Registration removed for this node ID.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else if (!curRegistration.incarnationId().equals(this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().incarnationId())) {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String> & Serializable)() -> "Found registration for " + curRegistration.incarnationId() + " instead of our incarnation.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(false);
                    } else {
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().info((Function0<String> & Serializable)() -> "Our registration has been persisted to the metadata log.");
                        this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().registeredInLog_$eq(true);
                    }
                }
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().kafka$server$ControllerRegistrationManager$$maybeSendControllerRegistration();
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer().error((Function0<String> & Serializable)() -> "onMetadataUpdate error", (Function0<Throwable> & Serializable)() -> t);
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$MetadataUpdateEvent$$$outer() {
            return this.$outer;
        }

        public MetadataUpdateEvent(ControllerRegistrationManager $outer, MetadataDelta delta, MetadataImage newImage) {
            this.delta = delta;
            this.newImage = newImage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class RegistrationResponseHandler
    implements ControllerRequestCompletionHandler {
        @Override
        public void onComplete(ClientResponse response) {
            Errors errorCode;
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().pendingRpc_$eq(false);
            if (response.authenticationException() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String> & Serializable)() -> "RegistrationResponseHandler: authentication error", (Function0<Throwable>)(Function0<AuthenticationException> & Serializable)() -> response.authenticationException());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.versionMismatch() != null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String> & Serializable)() -> "RegistrationResponseHandler: unsupported API version error", (Function0<Throwable>)(Function0<UnsupportedVersionException> & Serializable)() -> response.versionMismatch());
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (response.responseBody() == null) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String> & Serializable)() -> "RegistrationResponseHandler: unknown error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            if (!(response.responseBody() instanceof ControllerRegistrationResponse)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String> & Serializable)() -> "RegistrationResponseHandler: invalid response type error");
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
                return;
            }
            ControllerRegistrationResponse message = (ControllerRegistrationResponse)response.responseBody();
            Errors errors = errorCode = Errors.forCode(message.data().errorCode());
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs_$eq(this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().successfulRpcs() + 1L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().failedRpcs_$eq(0L);
                this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String> & Serializable)() -> "RegistrationResponseHandler: controller acknowledged ControllerRegistrationRequest.");
                return;
            }
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().info((Function0<String> & Serializable)() -> "RegistrationResponseHandler: controller returned error " + errorCode + " (" + message.data().errorMessage() + ")");
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        @Override
        public void onTimeout() {
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().error((Function0<String> & Serializable)() -> "RegistrationResponseHandler: channel manager timed out before sending the request.");
            this.kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer().kafka$server$ControllerRegistrationManager$$scheduleNextCommunicationAfterFailure();
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$RegistrationResponseHandler$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public RegistrationResponseHandler() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }

    private class ShutdownEvent
    implements EventQueue.Event {
        @Override
        public String name() {
            return EventQueue.Event.super.name();
        }

        @Override
        public void handleException(Throwable e) {
            EventQueue.Event.super.handleException(e);
        }

        @Override
        public void run() {
            try {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().info((Function0<String> & Serializable)() -> "shutting down.");
                if (this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager() != null) {
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager().shutdown();
                    this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().kafka$server$ControllerRegistrationManager$$_channelManager_$eq(null);
                }
            }
            catch (Throwable t) {
                this.kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer().error((Function0<String> & Serializable)() -> "ControllerRegistrationManager.stop error", (Function0<Throwable> & Serializable)() -> t);
            }
        }

        public /* synthetic */ ControllerRegistrationManager kafka$server$ControllerRegistrationManager$ShutdownEvent$$$outer() {
            return ControllerRegistrationManager.this;
        }

        public ShutdownEvent() {
            if (ControllerRegistrationManager.this == null) {
                throw null;
            }
        }
    }
}

