/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.DiskUsageBasedThrottlingConfig;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005efaB\u0014)!\u0003\r\t!\f\u0005\u0006u\u0001!\ta\u000f\u0005\u0006\u007f\u00011\t\u0002\u0011\u0005\b\u001b\u0002\u0001\r\u0011\"\u0003A\u0011\u001d\u0011\u0006\u00011A\u0005\nMCQA\u0016\u0001\u0007\u0012]Cqa\u0018\u0001C\u0002\u0013%\u0001\rC\u0004n\u0001\t\u0007I\u0011\u00028\t\u000bU\u0004A\u0011\u0003<\t\u0011\u0005]\u0001\u00011A\u0005\nYD\u0011\"a\u0007\u0001\u0001\u0004%I!!\b\t\u0015\u0005\u0005\u0002\u00011A\u0005\u0002!\n\u0019\u0003\u0003\u0006\u0002.\u0001\u0001\r\u0011\"\u0001)\u0003_A\u0011\"a\r\u0001\u0001\u0004%I!a\t\t\u0013\u0005]\u0002\u00011A\u0005\n\u0005e\u0002BCA\u001f\u0001\u0001\u0007I\u0011\u0001\u0015\u0002$!Q\u0011\u0011\t\u0001A\u0002\u0013\u0005\u0001&a\u0011\t\u0013\u0005\u001d\u0003A1A\u0005\u0002\u0005%\u0003BBA*\u0001\u0011\u00051\b\u0003\u0004\u0002V\u0001!\ta\u000f\u0005\b\u0003/\u0002A\u0011AA-\u0011!\ty\u0006\u0001C\tQ\u0005\u0005\u0004\u0002CA6\u0001\u0011E\u0001&a\t\t\u0011\u00055\u0004\u0001\"\u0005)\u0003GAq!a\u001c\u0001\t\u0003\t\t\b\u0003\u0004\u0002x\u0001!Ia\u000f\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\ti\b\u0001C\tQmBq!a \u0001\t\u0013\t\t\tC\u0004\u0002\u001a\u0002!\t\u0002\u000b!\b\u000f\u0005m\u0005\u0006#\u0001\u0002\u001e\u001a1q\u0005\u000bE\u0001\u0003?Cq!!) \t\u0003\t\u0019\u000bC\u0005\u0002&~\u0011\r\u0011\"\u0001\u0002(\"A\u0011qV\u0010!\u0002\u0013\tI\u000bC\u0005\u00022~\u0011\r\u0011\"\u0001\u0002(\"A\u00111W\u0010!\u0002\u0013\tI\u000bC\u0005\u00026~\u0011\r\u0011\"\u0001\u0002(\"A\u0011qW\u0010!\u0002\u0013\tIKA\fESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7fe*\u0011\u0011FK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b9\u001b\u00051$BA\u001c+\u0003\u0015)H/\u001b7t\u0013\tIdGA\u0004M_\u001e<\u0017N\\4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0004CA\u0018>\u0013\tq\u0004G\u0001\u0003V]&$\u0018\u0001\u00063jg.$\u0006N]8ui2LgnZ\"p]\u001aLw-F\u0001B!\t\u00115*D\u0001D\u0015\t!U)\u0001\u0004d_:4\u0017n\u001a\u0006\u0003S\u0019S!aK$\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u000e\u0013a\u0004R5tWV\u001b\u0018mZ3CCN,G\r\u00165s_R$H.\u001b8h\u0007>tg-[4\u00027\u0011Lh.Y7jG\u0012K7o\u001b+ie>$H\u000f\\5oO\u000e{gNZ5hQ\t\u0019q\n\u0005\u00020!&\u0011\u0011\u000b\r\u0002\tm>d\u0017\r^5mK\u0006yB-\u001f8b[&\u001cG)[:l)\"\u0014x\u000e\u001e;mS:<7i\u001c8gS\u001e|F%Z9\u0015\u0005q\"\u0006bB+\u0005\u0003\u0003\u0005\r!Q\u0001\u0004q\u0012\n\u0014\u0001\u0002;j[\u0016,\u0012\u0001\u0017\t\u00033vk\u0011A\u0017\u0006\u0003omS!\u0001\u0018$\u0002\r\r|W.\\8o\u0013\tq&L\u0001\u0003US6,\u0017a\u00047bgR\u001c\u0005.Z2lK\u0012$\u0016.\\3\u0016\u0003\u0005\u0004\"AY6\u000e\u0003\rT!\u0001Z3\u0002\r\u0005$x.\\5d\u0015\t1w-\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001[5\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0006!!.\u0019<b\u0013\ta7M\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\fA\"\\3ue&\u001c7o\u0012:pkB,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e\u0016\u000bq!\\3ue&\u001c7/\u0003\u0002uc\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b\u001d,GOR5mKN#xN]3t+\u00059\b#\u0002=\u0002\u0002\u0005\u001daBA=\u007f\u001d\tQX0D\u0001|\u0015\taH&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011q\u0010M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019!!\u0002\u0003\u0007M+\u0017O\u0003\u0002\u0000aA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001\u00024jY\u0016T1!!\u0005j\u0003\rq\u0017n\\\u0005\u0005\u0003+\tYAA\u0005GS2,7\u000b^8sK\u0006Qa-\u001b7f'R|'/Z:)\u0005%y\u0015A\u00044jY\u0016\u001cFo\u001c:fg~#S-\u001d\u000b\u0004y\u0005}\u0001bB+\u000b\u0003\u0003\u0005\ra^\u0001\u0015aJ|G-^2feRC'o\u001c;uY\u0016\u0014\u0016\r^3\u0016\u0005\u0005\u0015\u0002cA\u0018\u0002(%\u0019\u0011\u0011\u0006\u0019\u0003\t1{gn\u001a\u0015\u0003\u0017=\u000b\u0001\u0004\u001d:pIV\u001cWM\u001d+ie>$H\u000f\\3SCR,w\fJ3r)\ra\u0014\u0011\u0007\u0005\t+2\t\t\u00111\u0001\u0002&\u000592\r\\;ti\u0016\u0014H*\u001b8l)\"\u0014x\u000e\u001e;mKJ\u000bG/\u001a\u0015\u0003\u001b=\u000b1d\u00197vgR,'\u000fT5oWRC'o\u001c;uY\u0016\u0014\u0016\r^3`I\u0015\fHc\u0001\u001f\u0002<!AQKDA\u0001\u0002\u0004\t)#\u0001\u000bg_2dwn^3s)\"\u0014x\u000e\u001e;mKJ\u000bG/\u001a\u0015\u0003\u001f=\u000b\u0001DZ8mY><XM\u001d+ie>$H\u000f\\3SCR,w\fJ3r)\ra\u0014Q\t\u0005\t+B\t\t\u00111\u0001\u0002&\u0005yA.[:uK:,'/T1oC\u001e,'/\u0006\u0002\u0002LA!\u0011QJA(\u001b\u0005A\u0013bAA)Q\tYB)[:l)\"\u0014x\u000e\u001e;mK2K7\u000f^3oKJl\u0015M\\1hKJ\f!d\u0019:fCR,G)[:l)\"\u0014x\u000e\u001e;mKJlU\r\u001e:jGN\f!D]3n_Z,G)[:l)\"\u0014x\u000e\u001e;mKJlU\r\u001e:jGN\f!$\u001e9eCR,G)[:l)\"\u0014x\u000e\u001e;mS:<7i\u001c8gS\u001e$2\u0001PA.\u0011\u0019\ti\u0006\u0006a\u0001\u0003\u0006Ia.Z<D_:4\u0017nZ\u0001\u001eI&\u001c8\u000e\u00165s_R$H.\u001b8h\u000b:\f'\r\\3e\u0013:\u001cuN\u001c4jOR!\u00111MA5!\ry\u0013QM\u0005\u0004\u0003O\u0002$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\tV\u0001\r!Q\u0001\u0012[&tG)[:l)>$\u0018\r\u001c\"zi\u0016\u001c\u0018AE7j]\u0012K7o[+tC\ndWMQ=uKN\fad\u00195fG.\fe\u000eZ+qI\u0006$X-U;pi\u0006|e\u000eR5tWV\u001b\u0018mZ3\u0015\u0007q\n\u0019\bC\u0004\u0002va\u0001\r!!\n\u0002\rQLW.Z't\u0003e!wn\u00115fG.\fe\u000eZ+qI\u0006$X\r\u00165s_R$H.Z:\u0002%5\f\u0017PY3TKR4\u0015\u000e\\3Ti>\u0014Xm\u001d\u000b\u0003\u0003G\nQ\"\u001b8jiRC'o\u001c;uY\u0016\u0014\u0018aD;qI\u0006$X\rT5ti\u0016tWM]:\u0015\u0007q\n\u0019\tC\u0004\u0002\u0006r\u0001\r!a\"\u0002\u001bE,x\u000e^1MS6LGo\u00149u!\u0019\tI)a#\u0002\u00106\tq-C\u0002\u0002\u000e\u001e\u0014\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS5\u0002\t1\fgnZ\u0005\u0005\u0003S\t\u0019*\u0001\u0010hKR\u001cUO\u001d:f]R$\u0015n]6UQJ|G\u000f\u001e7j]\u001e\u001cuN\u001c4jO\u00069B)[:l+N\fw-\u001a\"bg\u0016$G\u000b\u001b:piRdWM\u001d\t\u0004\u0003\u001bz2\u0003B\u0010/\u0003\u0017\na\u0001P5oSRtDCAAO\u0003y\u0001&o\u001c3vG\u0016\u0014H)[:l)\"\u0014x\u000e\u001e;mK6+GO]5d\u001d\u0006lW-\u0006\u0002\u0002*B!\u0011\u0011SAV\u0013\u0011\ti+a%\u0003\rM#(/\u001b8h\u0003}\u0001&o\u001c3vG\u0016\u0014H)[:l)\"\u0014x\u000e\u001e;mK6+GO]5d\u001d\u0006lW\rI\u0001&%\u0016\u0004H.[2bi&|gNR8mY><XM\u001d+ie>$H\u000f\\3NKR\u0014\u0018n\u0019(b[\u0016\faEU3qY&\u001c\u0017\r^5p]\u001a{G\u000e\\8xKJ$\u0006N]8ui2,W*\u001a;sS\u000et\u0015-\\3!\u0003\u0005\u001aE.^:uKJd\u0015N\\6ESN\\G\u000b\u001b:piRdW-T3ue&\u001cg*Y7f\u0003\t\u001aE.^:uKJd\u0015N\\6ESN\\G\u000b\u001b:piRdW-T3ue&\u001cg*Y7fA\u0001")
public interface DiskUsageBasedThrottler
extends Logging {
    public static String ClusterLinkDiskThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName();
    }

    public static String ReplicationFollowerThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName();
    }

    public static String ProducerDiskThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName();
    }

    public void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(AtomicLong var1);

    public void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$metricsGroup_$eq(KafkaMetricsGroup var1);

    public void kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskThrottleListenerManager var1);

    public DiskUsageBasedThrottlingConfig diskThrottlingConfig();

    public DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig();

    public void kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(DiskUsageBasedThrottlingConfig var1);

    public Time time();

    public AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime();

    public KafkaMetricsGroup kafka$server$DiskUsageBasedThrottler$$metricsGroup();

    public static /* synthetic */ Seq getFileStores$(DiskUsageBasedThrottler $this) {
        return $this.getFileStores();
    }

    default public Seq<FileStore> getFileStores() {
        Seq seq;
        try {
            seq = (Seq)CollectionConverters$.MODULE$.ListHasAsScala(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs).asScala().toSeq().map((Function1<String, FileStore> & Serializable)logDir -> Files.getFileStore(Paths.get(logDir, new String[0])));
        }
        catch (Exception e) {
            this.debug((Function0<String> & Serializable)() -> "Couldn't create file-stores for logDirs: " + $this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs + ", however, this is normal at startup with non-existent log directories", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return seq;
    }

    public Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores();

    public void kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(Seq<FileStore> var1);

    public long producerThrottleRate();

    public void producerThrottleRate_$eq(long var1);

    public long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate();

    public void kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(long var1);

    public long followerThrottleRate();

    public void followerThrottleRate_$eq(long var1);

    public DiskThrottleListenerManager listenerManager();

    public static /* synthetic */ void createDiskThrottlerMetrics$(DiskUsageBasedThrottler $this) {
        $this.createDiskThrottlerMetrics();
    }

    default public void createDiskThrottlerMetrics() {
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().newGauge(DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName(), () -> BoxesRunTime.boxToLong(this.producerThrottleRate()));
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().newGauge(DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName(), () -> BoxesRunTime.boxToLong(this.followerThrottleRate()));
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().newGauge(DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName(), () -> BoxesRunTime.boxToLong(this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate()));
    }

    public static /* synthetic */ void removeDiskThrottlerMetrics$(DiskUsageBasedThrottler $this) {
        $this.removeDiskThrottlerMetrics();
    }

    default public void removeDiskThrottlerMetrics() {
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().removeMetric(DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName());
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().removeMetric(DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName());
        this.kafka$server$DiskUsageBasedThrottler$$metricsGroup().removeMetric(DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName());
    }

    public static /* synthetic */ void updateDiskThrottlingConfig$(DiskUsageBasedThrottler $this, DiskUsageBasedThrottlingConfig newConfig) {
        $this.updateDiskThrottlingConfig(newConfig);
    }

    default public void updateDiskThrottlingConfig(DiskUsageBasedThrottlingConfig newConfig) {
        if (this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig()) && !this.diskThrottlingEnabledInConfig(newConfig)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Disabling disk based throttling based on new config: {}", (Object)newConfig);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
            this.updateListeners(Optional.empty());
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Updating disk throttling config from: {} to {}", new Object[]{this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig(), newConfig});
            v1 = BoxedUnit.UNIT;
        } else {
            v1 = BoxedUnit.UNIT;
        }
        this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(newConfig);
        this.checkAndUpdateQuotaOnDiskUsage(this.time().milliseconds());
    }

    public static /* synthetic */ boolean diskThrottlingEnabledInConfig$(DiskUsageBasedThrottler $this, DiskUsageBasedThrottlingConfig config) {
        return $this.diskThrottlingEnabledInConfig(config);
    }

    default public boolean diskThrottlingEnabledInConfig(DiskUsageBasedThrottlingConfig config) {
        return config.enableDiskBasedThrottling && CollectionConverters$.MODULE$.ListHasAsScala(config.logDirs).asScala().nonEmpty();
    }

    public static /* synthetic */ long minDiskTotalBytes$(DiskUsageBasedThrottler $this) {
        return $this.minDiskTotalBytes();
    }

    default public long minDiskTotalBytes() {
        return BoxesRunTime.unboxToLong(((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottler$$fileStores().map((Function1<FileStore, Object> & Serializable)x$1 -> BoxesRunTime.boxToLong(x$1.getTotalSpace()))).min(Ordering.Long$.MODULE$));
    }

    public static /* synthetic */ long minDiskUsableBytes$(DiskUsageBasedThrottler $this) {
        return $this.minDiskUsableBytes();
    }

    default public long minDiskUsableBytes() {
        return BoxesRunTime.unboxToLong(((IterableOnceOps)this.kafka$server$DiskUsageBasedThrottler$$fileStores().map((Function1<FileStore, Object> & Serializable)x$2 -> BoxesRunTime.boxToLong(x$2.getUsableSpace()))).min(Ordering.Long$.MODULE$));
    }

    public static /* synthetic */ void checkAndUpdateQuotaOnDiskUsage$(DiskUsageBasedThrottler $this, long timeMs) {
        $this.checkAndUpdateQuotaOnDiskUsage(timeMs);
    }

    default public void checkAndUpdateQuotaOnDiskUsage(long timeMs) {
        if (!this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig())) {
            return;
        }
        long lastCheck = this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().get();
        if (lastCheck + this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().diskCheckFrequencyMs > timeMs) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Current time: {} still early for next check at: {}", new Object[]{BoxesRunTime.boxToLong(timeMs), BoxesRunTime.boxToLong(lastCheck + this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().diskCheckFrequencyMs)});
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
            return;
        }
        if (this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().compareAndSet(lastCheck, timeMs)) {
            this.doCheckAndUpdateThrottles();
            return;
        }
    }

    private void doCheckAndUpdateThrottles() {
        if (this.kafka$server$DiskUsageBasedThrottler$$fileStores().nonEmpty() || this.maybeSetFileStores()) {
            if (this.minDiskUsableBytes() < this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Disk with the lowest free space: {}B available < threshold: {}B, will apply throttle!", new Object[]{BoxesRunTime.boxToLong(this.minDiskUsableBytes()), BoxesRunTime.boxToLong(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes)});
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                this.updateListeners(Optional.of(Predef$.MODULE$.long2Long(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().throttledProduceThroughput)));
                return;
            }
            if (this.listenerManager().anyListenerIsThrottled() && (double)this.minDiskUsableBytes() >= this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytesRecoveryFactor * (double)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Disk with the lowest free space: {}B available >= {} x threshold: {}B, will remove low disk space throttle", BoxesRunTime.boxToLong(this.minDiskUsableBytes()), BoxesRunTime.boxToDouble(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytesRecoveryFactor), BoxesRunTime.boxToLong(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes));
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                this.updateListeners(Optional.empty());
                return;
            }
            return;
        }
    }

    private boolean maybeSetFileStores() {
        Seq<FileStore> seq = this.getFileStores();
        if (seq.nonEmpty()) {
            this.kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(seq);
            this.debug((Function0<String> & Serializable)() -> "Created file-stores for logDirs: " + $this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs);
            return true;
        }
        return false;
    }

    public static /* synthetic */ void initThrottler$(DiskUsageBasedThrottler $this) {
        $this.initThrottler();
    }

    default public void initThrottler() {
        this.createDiskThrottlerMetrics();
        if (this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig())) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Initializing low disk space throttle with config: {}", (Object)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig());
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
            this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().set(this.time().milliseconds());
            this.doCheckAndUpdateThrottles();
            return;
        }
    }

    private void updateListeners(Optional<Long> quotaLimitOpt) {
        this.listenerManager().getListeners().foreach((Function1<DiskUsageBasedThrottleListener, Object> & Serializable)listener -> {
            DiskUsageBasedThrottler.$anonfun$updateListeners$1(this, quotaLimitOpt, listener);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig$(DiskUsageBasedThrottler $this) {
        return $this.getCurrentDiskThrottlingConfig();
    }

    default public DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig() {
        return this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig();
    }

    public static /* synthetic */ void $anonfun$updateListeners$1(DiskUsageBasedThrottler $this, Optional quotaLimitOpt$1, DiskUsageBasedThrottleListener listener) {
        Optional<Long> optional = listener.lastSignalledQuotaOptRef().getAndSet(quotaLimitOpt$1);
        Optional optional2 = quotaLimitOpt$1;
        if (optional == null ? optional2 != null : !((Object)optional).equals(optional2)) {
            if (quotaLimitOpt$1.isPresent()) {
                Long quotaLimit = (Long)quotaLimitOpt$1.get();
                QuotaType quotaType = listener.quotaType();
                if (((Object)((Object)QuotaType.PRODUCE)).equals((Object)quotaType)) {
                    listener.handleDiskSpaceLow(Predef$.MODULE$.Long2long(quotaLimit));
                    $this.producerThrottleRate_$eq(Predef$.MODULE$.Long2long(quotaLimit));
                    return;
                }
                if (((Object)((Object)QuotaType.CLUSTER_LINK_REPLICATION)).equals((Object)quotaType)) {
                    listener.handleDiskSpaceLow(Predef$.MODULE$.Long2long(quotaLimit));
                    $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(Predef$.MODULE$.Long2long(quotaLimit));
                    return;
                }
                if (((Object)((Object)QuotaType.FOLLOWER_REPLICATION)).equals((Object)quotaType)) {
                    int multiplier = $this.diskThrottlingConfig().clusterLinkEnabled ? 4 : 2;
                    listener.handleDiskSpaceLow((long)multiplier * Predef$.MODULE$.Long2long(quotaLimit));
                    $this.followerThrottleRate_$eq((long)multiplier * Predef$.MODULE$.Long2long(quotaLimit));
                    return;
                }
                return;
            }
            listener.handleDiskSpaceRecovered();
            QuotaType quotaType = listener.quotaType();
            if (((Object)((Object)QuotaType.PRODUCE)).equals((Object)quotaType)) {
                $this.producerThrottleRate_$eq(0L);
                return;
            }
            if (((Object)((Object)QuotaType.FOLLOWER_REPLICATION)).equals((Object)quotaType)) {
                $this.followerThrottleRate_$eq(0L);
                return;
            }
            if (((Object)((Object)QuotaType.CLUSTER_LINK_REPLICATION)).equals((Object)quotaType)) {
                $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(0L);
                return;
            }
            return;
        }
    }

    public static void $init$(DiskUsageBasedThrottler $this) {
        $this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq($this.diskThrottlingConfig());
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(new AtomicLong($this.time().milliseconds()));
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$metricsGroup_$eq(new KafkaMetricsGroup($this.getClass()));
        $this.kafka$server$DiskUsageBasedThrottler$$fileStores_$eq($this.getFileStores());
        $this.producerThrottleRate_$eq(0L);
        $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(0L);
        $this.followerThrottleRate_$eq(0L);
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskUsageBasedThrottler$.MODULE$);
    }
}

