/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicQuotaConfig$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Set;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u001d<Q\u0001D\u0007\t\u0002I1Q\u0001F\u0007\t\u0002UAQ\u0001H\u0001\u0005\u0002uAqAH\u0001C\u0002\u0013\u0005q\u0004\u0003\u0004/\u0003\u0001\u0006I\u0001\t\u0004\u0005)5\u0001q\u0006\u0003\u00054\u000b\t\u0005\t\u0015!\u00035\u0011!YTA!A!\u0002\u0013a\u0004\"\u0002\u000f\u0006\t\u00039\u0005\"B&\u0006\t\u0003b\u0005\"\u0002-\u0006\t\u0003J\u0006\"\u00022\u0006\t\u0003\u001a\u0017A\u0005#z]\u0006l\u0017nY)v_R\f7i\u001c8gS\u001eT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001\u0001\t\u0003'\u0005i\u0011!\u0004\u0002\u0013\tft\u0017-\\5d#V|G/Y\"p]\u001aLwm\u0005\u0002\u0002-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\n\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0003Ga\t!bY8mY\u0016\u001cG/[8o\u0013\t)#EA\u0002TKR\u0004\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgnZ\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tAM\u0019QA\u0006\u0019\u0011\u0005M\t\u0014B\u0001\u001a\u000e\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u0006i\u0011/^8uC6\u000bg.Y4feN\u0004\"!\u000e\u001d\u000f\u0005M1\u0014BA\u001c\u000e\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\tI$HA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0003o5\t1#];pi\u0006\u001cun\u001c:eS:\fGo\u001c:PaR\u00042aF\u001f@\u0013\tq\u0004D\u0001\u0004PaRLwN\u001c\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bQ!];pi\u0006T!\u0001R\b\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003\r\u0006\u0013\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0015\u0007!K%\n\u0005\u0002\u0014\u000b!)1\u0007\u0003a\u0001i!)1\b\u0003a\u0001y\u0005)\"/Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cX#A'\u0011\u0007\u0005\"c\n\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#bi\u0011A\u0015\u0006\u0003'F\ta\u0001\u0010:p_Rt\u0014BA+\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011Qf\u0016\u0006\u0003+b\tqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005ik\u0006CA\f\\\u0013\ta\u0006D\u0001\u0003V]&$\b\"\u00020\u000b\u0001\u0004y\u0016!\u00038fo\u000e{gNZ5h!\t\u0019\u0002-\u0003\u0002b\u001b\tY1*\u00194lC\u000e{gNZ5h\u0003-\u0011XmY8oM&<WO]3\u0015\u0007i#g\rC\u0003f\u0017\u0001\u0007q,A\u0005pY\u0012\u001cuN\u001c4jO\")al\u0003a\u0001?\u0002")
public class DynamicQuotaConfig
implements BrokerReconfigurable {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicQuotaConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicQuotaConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.clientQuotaMaxThrottleTimeMs()) < 0L) {
            throw new ConfigException("Updating client quota throttle time requires 'client.quota.max.throttle.time.ms' to be non negative");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().brokerLimitProducerConfig()) < 0L) {
            throw new ConfigException("Updating broker bandwidth throttle config require 'confluent.broker.limit.producer.bytes.per.second' to be non negative");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().brokerLimitConsumerConfig()) < 0L) {
            throw new ConfigException("Updating broker bandwidth throttle config require 'confluent.broker.limit.consumer.bytes.per.second' to be non negative");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Boolean bl = newConfig.confluentConfig().dynamicQuotaEnabled();
        Boolean bl2 = oldConfig.confluentConfig().dynamicQuotaEnabled();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            QuotaFactory.updateQuotaConsumptionReportingEnabled(Predef$.MODULE$.Boolean2boolean(newConfig.confluentConfig().dynamicQuotaEnabled()));
            OptionConverters$.MODULE$.toScala(this.quotaManagers.clientQuotaCallbackPlugin()).foreach((Function1<Plugin, Object> & Serializable)callback -> {
                DynamicQuotaConfig.$anonfun$reconfigure$29(newConfig, callback);
                return BoxedUnit.UNIT;
            });
            this.quotaCoordinatorOpt.foreach((Function1<QuotaCoordinator, Object> & Serializable)coordinator -> {
                coordinator.setActive(Predef$.MODULE$.Boolean2boolean(newConfig.confluentConfig().dynamicQuotaEnabled()));
                return BoxedUnit.UNIT;
            });
        }
        Long l = newConfig.clientQuotaMaxThrottleTimeMs();
        Long l2 = oldConfig.clientQuotaMaxThrottleTimeMs();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            this.quotaManagers.fetch().updateClientQuotaMaxThrottleTimeMs(Predef$.MODULE$.Long2long(newConfig.clientQuotaMaxThrottleTimeMs()));
            this.quotaManagers.produce().updateClientQuotaMaxThrottleTimeMs(Predef$.MODULE$.Long2long(newConfig.clientQuotaMaxThrottleTimeMs()));
        }
        Long l3 = newConfig.clientQuotaMaxThrottleTimeInResponseMs();
        Long l4 = oldConfig.clientQuotaMaxThrottleTimeInResponseMs();
        if (l3 == null ? l4 != null : !((Object)l3).equals(l4)) {
            this.quotaManagers.fetch().updateClientQuotaMaxThrottleTimeInResponseMs(Predef$.MODULE$.Long2long(newConfig.clientQuotaMaxThrottleTimeInResponseMs()));
            this.quotaManagers.produce().updateClientQuotaMaxThrottleTimeInResponseMs(Predef$.MODULE$.Long2long(newConfig.clientQuotaMaxThrottleTimeInResponseMs()));
        }
        Long l5 = newConfig.confluentConfig().brokerLimitProducerConfig();
        Long l6 = oldConfig.confluentConfig().brokerLimitProducerConfig();
        if (l5 == null ? l6 != null : !((Object)l5).equals(l6)) {
            this.quotaManagers.produce().dynamicUpdateBrokerQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().brokerLimitProducerConfig()));
            QuotaFactory.QuotaManagers.setBrokerQuotaLimitByType(QuotaType.toClientQuotaType(QuotaType.PRODUCE), Predef$.MODULE$.Long2long(newConfig.confluentConfig().brokerLimitProducerConfig()));
        }
        Long l7 = newConfig.confluentConfig().brokerLimitConsumerConfig();
        Long l8 = oldConfig.confluentConfig().brokerLimitConsumerConfig();
        if (l7 == null ? l8 != null : !((Object)l7).equals(l8)) {
            this.quotaManagers.fetch().dynamicUpdateBrokerQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().brokerLimitConsumerConfig()));
            QuotaFactory.QuotaManagers.setBrokerQuotaLimitByType(QuotaType.toClientQuotaType(QuotaType.FETCH), Predef$.MODULE$.Long2long(newConfig.confluentConfig().brokerLimitConsumerConfig()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$reconfigure$29(KafkaConfig newConfig$9, Plugin callback) {
        ((ClientQuotaCallback)callback.get()).enableDynamicQuota(Predef$.MODULE$.Boolean2boolean(newConfig$9.confluentConfig().dynamicQuotaEnabled()));
    }

    public DynamicQuotaConfig(QuotaFactory.QuotaManagers quotaManagers, Option<QuotaCoordinator> quotaCoordinatorOpt) {
        this.quotaManagers = quotaManagers;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
    }
}

