/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.conflux.concurrent.SemiCompletionStage;
import io.confluent.k2.kafka.K2Node;
import io.confluent.k2.kafka.K2Stack;
import io.confluent.k2.kafka.K2TopicMetadata;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import kafka.server.K2DeletingTopicGarbageCollector$;
import kafka.server.K2DeletingTopicGarbageCollector$DeleteFutureInfo$;
import kafka.server.K2DeletingTopicGarbageCollector$TopicAndPartitions$;
import kafka.server.metadata.K2MetadataCache;
import kafka.server.metadata.K2MetadataCache$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.immutable.ImmutableSet;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r%x!B2e\u0011\u0003Ig!B6e\u0011\u0003a\u0007\"B:\u0002\t\u0003!\bbB;\u0002\u0005\u0004%IA\u001e\u0005\u0007u\u0006\u0001\u000b\u0011B<\t\u000fm\f!\u0019!C\u0005m\"1A0\u0001Q\u0001\n]4Aa\u001b3\u0001{\"Q\u0011\u0011B\u0004\u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005\rrA!A!\u0002\u0013\t)\u0003\u0003\u0006\u0002<\u001d\u0011\t\u0011)A\u0005\u0003{A\u0011\"!\u0013\b\u0005\u0003\u0005\u000b\u0011B<\t\u0015\u0005-sA!A!\u0002\u0013\ti\u0005\u0003\u0004t\u000f\u0011\u0005\u00111\f\u0005\b\u0003S:A\u0011KA6\u0011\u001d\t\u0019i\u0002C\u0005\u0003\u000bC\u0011\"a\"\b\u0001\u0004%I!!#\t\u0013\u0005uv\u00011A\u0005\n\u0005}\u0006\u0002CAW\u000f\u0001\u0006K!a#\t\u0011\u0005Uw\u00011A\u0005\nYD\u0011\"a6\b\u0001\u0004%I!!7\t\u000f\u0005uw\u0001)Q\u0005o\"I\u0011q\\\u0004C\u0002\u0013%\u0011\u0011\u001d\u0005\t\u0003S<\u0001\u0015!\u0003\u0002d\u001a1\u00111^\u0004E\u0003[D!Ba\u0002\u0019\u0005+\u0007I\u0011\u0001B\u0005\u0011)\u00119\u0002\u0007B\tB\u0003%!1\u0002\u0005\u000b\u00053A\"Q3A\u0005\u0002\tm\u0001B\u0003B\u00191\tE\t\u0015!\u0003\u0003\u001e!11\u000f\u0007C\u0001\u0005gA\u0011B!\u0010\u0019\u0003\u0003%\tAa\u0010\t\u0013\t\u0015\u0003$%A\u0005\u0002\t\u001d\u0003\"\u0003B/1E\u0005I\u0011\u0001B0\u0011%\u0011\u0019\u0007GA\u0001\n\u0003\u0012)\u0007C\u0005\u0003la\t\t\u0011\"\u0001\u0002b\"I!Q\u000e\r\u0002\u0002\u0013\u0005!q\u000e\u0005\n\u0005gB\u0012\u0011!C!\u0005kB\u0011Ba!\u0019\u0003\u0003%\tA!\"\t\u0013\t5\u0005$!A\u0005B\t=\u0005\"\u0003BJ1\u0005\u0005I\u0011\tBK\u0011%\u00119\nGA\u0001\n\u0003\u0012I\nC\u0005\u0003\u001cb\t\t\u0011\"\u0011\u0003\u001e\u001eI!\u0011U\u0004\u0002\u0002#%!1\u0015\u0004\n\u0003W<\u0011\u0011!E\u0005\u0005KCaa]\u0016\u0005\u0002\tm\u0006\"\u0003BLW\u0005\u0005IQ\tBM\u0011%\u0011ilKA\u0001\n\u0003\u0013y\fC\u0005\u0003F.\n\t\u0011\"!\u0003H\u001a1!Q[\u0004E\u0005/D!B!71\u0005+\u0007I\u0011\u0001Bn\u0011)\u0011\u0019\u000f\rB\tB\u0003%!Q\u001c\u0005\u000b\u0005K\u0004$Q3A\u0005\u0002\t\u001d\bB\u0003Bya\tE\t\u0015!\u0003\u0003j\"I!1\u001f\u0019\u0003\u0016\u0004%\tA\u001e\u0005\n\u0005k\u0004$\u0011#Q\u0001\n]Daa\u001d\u0019\u0005\u0002\t]\bbBB\u0001a\u0011\u000511\u0001\u0005\n\u0005{\u0001\u0014\u0011!C\u0001\u0007\u0013A\u0011B!\u00121#\u0003%\ta!\u0005\t\u0013\tu\u0003'%A\u0005\u0002\rU\u0001\"CB\raE\u0005I\u0011AB\u000e\u0011%\u0011\u0019\u0007MA\u0001\n\u0003\u0012)\u0007C\u0005\u0003lA\n\t\u0011\"\u0001\u0002b\"I!Q\u000e\u0019\u0002\u0002\u0013\u00051q\u0004\u0005\n\u0005g\u0002\u0014\u0011!C!\u0005kB\u0011Ba!1\u0003\u0003%\taa\t\t\u0013\t5\u0005'!A\u0005B\r\u001d\u0002\"\u0003BJa\u0005\u0005I\u0011\tBK\u0011%\u00119\nMA\u0001\n\u0003\u0012I\nC\u0005\u0003\u001cB\n\t\u0011\"\u0011\u0004,\u001dI1qF\u0004\u0002\u0002#%1\u0011\u0007\u0004\n\u0005+<\u0011\u0011!E\u0005\u0007gAaa]$\u0005\u0002\rm\u0002\"\u0003BL\u000f\u0006\u0005IQ\tBM\u0011%\u0011ilRA\u0001\n\u0003\u001bi\u0004C\u0005\u0004F\u001d\u000b\n\u0011\"\u0001\u0004\u001c!I!QY$\u0002\u0002\u0013\u00055q\t\u0005\n\u0007':\u0015\u0013!C\u0001\u00077A\u0011b!\u0016\b\u0001\u0004%Iaa\u0016\t\u0013\rms\u00011A\u0005\n\ru\u0003\u0002CB1\u000f\u0001\u0006Ka!\u0017\t\u0013\r\rtA1A\u0005\n\r\u0015\u0004\u0002CB7\u000f\u0001\u0006Iaa\u001a\t\u0013\r=tA1A\u0005\n\rE\u0004\u0002CB@\u000f\u0001\u0006Iaa\u001d\t\u0011\r\u0005u\u00011A\u0005\nYD\u0011ba!\b\u0001\u0004%Ia!\"\t\u000f\r%u\u0001)Q\u0005o\"911R\u0004\u0005\n\r5\u0005bBBL\u000f\u0011\u00051\u0011\u0014\u0005\b\u00077;A\u0011ABM\u0011!\u0019ij\u0002C\u0001I\u000ee\u0005\u0002CBP\u000f\u0011\u0005Am!)\t\u000f\r\rv\u0001\"\u0003\u0004&\"911V\u0004\u0005\n\re\u0005bBBW\u000f\u0011%1q\u0016\u0005\b\u0007\u0003<A\u0011BBb\u0011\u001d\u0019)n\u0002C\u0005\u00073Cqaa6\b\t\u0013\u0019I.A\u0010Le\u0011+G.\u001a;j]\u001e$v\u000e]5d\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_JT!!\u001a4\u0002\rM,'O^3s\u0015\u00059\u0017!B6bM.\f7\u0001\u0001\t\u0003U\u0006i\u0011\u0001\u001a\u0002 \u0017J\"U\r\\3uS:<Gk\u001c9jG\u001e\u000b'OY1hK\u000e{G\u000e\\3di>\u00148CA\u0001n!\tq\u0017/D\u0001p\u0015\u0005\u0001\u0018!B:dC2\f\u0017B\u0001:p\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012![\u0001\u0013\u0007\"+5iS0F-\u0016\u0013\u0016lX'J\u00192K5+F\u0001x!\tq\u00070\u0003\u0002z_\n!Aj\u001c8h\u0003M\u0019\u0005*R\"L?\u00163VIU-`\u001b&cE*S*!\u00039i\u0015JT0C\u0003\u000e[uJ\u0012$`\u001bN\u000bq\"T%O?\n\u000b5iS(G\r~k5\u000bI\n\u0004\u000f5t\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u00071\u0017!B;uS2\u001c\u0018\u0002BA\u0004\u0003\u0003\u0011q\u0001T8hO&tw-\u0001\blC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0011\t\u00055\u0011qD\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005!Q\u000f^5m\u0015\r)\u0017Q\u0003\u0006\u0004O\u0006]!\u0002BA\r\u00037\ta!\u00199bG\",'BAA\u000f\u0003\ry'oZ\u0005\u0005\u0003C\tyA\u0001\bLC\u001a\\\u0017mU2iK\u0012,H.\u001a:\u0002\u000bM$\u0018mY6\u0011\t\u0005\u001d\u0012qG\u0007\u0003\u0003SQ1aZA\u0016\u0015\u0011\ti#a\f\u0002\u0005-\u0014$\u0002BA\u0019\u0003g\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005U\u0012AA5p\u0013\u0011\tI$!\u000b\u0003\u000f-\u00134\u000b^1dW\u0006y1NM'fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005Z\u0001\t[\u0016$\u0018\rZ1uC&!\u0011qIA!\u0005=Y%'T3uC\u0012\fG/Y\"bG\",\u0017\u0001G:uCJ$h*Z<U_BL7-\u0012<fefl\u0015\u000e\u001c7jg\u0006!A/[7f!\u0011\ty%a\u0016\u000e\u0005\u0005E#\u0002BA\u0002\u0003'RA!!\u0016\u0002\u0016\u000511m\\7n_:LA!!\u0017\u0002R\t!A+[7f)1\ti&a\u0018\u0002b\u0005\r\u0014QMA4!\tQw\u0001C\u0004\u0002\n5\u0001\r!a\u0003\t\u000f\u0005\rR\u00021\u0001\u0002&!9\u00111H\u0007A\u0002\u0005u\u0002BBA%\u001b\u0001\u0007q\u000fC\u0004\u0002L5\u0001\r!!\u0014\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0002nA!\u0011qNA?\u001d\u0011\t\t(!\u001f\u0011\u0007\u0005Mt.\u0004\u0002\u0002v)\u0019\u0011q\u000f5\u0002\rq\u0012xn\u001c;?\u0013\r\tYh\\\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0014\u0011\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005mt.A\ndkJ\u0014XM\u001c;ISJ+7o\u00117pG.l5\u000fF\u0001x\u0003\u0015Z'\u0007R3mKRLgn\u001a+pa&\u001cw)\u0019:cC\u001e,7i\u001c7mK\u000e$xN\u001d$viV\u0014X-\u0006\u0002\u0002\fB)a.!$\u0002\u0012&\u0019\u0011qR8\u0003\r=\u0003H/[8oa\u0011\t\u0019*!+\u0011\r\u0005U\u0015\u0011UAS\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015AC2p]\u000e,(O]3oi*!\u0011\u0011CAO\u0015\t\ty*\u0001\u0003kCZ\f\u0017\u0002BAR\u0003/\u0013qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0005\u0003O\u000bI\u000b\u0004\u0001\u0005\u0017\u0005-&#!A\u0001\u0002\u000b\u0005\u0011q\u0016\u0002\u0004?\u0012\n\u0014AJ63\t\u0016dW\r^5oOR{\u0007/[2HCJ\u0014\u0017mZ3D_2dWm\u0019;pe\u001a+H/\u001e:fAE!\u0011\u0011WA\\!\rq\u00171W\u0005\u0004\u0003k{'a\u0002(pi\"Lgn\u001a\t\u0004]\u0006e\u0016bAA^_\n\u0019\u0011I\\=\u0002S-\u0014D)\u001a7fi&tw\rV8qS\u000e<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGR|'OR;ukJ,w\fJ3r)\u0011\t\t-a2\u0011\u00079\f\u0019-C\u0002\u0002F>\u0014A!\u00168ji\"I\u0011\u0011Z\t\u0002\u0002\u0003\u0007\u00111Z\u0001\u0004q\u0012\n\u0004#\u00028\u0002\u000e\u00065\u0007\u0007BAh\u0003'\u0004b!!&\u0002\"\u0006E\u0007\u0003BAT\u0003'$A\"a+\u0002H\u0006\u0005\t\u0011!B\u0001\u0003_\u000b\u0001D\\3yiB{\u0007/\u001e7bi\u0016D\u0015NU3t\u00072|7m['t\u0003qqW\r\u001f;Q_B,H.\u0019;f\u0011&\u0014Vm]\"m_\u000e\\Wj]0%KF$B!!1\u0002\\\"A\u0011\u0011\u001a\u000b\u0002\u0002\u0003\u0007q/A\roKb$\bk\u001c9vY\u0006$X\rS5SKN\u001cEn\\2l\u001bN\u0004\u0013\u0001\u0004(P?B\u000b%\u000bV%U\u0013>sUCAAr!\rq\u0017Q]\u0005\u0004\u0003O|'aA%oi\u0006iajT0Q\u0003J#\u0016\nV%P\u001d\u0002\u0012\u0001\u0003R3mKR,g)\u001e;ve\u0016LeNZ8\u0014\rai\u0017q^A{!\rq\u0017\u0011_\u0005\u0004\u0003g|'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003o\u0014\tA\u0004\u0003\u0002z\u0006uh\u0002BA:\u0003wL\u0011\u0001]\u0005\u0004\u0003\u007f|\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005\u0007\u0011)A\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u0000>\f\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\t\tE\u0011QT\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0016\t=!aB%oi\u0016<WM]\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00024viV\u0014X-\u0006\u0002\u0003\u001eA1!q\u0004B\u0014\u0005Wi!A!\t\u000b\t\u0005e%1\u0005\u0006\u0005\u0005K\ty#A\u0004d_:4G.\u001e=\n\t\t%\"\u0011\u0005\u0002\u0014'\u0016l\u0017nQ8na2,G/[8o'R\fw-\u001a\t\u0005\u0005\u001b\u0011i#\u0003\u0003\u00030\t=!a\u0002\"p_2,\u0017M\\\u0001\bMV$XO]3!)\u0019\u0011)D!\u000f\u0003<A\u0019!q\u0007\r\u000e\u0003\u001dAqAa\u0002\u001e\u0001\u0004\u0011Y\u0001C\u0004\u0003\u001au\u0001\rA!\b\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005k\u0011\tEa\u0011\t\u0013\t\u001da\u0004%AA\u0002\t-\u0001\"\u0003B\r=A\u0005\t\u0019\u0001B\u000f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0013+\t\t-!1J\u0016\u0003\u0005\u001b\u0002BAa\u0014\u0003Z5\u0011!\u0011\u000b\u0006\u0005\u0005'\u0012)&A\u0005v]\u000eDWmY6fI*\u0019!qK8\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\\\tE#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B1U\u0011\u0011iBa\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0007\u0005\u0003\u0003\u000e\t%\u0014\u0002BA@\u0005\u001f\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00028\nE\u0004\"CAeG\u0005\u0005\t\u0019AAr\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B<!\u0019\u0011IHa \u000286\u0011!1\u0010\u0006\u0004\u0005{z\u0017AC2pY2,7\r^5p]&!!\u0011\u0011B>\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u001d%1\u0012\t\u0004]\n%\u0015b\u0001B\u0018_\"I\u0011\u0011Z\u0013\u0002\u0002\u0003\u0007\u0011qW\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003h\tE\u0005\"CAeM\u0005\u0005\t\u0019AAr\u0003!A\u0017m\u001d5D_\u0012,GCAAr\u0003!!xn\u0015;sS:<GC\u0001B4\u0003\u0019)\u0017/^1mgR!!q\u0011BP\u0011%\tI-KA\u0001\u0002\u0004\t9,\u0001\tEK2,G/\u001a$viV\u0014X-\u00138g_B\u0019!qG\u0016\u0014\u000b-\u00129Ka-\u0011\u0015\t%&q\u0016B\u0006\u0005;\u0011)$\u0004\u0002\u0003,*\u0019!QV8\u0002\u000fI,h\u000e^5nK&!!\u0011\u0017BV\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005k\u0013I,\u0004\u0002\u00038*!\u0011QGAO\u0013\u0011\u0011\u0019Aa.\u0015\u0005\t\r\u0016!B1qa2LHC\u0002B\u001b\u0005\u0003\u0014\u0019\rC\u0004\u0003\b9\u0002\rAa\u0003\t\u000f\tea\u00061\u0001\u0003\u001e\u00059QO\\1qa2LH\u0003\u0002Be\u0005#\u0004RA\\AG\u0005\u0017\u0004rA\u001cBg\u0005\u0017\u0011i\"C\u0002\u0003P>\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003Bj_\u0005\u0005\t\u0019\u0001B\u001b\u0003\rAH\u0005\r\u0002\u0013)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t7o\u0005\u00041[\u0006=\u0018Q_\u0001\u0006i>\u0004\u0018nY\u000b\u0003\u0005;\u0004B!a\n\u0003`&!!\u0011]A\u0015\u0005=Y%\u0007V8qS\u000elU\r^1eCR\f\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N,\"A!;\u0011\u0011\t-(Q\u001eB\u0006\u0005\u0017i!!a'\n\t\t=\u00181\u0014\u0002\b\u0011\u0006\u001c\b.T1q\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002\u001b1\f7\u000f\u001e\"bG.|gMZ't\u00039a\u0017m\u001d;CC\u000e\\wN\u001a4Ng\u0002\"\u0002B!?\u0003|\nu(q \t\u0004\u0005o\u0001\u0004b\u0002Bmo\u0001\u0007!Q\u001c\u0005\b\u0005K<\u0004\u0019\u0001Bu\u0011!\u0011\u0019p\u000eI\u0001\u0002\u00049\u0018aD<ji\"tU\r\u001f;CC\u000e\\wN\u001a4\u0015\t\te8Q\u0001\u0005\u0007\u0007\u000fA\u0004\u0019A<\u0002\u001b9,\u0007\u0010\u001e\"bG.|gMZ't)!\u0011Ipa\u0003\u0004\u000e\r=\u0001\"\u0003BmsA\u0005\t\u0019\u0001Bo\u0011%\u0011)/\u000fI\u0001\u0002\u0004\u0011I\u000f\u0003\u0005\u0003tf\u0002\n\u00111\u0001x+\t\u0019\u0019B\u000b\u0003\u0003^\n-SCAB\fU\u0011\u0011IOa\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\u0004\u0016\u0004o\n-C\u0003BA\\\u0007CA\u0011\"!3@\u0003\u0003\u0005\r!a9\u0015\t\t\u001d5Q\u0005\u0005\n\u0003\u0013\f\u0015\u0011!a\u0001\u0003o#BAa\u001a\u0004*!I\u0011\u0011\u001a\"\u0002\u0002\u0003\u0007\u00111\u001d\u000b\u0005\u0005\u000f\u001bi\u0003C\u0005\u0002J\u0016\u000b\t\u00111\u0001\u00028\u0006\u0011Bk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8t!\r\u00119dR\n\u0006\u000f\u000eU\"1\u0017\t\f\u0005S\u001b9D!8\u0003j^\u0014I0\u0003\u0003\u0004:\t-&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u00111\u0011\u0007\u000b\t\u0005s\u001cyd!\u0011\u0004D!9!\u0011\u001c&A\u0002\tu\u0007b\u0002Bs\u0015\u0002\u0007!\u0011\u001e\u0005\t\u0005gT\u0005\u0013!a\u0001o\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0006\u0003\u0004J\rE\u0003#\u00028\u0002\u000e\u000e-\u0003\u0003\u00038\u0004N\tu'\u0011^<\n\u0007\r=sN\u0001\u0004UkBdWm\r\u0005\n\u0005'd\u0015\u0011!a\u0001\u0005s\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014aD2veJ,g\u000e\u001e*v]N#\u0018\r^3\u0016\u0005\re\u0003#\u00028\u0002\u000e\ne\u0018aE2veJ,g\u000e\u001e*v]N#\u0018\r^3`I\u0015\fH\u0003BAa\u0007?B\u0011\"!3P\u0003\u0003\u0005\ra!\u0017\u0002!\r,(O]3oiJ+hn\u0015;bi\u0016\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\r\u001d\u0004\u0003BAK\u0007SJAaa\u001b\u0002\u0018\nyQ\t_3dkR|'oU3sm&\u001cW-A\u0005fq\u0016\u001cW\u000f^8sA\u00051!/\u00198e_6,\"aa\u001d\u0011\t\rU41P\u0007\u0003\u0007oRAa!\u001f\u0002\u001e\u0006A1/Z2ve&$\u00180\u0003\u0003\u0004~\r]$\u0001D*fGV\u0014XMU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\u0014Y\u0006\u001cH\u000fT8h\u0011&\u0014Vm]\"m_\u000e\\Wj]\u0001\u0018Y\u0006\u001cH\u000fT8h\u0011&\u0014Vm]\"m_\u000e\\Wj]0%KF$B!!1\u0004\b\"A\u0011\u0011\u001a,\u0002\u0002\u0003\u0007q/\u0001\u000bmCN$Hj\\4ISJ+7o\u00117pG.l5\u000fI\u0001\u000fY><WI^3ss6KG\u000e\\5t)\u0019\t\tma$\u0004\u0014\"11\u0011\u0013-A\u0002]\fQ#\u0019;N_N$xJ\\2f\u000bZ,'/_'jY2L7\u000fC\u0004\u0004\u0016b\u0003\r!!\u001c\u0002\u000f5,7o]1hK\u000691\u000f^1siV\u0004HCAAa\u0003\u0015\u0019Gn\\:f\u0003M!wnR1sE\u0006<WmQ8mY\u0016\u001cG/[8o\u0003iI7oQ;se\u0016tG\u000f\\=X_J\\\u0017N\\4P]\u0006#v\u000e]5d+\t\u00119)A\u000ebaB,g\u000eZ,iK:\u001cu.\u001c9mKR,\u0017i]=oGN#X\r\u001d\u000b\u0005\u0003\u0003\u001c9\u000bC\u0004\u0004*v\u0003\rA!\u000e\u0002\t%tgm\\\u0001#[\u0006L(-Z*vE6LGOT3yiN#X\r\u001d$pe\u000e+(O]3oiR{\u0007/[2\u0002\u001fI\fg\u000eZ8n)>\u0004\u0018n\u0019$s_6$BA!8\u00042\"911W0A\u0002\rU\u0016A\u00043fY\u0016$\u0018N\\4U_BL7m\u001d\t\u0007\u0007o\u001biL!8\u000e\u0005\re&\u0002BB^\u0003'\t\u0011\"[7nkR\f'\r\\3\n\t\r}6\u0011\u0018\u0002\r\u00136lW\u000f^1cY\u0016\u001cV\r^\u0001\u001ae\u0006tGm\\7FY\u0016lWM\u001c;Ge>lgj\u001c8F[B$\u00180\u0006\u0003\u0004F\u000e%G\u0003BBd\u0007\u001b\u0004B!a*\u0004J\u0012911\u001a1C\u0002\u0005=&!\u0001+\t\u000f\tu\u0004\r1\u0001\u0004PB1!1^Bi\u0007\u000fLAaa5\u0002\u001c\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u000231|wMT3yiJ+h\u000eV5nKV\u0003xN\\*vG\u000e,7o]\u0001\u0017Y><\u0017I\u001c3SKR\u0014\u0018pV5uQ\n\u000b7m[8gMR1\u0011\u0011YBn\u0007;Dqa!&c\u0001\u0004\ti\u0007C\u0004\u0004`\n\u0004\ra!9\u0002\u0013QD'o\\<bE2,\u0007#\u00028\u0002\u000e\u000e\r\b\u0003BA|\u0007KLAaa:\u0003\u0006\tIA\u000b\u001b:po\u0006\u0014G.\u001a")
public class K2DeletingTopicGarbageCollector
implements Logging {
    private volatile K2DeletingTopicGarbageCollector$DeleteFutureInfo$ DeleteFutureInfo$module;
    private volatile K2DeletingTopicGarbageCollector$TopicAndPartitions$ TopicAndPartitions$module;
    private final KafkaScheduler kafkaScheduler;
    private final K2Stack stack;
    private final K2MetadataCache k2MetadataCache;
    private final long startNewTopicEveryMillis;
    private final Time time;
    private Option<ScheduledFuture<?>> k2DeletingTopicGarbageCollectorFuture;
    private long nextPopulateHiResClockMs;
    private final int NO_PARTITION;
    private Option<TopicAndPartitions> currentRunState;
    private final ExecutorService executor;
    private final SecureRandom random;
    private long lastLogHiResClockMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private K2DeletingTopicGarbageCollector$DeleteFutureInfo$ DeleteFutureInfo() {
        if (this.DeleteFutureInfo$module == null) {
            this.DeleteFutureInfo$lzycompute$1();
        }
        return this.DeleteFutureInfo$module;
    }

    private K2DeletingTopicGarbageCollector$TopicAndPartitions$ TopicAndPartitions() {
        if (this.TopicAndPartitions$module == null) {
            this.TopicAndPartitions$lzycompute$1();
        }
        return this.TopicAndPartitions$module;
    }

    private Logger logger$lzycompute() {
        K2DeletingTopicGarbageCollector k2DeletingTopicGarbageCollector = this;
        synchronized (k2DeletingTopicGarbageCollector) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    private long currentHiResClockMs() {
        return this.time.hiResClockMs();
    }

    private Option<ScheduledFuture<?>> k2DeletingTopicGarbageCollectorFuture() {
        return this.k2DeletingTopicGarbageCollectorFuture;
    }

    private void k2DeletingTopicGarbageCollectorFuture_$eq(Option<ScheduledFuture<?>> x$1) {
        this.k2DeletingTopicGarbageCollectorFuture = x$1;
    }

    private long nextPopulateHiResClockMs() {
        return this.nextPopulateHiResClockMs;
    }

    private void nextPopulateHiResClockMs_$eq(long x$1) {
        this.nextPopulateHiResClockMs = x$1;
    }

    private int NO_PARTITION() {
        return this.NO_PARTITION;
    }

    private Option<TopicAndPartitions> currentRunState() {
        return this.currentRunState;
    }

    private void currentRunState_$eq(Option<TopicAndPartitions> x$1) {
        this.currentRunState = x$1;
    }

    private ExecutorService executor() {
        return this.executor;
    }

    private SecureRandom random() {
        return this.random;
    }

    private long lastLogHiResClockMs() {
        return this.lastLogHiResClockMs;
    }

    private void lastLogHiResClockMs_$eq(long x$1) {
        this.lastLogHiResClockMs = x$1;
    }

    private void logEveryMillis(long atMostOnceEveryMillis, String message) {
        long nowHiResClockMs = this.time.hiResClockMs();
        if (nowHiResClockMs - this.lastLogHiResClockMs() > atMostOnceEveryMillis) {
            this.lastLogHiResClockMs_$eq(nowHiResClockMs);
            this.info((Function0<String> & Serializable)() -> message);
            return;
        }
    }

    public synchronized void startup() {
        this.k2DeletingTopicGarbageCollectorFuture_$eq(new Some(this.kafkaScheduler.schedule("k2deletingtopicgarbagecollector", () -> this.doGarbageCollection(), 0L, K2DeletingTopicGarbageCollector$.MODULE$.kafka$server$K2DeletingTopicGarbageCollector$$CHECK_EVERY_MILLIS())));
    }

    public void close() {
        K2DeletingTopicGarbageCollector k2DeletingTopicGarbageCollector = this;
        synchronized (k2DeletingTopicGarbageCollector) {
            this.k2DeletingTopicGarbageCollectorFuture().foreach((Function1<ScheduledFuture, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.cancel(true)));
            this.executor().shutdownNow();
        }
    }

    public synchronized void doGarbageCollection() {
        try {
            long nextRunHiResClockMs;
            boolean beforeNextRunTime;
            boolean backingOff = BoxesRunTime.unboxToBoolean(this.currentRunState().flatMap((Function1<TopicAndPartitions, Some> & Serializable)currentState -> new Some<Boolean>(BoxesRunTime.boxToBoolean(currentState.lastBackoffMs() > 0L))).getOrElse(() -> false));
            if (this.isCurrentlyWorkingOnATopic() && !backingOff) {
                this.logEveryMillis(1000L, "Skipping (a partition deletion or topic removal is already running)");
                return;
            }
            if (!this.isCurrentlyWorkingOnATopic() && this.k2MetadataCache.eligibleControllerNodes().stream().noneMatch(node -> BoxesRunTime.equalsNumObject(K2MetadataCache$.MODULE$.toBrokerId((K2Node)node), BoxesRunTime.boxToInteger($this.k2MetadataCache.brokerId())))) {
                this.logEveryMillis(60000L, "Skipping starting a new topic because this broker is not an eligible K2 controller");
                return;
            }
            long nowHiResClockMs = this.currentHiResClockMs();
            boolean bl = beforeNextRunTime = nowHiResClockMs < (nextRunHiResClockMs = this.nextPopulateHiResClockMs());
            if (beforeNextRunTime) {
                long nextRunInMs = nextRunHiResClockMs - nowHiResClockMs;
                if (backingOff) {
                    this.logEveryMillis(1000L, "Skipping (we are backing off due to an error, expect next run no sooner than " + nextRunInMs + " ms from now)");
                } else {
                    this.logEveryMillis(1000L, "Skipping (startNewTopicEveryMillis=" + this.startNewTopicEveryMillis + " has not yet elapsed since the last update successfully completed, expect next run no sooner than " + nextRunInMs + " ms from now)");
                }
                return;
            }
            if (!this.isCurrentlyWorkingOnATopic()) {
                ImmutableSet<K2TopicMetadata> deletingTopics = this.k2MetadataCache.deletingTopics();
                if (deletingTopics.isEmpty()) {
                    this.logNextRunTimeUponSuccess();
                    return;
                }
                K2TopicMetadata randomTopic = this.randomTopicFrom(deletingTopics);
                HashMap<Integer, Integer> partitions = new HashMap<Integer, Integer>();
                package$.MODULE$.Range().apply(0, randomTopic.numPartitions()).foreach((Function1<Object, Integer> & Serializable)partition -> partitions.put(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(partition)), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(partition))));
                this.currentRunState_$eq(new Some<TopicAndPartitions>(new TopicAndPartitions(this, randomTopic, partitions, this.TopicAndPartitions().apply$default$3())));
            }
            try {
                this.maybeSubmitNextStepForCurrentTopic();
            }
            catch (Throwable t) {
                this.logAndRetryWithBackoff("Couldn't submit partition garbage collection", new Some<Throwable>(t));
            }
        }
        catch (Throwable t) {
            this.logAndRetryWithBackoff("Couldn't garbage collect partitions", new Some<Throwable>(t));
        }
    }

    public synchronized boolean isCurrentlyWorkingOnATopic() {
        return this.currentRunState().nonEmpty();
    }

    private void appendWhenCompleteAsyncStep(DeleteFutureInfo info) {
        info.future().whenCompleteAsyncRaw((deleted, throwable) -> {
            K2DeletingTopicGarbageCollector k2DeletingTopicGarbageCollector = this;
            synchronized (k2DeletingTopicGarbageCollector) {
                Integer partition = info.partition();
                TopicAndPartitions currentState = this.currentRunState().get();
                K2TopicMetadata topic = currentState.topic();
                HashMap<Integer, Integer> partitions = currentState.partitions();
                Uuid topicId = topic.topicId();
                this.liftedTree1$1((Throwable)throwable, partition, topicId, (Boolean)deleted, partitions, topic);
            }
        }, this.executor());
    }

    private void maybeSubmitNextStepForCurrentTopic() {
        DeleteFutureInfo deleteFutureInfo;
        TopicAndPartitions currentState = this.currentRunState().get();
        K2TopicMetadata topic = currentState.topic();
        Uuid topicId = topic.topicId();
        HashMap<Integer, Integer> partitions = currentState.partitions();
        if (!this.k2MetadataCache.deletingTopics().contains(topic)) {
            this.info((Function0<String> & Serializable)() -> "Partition deletion and topic removal finished elsewhere for " + topicId);
            this.currentRunState_$eq(None$.MODULE$);
            this.logNextRunTimeUponSuccess();
            return;
        }
        if (!partitions.isEmpty()) {
            Integer nextPartition = this.randomElementFromNonEmpty(partitions.keySet());
            deleteFutureInfo = new DeleteFutureInfo(this, nextPartition, this.stack.k2ControllerHandler().tryToFinishPartitionDeletion(topicId, Predef$.MODULE$.Integer2int(nextPartition)));
        } else {
            deleteFutureInfo = new DeleteFutureInfo(this, Predef$.MODULE$.int2Integer(this.NO_PARTITION()), this.stack.k2ControllerHandler().removeTopicAfterGarbageCollectionComplete(topicId));
        }
        DeleteFutureInfo futureInfo = deleteFutureInfo;
        this.appendWhenCompleteAsyncStep(futureInfo);
        Integer partition = futureInfo.partition();
        String messagePrefix = BoxesRunTime.equalsNumObject(partition, BoxesRunTime.boxToInteger(this.NO_PARTITION())) ? "Removing topic " + topicId : "Deleting partition " + partition + " of topic " + topicId;
        long lastBackoffMs = currentState.lastBackoffMs();
        if (lastBackoffMs > 0L) {
            this.info((Function0<String> & Serializable)() -> messagePrefix + " (backoff of at least " + lastBackoffMs + " ms has elapsed since the last update failure)");
            return;
        }
        this.info((Function0<String> & Serializable)() -> messagePrefix + " (startNewTopicEveryMillis=" + $this.startNewTopicEveryMillis + " has elapsed since the last successful deletion)");
    }

    private K2TopicMetadata randomTopicFrom(ImmutableSet<K2TopicMetadata> deletingTopics) {
        return this.randomElementFromNonEmpty(deletingTopics);
    }

    private <T> T randomElementFromNonEmpty(Collection<T> collection) {
        return collection.stream().skip(this.random().nextInt(collection.size())).findFirst().get();
    }

    private void logNextRunTimeUponSuccess() {
        this.info((Function0<String> & Serializable)() -> "Partition deletion complete, next update in " + $this.startNewTopicEveryMillis + " ms");
        this.nextPopulateHiResClockMs_$eq(this.currentHiResClockMs() + this.startNewTopicEveryMillis);
    }

    private void logAndRetryWithBackoff(String message, Option<Throwable> throwable) {
        long backoffMs = Math.max(this.startNewTopicEveryMillis, Math.min(K2DeletingTopicGarbageCollector$.MODULE$.kafka$server$K2DeletingTopicGarbageCollector$$MIN_BACKOFF_MS(), this.currentRunState().get().lastBackoffMs() * 2L));
        String messageToLog = message + "; backing off for " + backoffMs + " ms";
        Option<Throwable> option = throwable;
        if (option instanceof Some) {
            Some some = (Some)option;
            Throwable t = (Throwable)some.value();
            this.error((Function0<String> & Serializable)() -> messageToLog, (Function0<Throwable> & Serializable)() -> t);
        } else if (None$.MODULE$.equals(option)) {
            this.info((Function0<String> & Serializable)() -> messageToLog);
        } else {
            throw new MatchError(option);
        }
        this.currentRunState_$eq(this.currentRunState().map((Function1<TopicAndPartitions, TopicAndPartitions> & Serializable)x$2 -> x$2.withNextBackoff(backoffMs)));
        this.nextPopulateHiResClockMs_$eq(this.currentHiResClockMs() + backoffMs);
    }

    private final void DeleteFutureInfo$lzycompute$1() {
        K2DeletingTopicGarbageCollector k2DeletingTopicGarbageCollector = this;
        synchronized (k2DeletingTopicGarbageCollector) {
            if (this.DeleteFutureInfo$module == null) {
                this.DeleteFutureInfo$module = new K2DeletingTopicGarbageCollector$DeleteFutureInfo$(this);
            }
        }
    }

    private final void TopicAndPartitions$lzycompute$1() {
        K2DeletingTopicGarbageCollector k2DeletingTopicGarbageCollector = this;
        synchronized (k2DeletingTopicGarbageCollector) {
            if (this.TopicAndPartitions$module == null) {
                this.TopicAndPartitions$module = new K2DeletingTopicGarbageCollector$TopicAndPartitions$(this);
            }
        }
    }

    private final /* synthetic */ void liftedTree1$1(Throwable throwable$1, Integer partition$1, Uuid topicId$1, Boolean deleted$1, HashMap partitions$2, K2TopicMetadata topic$1) {
        block5: {
            try {
                if (throwable$1 != null) {
                    String message = BoxesRunTime.equalsNumObject(partition$1, BoxesRunTime.boxToInteger(this.NO_PARTITION())) ? (throwable$1 instanceof IllegalStateException ? "Error removing topic " + topicId$1 + " from topic metadata because it was not in the DELETING state (should never happen)" : "Error removing topic " + topicId$1 + " from topic metadata") : "Error deleting partition " + partition$1 + " of topic " + topicId$1;
                    this.logAndRetryWithBackoff(message, new Some<Throwable>(throwable$1));
                    break block5;
                }
                if (!Predef$.MODULE$.Boolean2boolean(deleted$1)) {
                    String message = BoxesRunTime.equalsNumObject(partition$1, BoxesRunTime.boxToInteger(this.NO_PARTITION())) ? "Removing topic " + topicId$1 + " returned false" : "Deleting partition " + partition$1 + " of topic " + topicId$1 + " returned false";
                    this.logAndRetryWithBackoff(message, None$.MODULE$);
                    break block5;
                }
                if (!BoxesRunTime.equalsNumObject(partition$1, BoxesRunTime.boxToInteger(this.NO_PARTITION()))) {
                    partitions$2.remove(partition$1);
                    this.currentRunState_$eq(new Some<TopicAndPartitions>(new TopicAndPartitions(this, topic$1, partitions$2, this.TopicAndPartitions().apply$default$3())));
                    this.maybeSubmitNextStepForCurrentTopic();
                    break block5;
                }
                this.currentRunState_$eq(None$.MODULE$);
                this.logNextRunTimeUponSuccess();
            }
            catch (Throwable t) {
                String message = BoxesRunTime.equalsNumObject(partition$1, BoxesRunTime.boxToInteger(this.NO_PARTITION())) ? "Error handling topic removal completion for topic " + topicId$1 : "Error handling partition deletion for partition " + partition$1 + " of topic " + topicId$1;
                this.logAndRetryWithBackoff(message, new Some<Throwable>(t));
            }
        }
    }

    public K2DeletingTopicGarbageCollector(KafkaScheduler kafkaScheduler, K2Stack stack, K2MetadataCache k2MetadataCache, long startNewTopicEveryMillis, Time time) {
        this.kafkaScheduler = kafkaScheduler;
        this.stack = stack;
        this.k2MetadataCache = k2MetadataCache;
        this.startNewTopicEveryMillis = startNewTopicEveryMillis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[" + this.getClass().getSimpleName() + " brokerId=" + k2MetadataCache.brokerId() + "] ");
        this.k2DeletingTopicGarbageCollectorFuture = None$.MODULE$;
        this.nextPopulateHiResClockMs = Long.MIN_VALUE;
        this.NO_PARTITION = -1;
        this.currentRunState = None$.MODULE$;
        this.executor = Executors.newSingleThreadExecutor();
        this.random = new SecureRandom();
        this.lastLogHiResClockMs = Long.MIN_VALUE;
    }

    private class DeleteFutureInfo
    implements Product,
    Serializable {
        private final Integer partition;
        private final SemiCompletionStage<Boolean> future;
        public final /* synthetic */ K2DeletingTopicGarbageCollector $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public Integer partition() {
            return this.partition;
        }

        public SemiCompletionStage<Boolean> future() {
            return this.future;
        }

        public DeleteFutureInfo copy(Integer partition, SemiCompletionStage<Boolean> future) {
            return new DeleteFutureInfo(this.kafka$server$K2DeletingTopicGarbageCollector$DeleteFutureInfo$$$outer(), partition, future);
        }

        public Integer copy$default$1() {
            return this.partition();
        }

        public SemiCompletionStage<Boolean> copy$default$2() {
            return this.future();
        }

        @Override
        public String productPrefix() {
            return "DeleteFutureInfo";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.partition();
                }
                case 1: {
                    return this.future();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof DeleteFutureInfo;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "partition";
                }
                case 1: {
                    return "future";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof DeleteFutureInfo)) return false;
            if (((DeleteFutureInfo)object).kafka$server$K2DeletingTopicGarbageCollector$DeleteFutureInfo$$$outer() != this.kafka$server$K2DeletingTopicGarbageCollector$DeleteFutureInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DeleteFutureInfo deleteFutureInfo = (DeleteFutureInfo)x$1;
            Integer n = this.partition();
            Integer n2 = deleteFutureInfo.partition();
            if (n == null) {
                if (n2 != null) {
                    return false;
                }
            } else if (!((Object)n).equals(n2)) return false;
            SemiCompletionStage<Boolean> semiCompletionStage = this.future();
            SemiCompletionStage<Boolean> semiCompletionStage2 = deleteFutureInfo.future();
            if (semiCompletionStage == null) {
                if (semiCompletionStage2 != null) {
                    return false;
                }
            } else if (!semiCompletionStage.equals(semiCompletionStage2)) return false;
            if (!deleteFutureInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ K2DeletingTopicGarbageCollector kafka$server$K2DeletingTopicGarbageCollector$DeleteFutureInfo$$$outer() {
            return this.$outer;
        }

        public DeleteFutureInfo(K2DeletingTopicGarbageCollector $outer, Integer partition, SemiCompletionStage<Boolean> future) {
            this.partition = partition;
            this.future = future;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }

    private class TopicAndPartitions
    implements Product,
    Serializable {
        private final K2TopicMetadata topic;
        private final HashMap<Integer, Integer> partitions;
        private final long lastBackoffMs;
        public final /* synthetic */ K2DeletingTopicGarbageCollector $outer;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public K2TopicMetadata topic() {
            return this.topic;
        }

        public HashMap<Integer, Integer> partitions() {
            return this.partitions;
        }

        public long lastBackoffMs() {
            return this.lastBackoffMs;
        }

        public TopicAndPartitions withNextBackoff(long nextBackoffMs) {
            if (nextBackoffMs < 0L) {
                throw new IllegalArgumentException("nextBackoffMs must be non-negative, but was " + nextBackoffMs);
            }
            return new TopicAndPartitions(this.kafka$server$K2DeletingTopicGarbageCollector$TopicAndPartitions$$$outer(), this.topic(), this.partitions(), nextBackoffMs);
        }

        public TopicAndPartitions copy(K2TopicMetadata topic, HashMap<Integer, Integer> partitions, long lastBackoffMs) {
            return new TopicAndPartitions(this.kafka$server$K2DeletingTopicGarbageCollector$TopicAndPartitions$$$outer(), topic, partitions, lastBackoffMs);
        }

        public K2TopicMetadata copy$default$1() {
            return this.topic();
        }

        public HashMap<Integer, Integer> copy$default$2() {
            return this.partitions();
        }

        public long copy$default$3() {
            return this.lastBackoffMs();
        }

        @Override
        public String productPrefix() {
            return "TopicAndPartitions";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.topic();
                }
                case 1: {
                    return this.partitions();
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this.lastBackoffMs());
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof TopicAndPartitions;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "topic";
                }
                case 1: {
                    return "partitions";
                }
                case 2: {
                    return "lastBackoffMs";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.topic()));
            n = Statics.mix(n, Statics.anyHash(this.partitions()));
            n = Statics.mix(n, Statics.longHash(this.lastBackoffMs()));
            return Statics.finalizeHash(n, 3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TopicAndPartitions)) return false;
            if (((TopicAndPartitions)object).kafka$server$K2DeletingTopicGarbageCollector$TopicAndPartitions$$$outer() != this.kafka$server$K2DeletingTopicGarbageCollector$TopicAndPartitions$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TopicAndPartitions topicAndPartitions = (TopicAndPartitions)x$1;
            if (this.lastBackoffMs() != topicAndPartitions.lastBackoffMs()) return false;
            K2TopicMetadata k2TopicMetadata = this.topic();
            K2TopicMetadata k2TopicMetadata2 = topicAndPartitions.topic();
            if (k2TopicMetadata == null) {
                if (k2TopicMetadata2 != null) {
                    return false;
                }
            } else if (!((Object)k2TopicMetadata).equals(k2TopicMetadata2)) return false;
            HashMap<Integer, Integer> hashMap = this.partitions();
            HashMap<Integer, Integer> hashMap2 = topicAndPartitions.partitions();
            if (hashMap == null) {
                if (hashMap2 != null) {
                    return false;
                }
            } else if (!((Object)hashMap).equals(hashMap2)) return false;
            if (!topicAndPartitions.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ K2DeletingTopicGarbageCollector kafka$server$K2DeletingTopicGarbageCollector$TopicAndPartitions$$$outer() {
            return this.$outer;
        }

        public TopicAndPartitions(K2DeletingTopicGarbageCollector $outer, K2TopicMetadata topic, HashMap<Integer, Integer> partitions, long lastBackoffMs) {
            this.topic = topic;
            this.partitions = partitions;
            this.lastBackoffMs = lastBackoffMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

